<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for KSevkAdres StructType
 * @subpackage Structs
 */
class KSevkAdres extends Entity
{
    /**
     * The Tipi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Tipi;
    /**
     * The Adresi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\KAdresPointer
     */
    public $Adresi;
    /**
     * The Adi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Adi;
    /**
     * The Aciklama
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Aciklama;
    /**
     * The Carisi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\KCariPointer
     */
    public $Carisi;
    /**
     * The DagitimSube
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\KSubePointer
     */
    public $DagitimSube;
    /**
     * Constructor method for KSevkAdres
     * @uses KSevkAdres::setTipi()
     * @uses KSevkAdres::setAdresi()
     * @uses KSevkAdres::setAdi()
     * @uses KSevkAdres::setAciklama()
     * @uses KSevkAdres::setCarisi()
     * @uses KSevkAdres::setDagitimSube()
     * @param string $tipi
     * @param \StructType\KAdresPointer $adresi
     * @param string $adi
     * @param string $aciklama
     * @param \StructType\KCariPointer $carisi
     * @param \StructType\KSubePointer $dagitimSube
     */
    public function __construct($tipi = null, \StructType\KAdresPointer $adresi = null, $adi = null, $aciklama = null, \StructType\KCariPointer $carisi = null, \StructType\KSubePointer $dagitimSube = null)
    {
        $this
            ->setTipi($tipi)
            ->setAdresi($adresi)
            ->setAdi($adi)
            ->setAciklama($aciklama)
            ->setCarisi($carisi)
            ->setDagitimSube($dagitimSube);
    }
    /**
     * Get Tipi value
     * @return string
     */
    public function getTipi()
    {
        return $this->Tipi;
    }
    /**
     * Set Tipi value
     * @uses \EnumType\SevkAdresTip::valueIsValid()
     * @uses \EnumType\SevkAdresTip::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $tipi
     * @return \StructType\KSevkAdres
     */
    public function setTipi($tipi = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\SevkAdresTip::valueIsValid($tipi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\SevkAdresTip', is_array($tipi) ? implode(', ', $tipi) : var_export($tipi, true), implode(', ', \EnumType\SevkAdresTip::getValidValues())), __LINE__);
        }
        $this->Tipi = $tipi;
        return $this;
    }
    /**
     * Get Adresi value
     * @return \StructType\KAdresPointer|null
     */
    public function getAdresi()
    {
        return $this->Adresi;
    }
    /**
     * Set Adresi value
     * @param \StructType\KAdresPointer $adresi
     * @return \StructType\KSevkAdres
     */
    public function setAdresi(\StructType\KAdresPointer $adresi = null)
    {
        $this->Adresi = $adresi;
        return $this;
    }
    /**
     * Get Adi value
     * @return string|null
     */
    public function getAdi()
    {
        return $this->Adi;
    }
    /**
     * Set Adi value
     * @param string $adi
     * @return \StructType\KSevkAdres
     */
    public function setAdi($adi = null)
    {
        // validation for constraint: string
        if (!is_null($adi) && !is_string($adi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($adi, true), gettype($adi)), __LINE__);
        }
        $this->Adi = $adi;
        return $this;
    }
    /**
     * Get Aciklama value
     * @return string|null
     */
    public function getAciklama()
    {
        return $this->Aciklama;
    }
    /**
     * Set Aciklama value
     * @param string $aciklama
     * @return \StructType\KSevkAdres
     */
    public function setAciklama($aciklama = null)
    {
        // validation for constraint: string
        if (!is_null($aciklama) && !is_string($aciklama)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aciklama, true), gettype($aciklama)), __LINE__);
        }
        $this->Aciklama = $aciklama;
        return $this;
    }
    /**
     * Get Carisi value
     * @return \StructType\KCariPointer|null
     */
    public function getCarisi()
    {
        return $this->Carisi;
    }
    /**
     * Set Carisi value
     * @param \StructType\KCariPointer $carisi
     * @return \StructType\KSevkAdres
     */
    public function setCarisi(\StructType\KCariPointer $carisi = null)
    {
        $this->Carisi = $carisi;
        return $this;
    }
    /**
     * Get DagitimSube value
     * @return \StructType\KSubePointer|null
     */
    public function getDagitimSube()
    {
        return $this->DagitimSube;
    }
    /**
     * Set DagitimSube value
     * @param \StructType\KSubePointer $dagitimSube
     * @return \StructType\KSevkAdres
     */
    public function setDagitimSube(\StructType\KSubePointer $dagitimSube = null)
    {
        $this->DagitimSube = $dagitimSube;
        return $this;
    }
}
