<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for KKOCariHareketi StructType
 * @subpackage Structs
 */
class KKOCariHareketi extends Entity
{
    /**
     * The HareketSebebi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $HareketSebebi;
    /**
     * The EvrakObjId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $EvrakObjId;
    /**
     * The Tarih
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Tarih;
    /**
     * The TahsilatEvrakObjId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $TahsilatEvrakObjId;
    /**
     * The EvrakTuru
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $EvrakTuru;
    /**
     * The EvrakGonderimSekli
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $EvrakGonderimSekli;
    /**
     * The SiraNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $SiraNo;
    /**
     * The EvrakTarihi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $EvrakTarihi;
    /**
     * The Cari
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\KCariPointer
     */
    public $Cari;
    /**
     * The Borc
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\DovizliTutar
     */
    public $Borc;
    /**
     * The Alacak
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\DovizliTutar
     */
    public $Alacak;
    /**
     * The EvrakNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EvrakNo;
    /**
     * The Sube
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\KSubePointer
     */
    public $Sube;
    /**
     * The Aciklama
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Aciklama;
    /**
     * The TahsilatTipi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TahsilatTipi;
    /**
     * The BankaHesabi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\BankaHesabiPointer
     */
    public $BankaHesabi;
    /**
     * The KOTaksit
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\KKOTaksitPointer
     */
    public $KOTaksit;
    /**
     * The SeriNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SeriNo;
    /**
     * Constructor method for KKOCariHareketi
     * @uses KKOCariHareketi::setHareketSebebi()
     * @uses KKOCariHareketi::setEvrakObjId()
     * @uses KKOCariHareketi::setTarih()
     * @uses KKOCariHareketi::setTahsilatEvrakObjId()
     * @uses KKOCariHareketi::setEvrakTuru()
     * @uses KKOCariHareketi::setEvrakGonderimSekli()
     * @uses KKOCariHareketi::setSiraNo()
     * @uses KKOCariHareketi::setEvrakTarihi()
     * @uses KKOCariHareketi::setCari()
     * @uses KKOCariHareketi::setBorc()
     * @uses KKOCariHareketi::setAlacak()
     * @uses KKOCariHareketi::setEvrakNo()
     * @uses KKOCariHareketi::setSube()
     * @uses KKOCariHareketi::setAciklama()
     * @uses KKOCariHareketi::setTahsilatTipi()
     * @uses KKOCariHareketi::setBankaHesabi()
     * @uses KKOCariHareketi::setKOTaksit()
     * @uses KKOCariHareketi::setSeriNo()
     * @param string $hareketSebebi
     * @param int $evrakObjId
     * @param string $tarih
     * @param int $tahsilatEvrakObjId
     * @param string $evrakTuru
     * @param string $evrakGonderimSekli
     * @param float $siraNo
     * @param string $evrakTarihi
     * @param \StructType\KCariPointer $cari
     * @param \StructType\DovizliTutar $borc
     * @param \StructType\DovizliTutar $alacak
     * @param string $evrakNo
     * @param \StructType\KSubePointer $sube
     * @param string $aciklama
     * @param string $tahsilatTipi
     * @param \StructType\BankaHesabiPointer $bankaHesabi
     * @param \StructType\KKOTaksitPointer $kOTaksit
     * @param string $seriNo
     */
    public function __construct($hareketSebebi = null, $evrakObjId = null, $tarih = null, $tahsilatEvrakObjId = null, $evrakTuru = null, $evrakGonderimSekli = null, $siraNo = null, $evrakTarihi = null, \StructType\KCariPointer $cari = null, \StructType\DovizliTutar $borc = null, \StructType\DovizliTutar $alacak = null, $evrakNo = null, \StructType\KSubePointer $sube = null, $aciklama = null, $tahsilatTipi = null, \StructType\BankaHesabiPointer $bankaHesabi = null, \StructType\KKOTaksitPointer $kOTaksit = null, $seriNo = null)
    {
        $this
            ->setHareketSebebi($hareketSebebi)
            ->setEvrakObjId($evrakObjId)
            ->setTarih($tarih)
            ->setTahsilatEvrakObjId($tahsilatEvrakObjId)
            ->setEvrakTuru($evrakTuru)
            ->setEvrakGonderimSekli($evrakGonderimSekli)
            ->setSiraNo($siraNo)
            ->setEvrakTarihi($evrakTarihi)
            ->setCari($cari)
            ->setBorc($borc)
            ->setAlacak($alacak)
            ->setEvrakNo($evrakNo)
            ->setSube($sube)
            ->setAciklama($aciklama)
            ->setTahsilatTipi($tahsilatTipi)
            ->setBankaHesabi($bankaHesabi)
            ->setKOTaksit($kOTaksit)
            ->setSeriNo($seriNo);
    }
    /**
     * Get HareketSebebi value
     * @return string
     */
    public function getHareketSebebi()
    {
        return $this->HareketSebebi;
    }
    /**
     * Set HareketSebebi value
     * @uses \EnumType\KPOdemeCariHareketSebebi::valueIsValid()
     * @uses \EnumType\KPOdemeCariHareketSebebi::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $hareketSebebi
     * @return \StructType\KKOCariHareketi
     */
    public function setHareketSebebi($hareketSebebi = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\KPOdemeCariHareketSebebi::valueIsValid($hareketSebebi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\KPOdemeCariHareketSebebi', is_array($hareketSebebi) ? implode(', ', $hareketSebebi) : var_export($hareketSebebi, true), implode(', ', \EnumType\KPOdemeCariHareketSebebi::getValidValues())), __LINE__);
        }
        $this->HareketSebebi = $hareketSebebi;
        return $this;
    }
    /**
     * Get EvrakObjId value
     * @return int
     */
    public function getEvrakObjId()
    {
        return $this->EvrakObjId;
    }
    /**
     * Set EvrakObjId value
     * @param int $evrakObjId
     * @return \StructType\KKOCariHareketi
     */
    public function setEvrakObjId($evrakObjId = null)
    {
        // validation for constraint: int
        if (!is_null($evrakObjId) && !(is_int($evrakObjId) || ctype_digit($evrakObjId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($evrakObjId, true), gettype($evrakObjId)), __LINE__);
        }
        $this->EvrakObjId = $evrakObjId;
        return $this;
    }
    /**
     * Get Tarih value
     * @return string
     */
    public function getTarih()
    {
        return $this->Tarih;
    }
    /**
     * Set Tarih value
     * @param string $tarih
     * @return \StructType\KKOCariHareketi
     */
    public function setTarih($tarih = null)
    {
        // validation for constraint: string
        if (!is_null($tarih) && !is_string($tarih)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tarih, true), gettype($tarih)), __LINE__);
        }
        $this->Tarih = $tarih;
        return $this;
    }
    /**
     * Get TahsilatEvrakObjId value
     * @return int
     */
    public function getTahsilatEvrakObjId()
    {
        return $this->TahsilatEvrakObjId;
    }
    /**
     * Set TahsilatEvrakObjId value
     * @param int $tahsilatEvrakObjId
     * @return \StructType\KKOCariHareketi
     */
    public function setTahsilatEvrakObjId($tahsilatEvrakObjId = null)
    {
        // validation for constraint: int
        if (!is_null($tahsilatEvrakObjId) && !(is_int($tahsilatEvrakObjId) || ctype_digit($tahsilatEvrakObjId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($tahsilatEvrakObjId, true), gettype($tahsilatEvrakObjId)), __LINE__);
        }
        $this->TahsilatEvrakObjId = $tahsilatEvrakObjId;
        return $this;
    }
    /**
     * Get EvrakTuru value
     * @return string
     */
    public function getEvrakTuru()
    {
        return $this->EvrakTuru;
    }
    /**
     * Set EvrakTuru value
     * @uses \EnumType\KEvrakTuru::valueIsValid()
     * @uses \EnumType\KEvrakTuru::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $evrakTuru
     * @return \StructType\KKOCariHareketi
     */
    public function setEvrakTuru($evrakTuru = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\KEvrakTuru::valueIsValid($evrakTuru)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\KEvrakTuru', is_array($evrakTuru) ? implode(', ', $evrakTuru) : var_export($evrakTuru, true), implode(', ', \EnumType\KEvrakTuru::getValidValues())), __LINE__);
        }
        $this->EvrakTuru = $evrakTuru;
        return $this;
    }
    /**
     * Get EvrakGonderimSekli value
     * @return string
     */
    public function getEvrakGonderimSekli()
    {
        return $this->EvrakGonderimSekli;
    }
    /**
     * Set EvrakGonderimSekli value
     * @uses \EnumType\EvrakGonderimSekli::valueIsValid()
     * @uses \EnumType\EvrakGonderimSekli::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $evrakGonderimSekli
     * @return \StructType\KKOCariHareketi
     */
    public function setEvrakGonderimSekli($evrakGonderimSekli = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EvrakGonderimSekli::valueIsValid($evrakGonderimSekli)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\EvrakGonderimSekli', is_array($evrakGonderimSekli) ? implode(', ', $evrakGonderimSekli) : var_export($evrakGonderimSekli, true), implode(', ', \EnumType\EvrakGonderimSekli::getValidValues())), __LINE__);
        }
        $this->EvrakGonderimSekli = $evrakGonderimSekli;
        return $this;
    }
    /**
     * Get SiraNo value
     * @return float
     */
    public function getSiraNo()
    {
        return $this->SiraNo;
    }
    /**
     * Set SiraNo value
     * @param float $siraNo
     * @return \StructType\KKOCariHareketi
     */
    public function setSiraNo($siraNo = null)
    {
        // validation for constraint: float
        if (!is_null($siraNo) && !(is_float($siraNo) || is_numeric($siraNo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($siraNo, true), gettype($siraNo)), __LINE__);
        }
        $this->SiraNo = $siraNo;
        return $this;
    }
    /**
     * Get EvrakTarihi value
     * @return string
     */
    public function getEvrakTarihi()
    {
        return $this->EvrakTarihi;
    }
    /**
     * Set EvrakTarihi value
     * @param string $evrakTarihi
     * @return \StructType\KKOCariHareketi
     */
    public function setEvrakTarihi($evrakTarihi = null)
    {
        // validation for constraint: string
        if (!is_null($evrakTarihi) && !is_string($evrakTarihi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($evrakTarihi, true), gettype($evrakTarihi)), __LINE__);
        }
        $this->EvrakTarihi = $evrakTarihi;
        return $this;
    }
    /**
     * Get Cari value
     * @return \StructType\KCariPointer|null
     */
    public function getCari()
    {
        return $this->Cari;
    }
    /**
     * Set Cari value
     * @param \StructType\KCariPointer $cari
     * @return \StructType\KKOCariHareketi
     */
    public function setCari(\StructType\KCariPointer $cari = null)
    {
        $this->Cari = $cari;
        return $this;
    }
    /**
     * Get Borc value
     * @return \StructType\DovizliTutar|null
     */
    public function getBorc()
    {
        return $this->Borc;
    }
    /**
     * Set Borc value
     * @param \StructType\DovizliTutar $borc
     * @return \StructType\KKOCariHareketi
     */
    public function setBorc(\StructType\DovizliTutar $borc = null)
    {
        $this->Borc = $borc;
        return $this;
    }
    /**
     * Get Alacak value
     * @return \StructType\DovizliTutar|null
     */
    public function getAlacak()
    {
        return $this->Alacak;
    }
    /**
     * Set Alacak value
     * @param \StructType\DovizliTutar $alacak
     * @return \StructType\KKOCariHareketi
     */
    public function setAlacak(\StructType\DovizliTutar $alacak = null)
    {
        $this->Alacak = $alacak;
        return $this;
    }
    /**
     * Get EvrakNo value
     * @return string|null
     */
    public function getEvrakNo()
    {
        return $this->EvrakNo;
    }
    /**
     * Set EvrakNo value
     * @param string $evrakNo
     * @return \StructType\KKOCariHareketi
     */
    public function setEvrakNo($evrakNo = null)
    {
        // validation for constraint: string
        if (!is_null($evrakNo) && !is_string($evrakNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($evrakNo, true), gettype($evrakNo)), __LINE__);
        }
        $this->EvrakNo = $evrakNo;
        return $this;
    }
    /**
     * Get Sube value
     * @return \StructType\KSubePointer|null
     */
    public function getSube()
    {
        return $this->Sube;
    }
    /**
     * Set Sube value
     * @param \StructType\KSubePointer $sube
     * @return \StructType\KKOCariHareketi
     */
    public function setSube(\StructType\KSubePointer $sube = null)
    {
        $this->Sube = $sube;
        return $this;
    }
    /**
     * Get Aciklama value
     * @return string|null
     */
    public function getAciklama()
    {
        return $this->Aciklama;
    }
    /**
     * Set Aciklama value
     * @param string $aciklama
     * @return \StructType\KKOCariHareketi
     */
    public function setAciklama($aciklama = null)
    {
        // validation for constraint: string
        if (!is_null($aciklama) && !is_string($aciklama)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aciklama, true), gettype($aciklama)), __LINE__);
        }
        $this->Aciklama = $aciklama;
        return $this;
    }
    /**
     * Get TahsilatTipi value
     * @return string|null
     */
    public function getTahsilatTipi()
    {
        return $this->TahsilatTipi;
    }
    /**
     * Set TahsilatTipi value
     * @param string $tahsilatTipi
     * @return \StructType\KKOCariHareketi
     */
    public function setTahsilatTipi($tahsilatTipi = null)
    {
        // validation for constraint: string
        if (!is_null($tahsilatTipi) && !is_string($tahsilatTipi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tahsilatTipi, true), gettype($tahsilatTipi)), __LINE__);
        }
        $this->TahsilatTipi = $tahsilatTipi;
        return $this;
    }
    /**
     * Get BankaHesabi value
     * @return \StructType\BankaHesabiPointer|null
     */
    public function getBankaHesabi()
    {
        return $this->BankaHesabi;
    }
    /**
     * Set BankaHesabi value
     * @param \StructType\BankaHesabiPointer $bankaHesabi
     * @return \StructType\KKOCariHareketi
     */
    public function setBankaHesabi(\StructType\BankaHesabiPointer $bankaHesabi = null)
    {
        $this->BankaHesabi = $bankaHesabi;
        return $this;
    }
    /**
     * Get KOTaksit value
     * @return \StructType\KKOTaksitPointer|null
     */
    public function getKOTaksit()
    {
        return $this->KOTaksit;
    }
    /**
     * Set KOTaksit value
     * @param \StructType\KKOTaksitPointer $kOTaksit
     * @return \StructType\KKOCariHareketi
     */
    public function setKOTaksit(\StructType\KKOTaksitPointer $kOTaksit = null)
    {
        $this->KOTaksit = $kOTaksit;
        return $this;
    }
    /**
     * Get SeriNo value
     * @return string|null
     */
    public function getSeriNo()
    {
        return $this->SeriNo;
    }
    /**
     * Set SeriNo value
     * @param string $seriNo
     * @return \StructType\KKOCariHareketi
     */
    public function setSeriNo($seriNo = null)
    {
        // validation for constraint: string
        if (!is_null($seriNo) && !is_string($seriNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seriNo, true), gettype($seriNo)), __LINE__);
        }
        $this->SeriNo = $seriNo;
        return $this;
    }
}
