<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for KEvrakIptal StructType
 * @subpackage Structs
 */
class KEvrakIptal extends Entity
{
    /**
     * The Tarih
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Tarih;
    /**
     * The IptalSebebi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $IptalSebebi;
    /**
     * The IptalEdilenEvrakSiraNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $IptalEdilenEvrakSiraNo;
    /**
     * The KarsiEvrakObjId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $KarsiEvrakObjId;
    /**
     * The IptalEdilenEvrakTuru
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $IptalEdilenEvrakTuru;
    /**
     * The UzerineYazilanEvrakTuru
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $UzerineYazilanEvrakTuru;
    /**
     * The IptalDurumu
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $IptalDurumu;
    /**
     * The TahsilEt
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $TahsilEt;
    /**
     * The IsMusteriEntegrasyon
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsMusteriEntegrasyon;
    /**
     * The OtomatikEvrakIptal
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $OtomatikEvrakIptal;
    /**
     * The Aciklama
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Aciklama;
    /**
     * The IptaliOnaylayan
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IptaliOnaylayan;
    /**
     * The IptalEdilenEvrakSeri
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\SubeSeriZimmetPointer
     */
    public $IptalEdilenEvrakSeri;
    /**
     * Constructor method for KEvrakIptal
     * @uses KEvrakIptal::setTarih()
     * @uses KEvrakIptal::setIptalSebebi()
     * @uses KEvrakIptal::setIptalEdilenEvrakSiraNo()
     * @uses KEvrakIptal::setKarsiEvrakObjId()
     * @uses KEvrakIptal::setIptalEdilenEvrakTuru()
     * @uses KEvrakIptal::setUzerineYazilanEvrakTuru()
     * @uses KEvrakIptal::setIptalDurumu()
     * @uses KEvrakIptal::setTahsilEt()
     * @uses KEvrakIptal::setIsMusteriEntegrasyon()
     * @uses KEvrakIptal::setOtomatikEvrakIptal()
     * @uses KEvrakIptal::setAciklama()
     * @uses KEvrakIptal::setIptaliOnaylayan()
     * @uses KEvrakIptal::setIptalEdilenEvrakSeri()
     * @param string $tarih
     * @param string $iptalSebebi
     * @param float $iptalEdilenEvrakSiraNo
     * @param int $karsiEvrakObjId
     * @param string $iptalEdilenEvrakTuru
     * @param string $uzerineYazilanEvrakTuru
     * @param string $iptalDurumu
     * @param bool $tahsilEt
     * @param bool $isMusteriEntegrasyon
     * @param bool $otomatikEvrakIptal
     * @param string $aciklama
     * @param string $iptaliOnaylayan
     * @param \StructType\SubeSeriZimmetPointer $iptalEdilenEvrakSeri
     */
    public function __construct($tarih = null, $iptalSebebi = null, $iptalEdilenEvrakSiraNo = null, $karsiEvrakObjId = null, $iptalEdilenEvrakTuru = null, $uzerineYazilanEvrakTuru = null, $iptalDurumu = null, $tahsilEt = null, $isMusteriEntegrasyon = null, $otomatikEvrakIptal = null, $aciklama = null, $iptaliOnaylayan = null, \StructType\SubeSeriZimmetPointer $iptalEdilenEvrakSeri = null)
    {
        $this
            ->setTarih($tarih)
            ->setIptalSebebi($iptalSebebi)
            ->setIptalEdilenEvrakSiraNo($iptalEdilenEvrakSiraNo)
            ->setKarsiEvrakObjId($karsiEvrakObjId)
            ->setIptalEdilenEvrakTuru($iptalEdilenEvrakTuru)
            ->setUzerineYazilanEvrakTuru($uzerineYazilanEvrakTuru)
            ->setIptalDurumu($iptalDurumu)
            ->setTahsilEt($tahsilEt)
            ->setIsMusteriEntegrasyon($isMusteriEntegrasyon)
            ->setOtomatikEvrakIptal($otomatikEvrakIptal)
            ->setAciklama($aciklama)
            ->setIptaliOnaylayan($iptaliOnaylayan)
            ->setIptalEdilenEvrakSeri($iptalEdilenEvrakSeri);
    }
    /**
     * Get Tarih value
     * @return string
     */
    public function getTarih()
    {
        return $this->Tarih;
    }
    /**
     * Set Tarih value
     * @param string $tarih
     * @return \StructType\KEvrakIptal
     */
    public function setTarih($tarih = null)
    {
        // validation for constraint: string
        if (!is_null($tarih) && !is_string($tarih)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tarih, true), gettype($tarih)), __LINE__);
        }
        $this->Tarih = $tarih;
        return $this;
    }
    /**
     * Get IptalSebebi value
     * @return string
     */
    public function getIptalSebebi()
    {
        return $this->IptalSebebi;
    }
    /**
     * Set IptalSebebi value
     * @uses \EnumType\KEvrakIptalSebebi::valueIsValid()
     * @uses \EnumType\KEvrakIptalSebebi::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $iptalSebebi
     * @return \StructType\KEvrakIptal
     */
    public function setIptalSebebi($iptalSebebi = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\KEvrakIptalSebebi::valueIsValid($iptalSebebi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\KEvrakIptalSebebi', is_array($iptalSebebi) ? implode(', ', $iptalSebebi) : var_export($iptalSebebi, true), implode(', ', \EnumType\KEvrakIptalSebebi::getValidValues())), __LINE__);
        }
        $this->IptalSebebi = $iptalSebebi;
        return $this;
    }
    /**
     * Get IptalEdilenEvrakSiraNo value
     * @return float
     */
    public function getIptalEdilenEvrakSiraNo()
    {
        return $this->IptalEdilenEvrakSiraNo;
    }
    /**
     * Set IptalEdilenEvrakSiraNo value
     * @param float $iptalEdilenEvrakSiraNo
     * @return \StructType\KEvrakIptal
     */
    public function setIptalEdilenEvrakSiraNo($iptalEdilenEvrakSiraNo = null)
    {
        // validation for constraint: float
        if (!is_null($iptalEdilenEvrakSiraNo) && !(is_float($iptalEdilenEvrakSiraNo) || is_numeric($iptalEdilenEvrakSiraNo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($iptalEdilenEvrakSiraNo, true), gettype($iptalEdilenEvrakSiraNo)), __LINE__);
        }
        $this->IptalEdilenEvrakSiraNo = $iptalEdilenEvrakSiraNo;
        return $this;
    }
    /**
     * Get KarsiEvrakObjId value
     * @return int
     */
    public function getKarsiEvrakObjId()
    {
        return $this->KarsiEvrakObjId;
    }
    /**
     * Set KarsiEvrakObjId value
     * @param int $karsiEvrakObjId
     * @return \StructType\KEvrakIptal
     */
    public function setKarsiEvrakObjId($karsiEvrakObjId = null)
    {
        // validation for constraint: int
        if (!is_null($karsiEvrakObjId) && !(is_int($karsiEvrakObjId) || ctype_digit($karsiEvrakObjId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($karsiEvrakObjId, true), gettype($karsiEvrakObjId)), __LINE__);
        }
        $this->KarsiEvrakObjId = $karsiEvrakObjId;
        return $this;
    }
    /**
     * Get IptalEdilenEvrakTuru value
     * @return string
     */
    public function getIptalEdilenEvrakTuru()
    {
        return $this->IptalEdilenEvrakTuru;
    }
    /**
     * Set IptalEdilenEvrakTuru value
     * @uses \EnumType\FATTES::valueIsValid()
     * @uses \EnumType\FATTES::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $iptalEdilenEvrakTuru
     * @return \StructType\KEvrakIptal
     */
    public function setIptalEdilenEvrakTuru($iptalEdilenEvrakTuru = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\FATTES::valueIsValid($iptalEdilenEvrakTuru)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\FATTES', is_array($iptalEdilenEvrakTuru) ? implode(', ', $iptalEdilenEvrakTuru) : var_export($iptalEdilenEvrakTuru, true), implode(', ', \EnumType\FATTES::getValidValues())), __LINE__);
        }
        $this->IptalEdilenEvrakTuru = $iptalEdilenEvrakTuru;
        return $this;
    }
    /**
     * Get UzerineYazilanEvrakTuru value
     * @return string
     */
    public function getUzerineYazilanEvrakTuru()
    {
        return $this->UzerineYazilanEvrakTuru;
    }
    /**
     * Set UzerineYazilanEvrakTuru value
     * @uses \EnumType\FATTES::valueIsValid()
     * @uses \EnumType\FATTES::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $uzerineYazilanEvrakTuru
     * @return \StructType\KEvrakIptal
     */
    public function setUzerineYazilanEvrakTuru($uzerineYazilanEvrakTuru = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\FATTES::valueIsValid($uzerineYazilanEvrakTuru)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\FATTES', is_array($uzerineYazilanEvrakTuru) ? implode(', ', $uzerineYazilanEvrakTuru) : var_export($uzerineYazilanEvrakTuru, true), implode(', ', \EnumType\FATTES::getValidValues())), __LINE__);
        }
        $this->UzerineYazilanEvrakTuru = $uzerineYazilanEvrakTuru;
        return $this;
    }
    /**
     * Get IptalDurumu value
     * @return string
     */
    public function getIptalDurumu()
    {
        return $this->IptalDurumu;
    }
    /**
     * Set IptalDurumu value
     * @uses \EnumType\KIptalDurumu::valueIsValid()
     * @uses \EnumType\KIptalDurumu::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $iptalDurumu
     * @return \StructType\KEvrakIptal
     */
    public function setIptalDurumu($iptalDurumu = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\KIptalDurumu::valueIsValid($iptalDurumu)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\KIptalDurumu', is_array($iptalDurumu) ? implode(', ', $iptalDurumu) : var_export($iptalDurumu, true), implode(', ', \EnumType\KIptalDurumu::getValidValues())), __LINE__);
        }
        $this->IptalDurumu = $iptalDurumu;
        return $this;
    }
    /**
     * Get TahsilEt value
     * @return bool
     */
    public function getTahsilEt()
    {
        return $this->TahsilEt;
    }
    /**
     * Set TahsilEt value
     * @param bool $tahsilEt
     * @return \StructType\KEvrakIptal
     */
    public function setTahsilEt($tahsilEt = null)
    {
        // validation for constraint: boolean
        if (!is_null($tahsilEt) && !is_bool($tahsilEt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($tahsilEt, true), gettype($tahsilEt)), __LINE__);
        }
        $this->TahsilEt = $tahsilEt;
        return $this;
    }
    /**
     * Get IsMusteriEntegrasyon value
     * @return bool
     */
    public function getIsMusteriEntegrasyon()
    {
        return $this->IsMusteriEntegrasyon;
    }
    /**
     * Set IsMusteriEntegrasyon value
     * @param bool $isMusteriEntegrasyon
     * @return \StructType\KEvrakIptal
     */
    public function setIsMusteriEntegrasyon($isMusteriEntegrasyon = null)
    {
        // validation for constraint: boolean
        if (!is_null($isMusteriEntegrasyon) && !is_bool($isMusteriEntegrasyon)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isMusteriEntegrasyon, true), gettype($isMusteriEntegrasyon)), __LINE__);
        }
        $this->IsMusteriEntegrasyon = $isMusteriEntegrasyon;
        return $this;
    }
    /**
     * Get OtomatikEvrakIptal value
     * @return bool
     */
    public function getOtomatikEvrakIptal()
    {
        return $this->OtomatikEvrakIptal;
    }
    /**
     * Set OtomatikEvrakIptal value
     * @param bool $otomatikEvrakIptal
     * @return \StructType\KEvrakIptal
     */
    public function setOtomatikEvrakIptal($otomatikEvrakIptal = null)
    {
        // validation for constraint: boolean
        if (!is_null($otomatikEvrakIptal) && !is_bool($otomatikEvrakIptal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($otomatikEvrakIptal, true), gettype($otomatikEvrakIptal)), __LINE__);
        }
        $this->OtomatikEvrakIptal = $otomatikEvrakIptal;
        return $this;
    }
    /**
     * Get Aciklama value
     * @return string|null
     */
    public function getAciklama()
    {
        return $this->Aciklama;
    }
    /**
     * Set Aciklama value
     * @param string $aciklama
     * @return \StructType\KEvrakIptal
     */
    public function setAciklama($aciklama = null)
    {
        // validation for constraint: string
        if (!is_null($aciklama) && !is_string($aciklama)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aciklama, true), gettype($aciklama)), __LINE__);
        }
        $this->Aciklama = $aciklama;
        return $this;
    }
    /**
     * Get IptaliOnaylayan value
     * @return string|null
     */
    public function getIptaliOnaylayan()
    {
        return $this->IptaliOnaylayan;
    }
    /**
     * Set IptaliOnaylayan value
     * @param string $iptaliOnaylayan
     * @return \StructType\KEvrakIptal
     */
    public function setIptaliOnaylayan($iptaliOnaylayan = null)
    {
        // validation for constraint: string
        if (!is_null($iptaliOnaylayan) && !is_string($iptaliOnaylayan)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iptaliOnaylayan, true), gettype($iptaliOnaylayan)), __LINE__);
        }
        $this->IptaliOnaylayan = $iptaliOnaylayan;
        return $this;
    }
    /**
     * Get IptalEdilenEvrakSeri value
     * @return \StructType\SubeSeriZimmetPointer|null
     */
    public function getIptalEdilenEvrakSeri()
    {
        return $this->IptalEdilenEvrakSeri;
    }
    /**
     * Set IptalEdilenEvrakSeri value
     * @param \StructType\SubeSeriZimmetPointer $iptalEdilenEvrakSeri
     * @return \StructType\KEvrakIptal
     */
    public function setIptalEdilenEvrakSeri(\StructType\SubeSeriZimmetPointer $iptalEdilenEvrakSeri = null)
    {
        $this->IptalEdilenEvrakSeri = $iptalEdilenEvrakSeri;
        return $this;
    }
}
