<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for KEleman StructType
 * @subpackage Structs
 */
class KEleman extends Entity
{
    /**
     * The Gorev
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Gorev;
    /**
     * The BaslangicTarih
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $BaslangicTarih;
    /**
     * The BitisTarih
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $BitisTarih;
    /**
     * The Durum
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Durum;
    /**
     * The SP_KullaniciObjId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SP_KullaniciObjId;
    /**
     * The Ad
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Ad;
    /**
     * The Subesi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\KSubePointer
     */
    public $Subesi;
    /**
     * The HatNokta
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\KHatNoktaPointer
     */
    public $HatNokta;
    /**
     * The Adres
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Adres;
    /**
     * The Telefon
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Telefon;
    /**
     * The SicilNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SicilNo;
    /**
     * The KuryeSifre
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $KuryeSifre;
    /**
     * Constructor method for KEleman
     * @uses KEleman::setGorev()
     * @uses KEleman::setBaslangicTarih()
     * @uses KEleman::setBitisTarih()
     * @uses KEleman::setDurum()
     * @uses KEleman::setSP_KullaniciObjId()
     * @uses KEleman::setAd()
     * @uses KEleman::setSubesi()
     * @uses KEleman::setHatNokta()
     * @uses KEleman::setAdres()
     * @uses KEleman::setTelefon()
     * @uses KEleman::setSicilNo()
     * @uses KEleman::setKuryeSifre()
     * @param int $gorev
     * @param string $baslangicTarih
     * @param string $bitisTarih
     * @param string $durum
     * @param int $sP_KullaniciObjId
     * @param string $ad
     * @param \StructType\KSubePointer $subesi
     * @param \StructType\KHatNoktaPointer $hatNokta
     * @param string $adres
     * @param string $telefon
     * @param string $sicilNo
     * @param string $kuryeSifre
     */
    public function __construct($gorev = null, $baslangicTarih = null, $bitisTarih = null, $durum = null, $sP_KullaniciObjId = null, $ad = null, \StructType\KSubePointer $subesi = null, \StructType\KHatNoktaPointer $hatNokta = null, $adres = null, $telefon = null, $sicilNo = null, $kuryeSifre = null)
    {
        $this
            ->setGorev($gorev)
            ->setBaslangicTarih($baslangicTarih)
            ->setBitisTarih($bitisTarih)
            ->setDurum($durum)
            ->setSP_KullaniciObjId($sP_KullaniciObjId)
            ->setAd($ad)
            ->setSubesi($subesi)
            ->setHatNokta($hatNokta)
            ->setAdres($adres)
            ->setTelefon($telefon)
            ->setSicilNo($sicilNo)
            ->setKuryeSifre($kuryeSifre);
    }
    /**
     * Get Gorev value
     * @return int
     */
    public function getGorev()
    {
        return $this->Gorev;
    }
    /**
     * Set Gorev value
     * @param int $gorev
     * @return \StructType\KEleman
     */
    public function setGorev($gorev = null)
    {
        // validation for constraint: int
        if (!is_null($gorev) && !(is_int($gorev) || ctype_digit($gorev))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($gorev, true), gettype($gorev)), __LINE__);
        }
        $this->Gorev = $gorev;
        return $this;
    }
    /**
     * Get BaslangicTarih value
     * @return string
     */
    public function getBaslangicTarih()
    {
        return $this->BaslangicTarih;
    }
    /**
     * Set BaslangicTarih value
     * @param string $baslangicTarih
     * @return \StructType\KEleman
     */
    public function setBaslangicTarih($baslangicTarih = null)
    {
        // validation for constraint: string
        if (!is_null($baslangicTarih) && !is_string($baslangicTarih)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($baslangicTarih, true), gettype($baslangicTarih)), __LINE__);
        }
        $this->BaslangicTarih = $baslangicTarih;
        return $this;
    }
    /**
     * Get BitisTarih value
     * @return string
     */
    public function getBitisTarih()
    {
        return $this->BitisTarih;
    }
    /**
     * Set BitisTarih value
     * @param string $bitisTarih
     * @return \StructType\KEleman
     */
    public function setBitisTarih($bitisTarih = null)
    {
        // validation for constraint: string
        if (!is_null($bitisTarih) && !is_string($bitisTarih)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bitisTarih, true), gettype($bitisTarih)), __LINE__);
        }
        $this->BitisTarih = $bitisTarih;
        return $this;
    }
    /**
     * Get Durum value
     * @return string
     */
    public function getDurum()
    {
        return $this->Durum;
    }
    /**
     * Set Durum value
     * @uses \EnumType\KElemanDurum::valueIsValid()
     * @uses \EnumType\KElemanDurum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $durum
     * @return \StructType\KEleman
     */
    public function setDurum($durum = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\KElemanDurum::valueIsValid($durum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\KElemanDurum', is_array($durum) ? implode(', ', $durum) : var_export($durum, true), implode(', ', \EnumType\KElemanDurum::getValidValues())), __LINE__);
        }
        $this->Durum = $durum;
        return $this;
    }
    /**
     * Get SP_KullaniciObjId value
     * @return int
     */
    public function getSP_KullaniciObjId()
    {
        return $this->SP_KullaniciObjId;
    }
    /**
     * Set SP_KullaniciObjId value
     * @param int $sP_KullaniciObjId
     * @return \StructType\KEleman
     */
    public function setSP_KullaniciObjId($sP_KullaniciObjId = null)
    {
        // validation for constraint: int
        if (!is_null($sP_KullaniciObjId) && !(is_int($sP_KullaniciObjId) || ctype_digit($sP_KullaniciObjId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sP_KullaniciObjId, true), gettype($sP_KullaniciObjId)), __LINE__);
        }
        $this->SP_KullaniciObjId = $sP_KullaniciObjId;
        return $this;
    }
    /**
     * Get Ad value
     * @return string|null
     */
    public function getAd()
    {
        return $this->Ad;
    }
    /**
     * Set Ad value
     * @param string $ad
     * @return \StructType\KEleman
     */
    public function setAd($ad = null)
    {
        // validation for constraint: string
        if (!is_null($ad) && !is_string($ad)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ad, true), gettype($ad)), __LINE__);
        }
        $this->Ad = $ad;
        return $this;
    }
    /**
     * Get Subesi value
     * @return \StructType\KSubePointer|null
     */
    public function getSubesi()
    {
        return $this->Subesi;
    }
    /**
     * Set Subesi value
     * @param \StructType\KSubePointer $subesi
     * @return \StructType\KEleman
     */
    public function setSubesi(\StructType\KSubePointer $subesi = null)
    {
        $this->Subesi = $subesi;
        return $this;
    }
    /**
     * Get HatNokta value
     * @return \StructType\KHatNoktaPointer|null
     */
    public function getHatNokta()
    {
        return $this->HatNokta;
    }
    /**
     * Set HatNokta value
     * @param \StructType\KHatNoktaPointer $hatNokta
     * @return \StructType\KEleman
     */
    public function setHatNokta(\StructType\KHatNoktaPointer $hatNokta = null)
    {
        $this->HatNokta = $hatNokta;
        return $this;
    }
    /**
     * Get Adres value
     * @return string|null
     */
    public function getAdres()
    {
        return $this->Adres;
    }
    /**
     * Set Adres value
     * @param string $adres
     * @return \StructType\KEleman
     */
    public function setAdres($adres = null)
    {
        // validation for constraint: string
        if (!is_null($adres) && !is_string($adres)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($adres, true), gettype($adres)), __LINE__);
        }
        $this->Adres = $adres;
        return $this;
    }
    /**
     * Get Telefon value
     * @return string|null
     */
    public function getTelefon()
    {
        return $this->Telefon;
    }
    /**
     * Set Telefon value
     * @param string $telefon
     * @return \StructType\KEleman
     */
    public function setTelefon($telefon = null)
    {
        // validation for constraint: string
        if (!is_null($telefon) && !is_string($telefon)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($telefon, true), gettype($telefon)), __LINE__);
        }
        $this->Telefon = $telefon;
        return $this;
    }
    /**
     * Get SicilNo value
     * @return string|null
     */
    public function getSicilNo()
    {
        return $this->SicilNo;
    }
    /**
     * Set SicilNo value
     * @param string $sicilNo
     * @return \StructType\KEleman
     */
    public function setSicilNo($sicilNo = null)
    {
        // validation for constraint: string
        if (!is_null($sicilNo) && !is_string($sicilNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sicilNo, true), gettype($sicilNo)), __LINE__);
        }
        $this->SicilNo = $sicilNo;
        return $this;
    }
    /**
     * Get KuryeSifre value
     * @return string|null
     */
    public function getKuryeSifre()
    {
        return $this->KuryeSifre;
    }
    /**
     * Set KuryeSifre value
     * @param string $kuryeSifre
     * @return \StructType\KEleman
     */
    public function setKuryeSifre($kuryeSifre = null)
    {
        // validation for constraint: string
        if (!is_null($kuryeSifre) && !is_string($kuryeSifre)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kuryeSifre, true), gettype($kuryeSifre)), __LINE__);
        }
        $this->KuryeSifre = $kuryeSifre;
        return $this;
    }
}
