<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for KCariMail StructType
 * @subpackage Structs
 */
class KCariMail extends Entity
{
    /**
     * The Turu
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Turu;
    /**
     * The Mail
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Mail;
    /**
     * The Carisi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\KCariPointer
     */
    public $Carisi;
    /**
     * The Sozlesme
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\KSozlesmePointer
     */
    public $Sozlesme;
    /**
     * Constructor method for KCariMail
     * @uses KCariMail::setTuru()
     * @uses KCariMail::setMail()
     * @uses KCariMail::setCarisi()
     * @uses KCariMail::setSozlesme()
     * @param string $turu
     * @param string $mail
     * @param \StructType\KCariPointer $carisi
     * @param \StructType\KSozlesmePointer $sozlesme
     */
    public function __construct($turu = null, $mail = null, \StructType\KCariPointer $carisi = null, \StructType\KSozlesmePointer $sozlesme = null)
    {
        $this
            ->setTuru($turu)
            ->setMail($mail)
            ->setCarisi($carisi)
            ->setSozlesme($sozlesme);
    }
    /**
     * Get Turu value
     * @return string
     */
    public function getTuru()
    {
        return $this->Turu;
    }
    /**
     * Set Turu value
     * @uses \EnumType\KCariMailTuru::valueIsValid()
     * @uses \EnumType\KCariMailTuru::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $turu
     * @return \StructType\KCariMail
     */
    public function setTuru($turu = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\KCariMailTuru::valueIsValid($turu)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\KCariMailTuru', is_array($turu) ? implode(', ', $turu) : var_export($turu, true), implode(', ', \EnumType\KCariMailTuru::getValidValues())), __LINE__);
        }
        $this->Turu = $turu;
        return $this;
    }
    /**
     * Get Mail value
     * @return string|null
     */
    public function getMail()
    {
        return $this->Mail;
    }
    /**
     * Set Mail value
     * @param string $mail
     * @return \StructType\KCariMail
     */
    public function setMail($mail = null)
    {
        // validation for constraint: string
        if (!is_null($mail) && !is_string($mail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mail, true), gettype($mail)), __LINE__);
        }
        $this->Mail = $mail;
        return $this;
    }
    /**
     * Get Carisi value
     * @return \StructType\KCariPointer|null
     */
    public function getCarisi()
    {
        return $this->Carisi;
    }
    /**
     * Set Carisi value
     * @param \StructType\KCariPointer $carisi
     * @return \StructType\KCariMail
     */
    public function setCarisi(\StructType\KCariPointer $carisi = null)
    {
        $this->Carisi = $carisi;
        return $this;
    }
    /**
     * Get Sozlesme value
     * @return \StructType\KSozlesmePointer|null
     */
    public function getSozlesme()
    {
        return $this->Sozlesme;
    }
    /**
     * Set Sozlesme value
     * @param \StructType\KSozlesmePointer $sozlesme
     * @return \StructType\KCariMail
     */
    public function setSozlesme(\StructType\KSozlesmePointer $sozlesme = null)
    {
        $this->Sozlesme = $sozlesme;
        return $this;
    }
}
