<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for KAracHareket StructType
 * @subpackage Structs
 */
class KAracHareket extends Entity
{
    /**
     * The HareketTar
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $HareketTar;
    /**
     * The HareketTip
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $HareketTip;
    /**
     * The Arac
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\KAracKaraPointer
     */
    public $Arac;
    /**
     * The AracSeferAyak
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\KAracSeferAyakPointer
     */
    public $AracSeferAyak;
    /**
     * The HareketSube
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\KSubePointer
     */
    public $HareketSube;
    /**
     * The HareketYer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\KSevkAdresPointer
     */
    public $HareketYer;
    /**
     * Constructor method for KAracHareket
     * @uses KAracHareket::setHareketTar()
     * @uses KAracHareket::setHareketTip()
     * @uses KAracHareket::setArac()
     * @uses KAracHareket::setAracSeferAyak()
     * @uses KAracHareket::setHareketSube()
     * @uses KAracHareket::setHareketYer()
     * @param string $hareketTar
     * @param string $hareketTip
     * @param \StructType\KAracKaraPointer $arac
     * @param \StructType\KAracSeferAyakPointer $aracSeferAyak
     * @param \StructType\KSubePointer $hareketSube
     * @param \StructType\KSevkAdresPointer $hareketYer
     */
    public function __construct($hareketTar = null, $hareketTip = null, \StructType\KAracKaraPointer $arac = null, \StructType\KAracSeferAyakPointer $aracSeferAyak = null, \StructType\KSubePointer $hareketSube = null, \StructType\KSevkAdresPointer $hareketYer = null)
    {
        $this
            ->setHareketTar($hareketTar)
            ->setHareketTip($hareketTip)
            ->setArac($arac)
            ->setAracSeferAyak($aracSeferAyak)
            ->setHareketSube($hareketSube)
            ->setHareketYer($hareketYer);
    }
    /**
     * Get HareketTar value
     * @return string
     */
    public function getHareketTar()
    {
        return $this->HareketTar;
    }
    /**
     * Set HareketTar value
     * @param string $hareketTar
     * @return \StructType\KAracHareket
     */
    public function setHareketTar($hareketTar = null)
    {
        // validation for constraint: string
        if (!is_null($hareketTar) && !is_string($hareketTar)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hareketTar, true), gettype($hareketTar)), __LINE__);
        }
        $this->HareketTar = $hareketTar;
        return $this;
    }
    /**
     * Get HareketTip value
     * @return string
     */
    public function getHareketTip()
    {
        return $this->HareketTip;
    }
    /**
     * Set HareketTip value
     * @uses \EnumType\AracHareketTip::valueIsValid()
     * @uses \EnumType\AracHareketTip::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $hareketTip
     * @return \StructType\KAracHareket
     */
    public function setHareketTip($hareketTip = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AracHareketTip::valueIsValid($hareketTip)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\AracHareketTip', is_array($hareketTip) ? implode(', ', $hareketTip) : var_export($hareketTip, true), implode(', ', \EnumType\AracHareketTip::getValidValues())), __LINE__);
        }
        $this->HareketTip = $hareketTip;
        return $this;
    }
    /**
     * Get Arac value
     * @return \StructType\KAracKaraPointer|null
     */
    public function getArac()
    {
        return $this->Arac;
    }
    /**
     * Set Arac value
     * @param \StructType\KAracKaraPointer $arac
     * @return \StructType\KAracHareket
     */
    public function setArac(\StructType\KAracKaraPointer $arac = null)
    {
        $this->Arac = $arac;
        return $this;
    }
    /**
     * Get AracSeferAyak value
     * @return \StructType\KAracSeferAyakPointer|null
     */
    public function getAracSeferAyak()
    {
        return $this->AracSeferAyak;
    }
    /**
     * Set AracSeferAyak value
     * @param \StructType\KAracSeferAyakPointer $aracSeferAyak
     * @return \StructType\KAracHareket
     */
    public function setAracSeferAyak(\StructType\KAracSeferAyakPointer $aracSeferAyak = null)
    {
        $this->AracSeferAyak = $aracSeferAyak;
        return $this;
    }
    /**
     * Get HareketSube value
     * @return \StructType\KSubePointer|null
     */
    public function getHareketSube()
    {
        return $this->HareketSube;
    }
    /**
     * Set HareketSube value
     * @param \StructType\KSubePointer $hareketSube
     * @return \StructType\KAracHareket
     */
    public function setHareketSube(\StructType\KSubePointer $hareketSube = null)
    {
        $this->HareketSube = $hareketSube;
        return $this;
    }
    /**
     * Get HareketYer value
     * @return \StructType\KSevkAdresPointer|null
     */
    public function getHareketYer()
    {
        return $this->HareketYer;
    }
    /**
     * Set HareketYer value
     * @param \StructType\KSevkAdresPointer $hareketYer
     * @return \StructType\KAracHareket
     */
    public function setHareketYer(\StructType\KSevkAdresPointer $hareketYer = null)
    {
        $this->HareketYer = $hareketYer;
        return $this;
    }
}
