<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CariFisiSatiri StructType
 * @subpackage Structs
 */
class CariFisiSatiri extends SerendipEntity
{
    /**
     * The KdvOrani
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $KdvOrani;
    /**
     * The KDVDahilMi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $KDVDahilMi;
    /**
     * The IlgiliOdemeTalepFormuSatirObjId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $IlgiliOdemeTalepFormuSatirObjId;
    /**
     * The Cari
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CariHesabiPointer
     */
    public $Cari;
    /**
     * The KarsiCari
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CariHesabiPointer
     */
    public $KarsiCari;
    /**
     * The KarsiKasa
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\KasaHesabiPointer
     */
    public $KarsiKasa;
    /**
     * The Borc
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\DovizliTutar
     */
    public $Borc;
    /**
     * The Alacak
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\DovizliTutar
     */
    public $Alacak;
    /**
     * The AlacakSatirPlani
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OdemePlaniPointer
     */
    public $AlacakSatirPlani;
    /**
     * The SatirPlani
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OdemePlaniPointer
     */
    public $SatirPlani;
    /**
     * The SatirGrubu
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\NesneGrubu
     */
    public $SatirGrubu;
    /**
     * The MakbuzNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MakbuzNo;
    /**
     * The Aciklama
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Aciklama;
    /**
     * The KurFarkiDovizi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\DovizTuruPointer
     */
    public $KurFarkiDovizi;
    /**
     * The KdvTutari
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\DovizliTutar
     */
    public $KdvTutari;
    /**
     * The Islem
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\EvrakIslemTuruPointer
     */
    public $Islem;
    /**
     * The CariFisi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CariFisiPointer
     */
    public $CariFisi;
    /**
     * The BorcIsyeri
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IsYeriPointer
     */
    public $BorcIsyeri;
    /**
     * The AlacakIsyeri
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IsYeriPointer
     */
    public $AlacakIsyeri;
    /**
     * The IlgiliProje
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PYProjePointer
     */
    public $IlgiliProje;
    /**
     * The SatisFaturasi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\SatisFaturasiPointer
     */
    public $SatisFaturasi;
    /**
     * The IlgiliAlimEvraklari
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfCariFisiIlgiliAlimEvragi
     */
    public $IlgiliAlimEvraklari;
    /**
     * The OdemeTalepFormundaKullanilanTutar
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\DovizliTutar
     */
    public $OdemeTalepFormundaKullanilanTutar;
    /**
     * Constructor method for CariFisiSatiri
     * @uses CariFisiSatiri::setKdvOrani()
     * @uses CariFisiSatiri::setKDVDahilMi()
     * @uses CariFisiSatiri::setIlgiliOdemeTalepFormuSatirObjId()
     * @uses CariFisiSatiri::setCari()
     * @uses CariFisiSatiri::setKarsiCari()
     * @uses CariFisiSatiri::setKarsiKasa()
     * @uses CariFisiSatiri::setBorc()
     * @uses CariFisiSatiri::setAlacak()
     * @uses CariFisiSatiri::setAlacakSatirPlani()
     * @uses CariFisiSatiri::setSatirPlani()
     * @uses CariFisiSatiri::setSatirGrubu()
     * @uses CariFisiSatiri::setMakbuzNo()
     * @uses CariFisiSatiri::setAciklama()
     * @uses CariFisiSatiri::setKurFarkiDovizi()
     * @uses CariFisiSatiri::setKdvTutari()
     * @uses CariFisiSatiri::setIslem()
     * @uses CariFisiSatiri::setCariFisi()
     * @uses CariFisiSatiri::setBorcIsyeri()
     * @uses CariFisiSatiri::setAlacakIsyeri()
     * @uses CariFisiSatiri::setIlgiliProje()
     * @uses CariFisiSatiri::setSatisFaturasi()
     * @uses CariFisiSatiri::setIlgiliAlimEvraklari()
     * @uses CariFisiSatiri::setOdemeTalepFormundaKullanilanTutar()
     * @param float $kdvOrani
     * @param bool $kDVDahilMi
     * @param int $ilgiliOdemeTalepFormuSatirObjId
     * @param \StructType\CariHesabiPointer $cari
     * @param \StructType\CariHesabiPointer $karsiCari
     * @param \StructType\KasaHesabiPointer $karsiKasa
     * @param \StructType\DovizliTutar $borc
     * @param \StructType\DovizliTutar $alacak
     * @param \StructType\OdemePlaniPointer $alacakSatirPlani
     * @param \StructType\OdemePlaniPointer $satirPlani
     * @param \StructType\NesneGrubu $satirGrubu
     * @param string $makbuzNo
     * @param string $aciklama
     * @param \StructType\DovizTuruPointer $kurFarkiDovizi
     * @param \StructType\DovizliTutar $kdvTutari
     * @param \StructType\EvrakIslemTuruPointer $islem
     * @param \StructType\CariFisiPointer $cariFisi
     * @param \StructType\IsYeriPointer $borcIsyeri
     * @param \StructType\IsYeriPointer $alacakIsyeri
     * @param \StructType\PYProjePointer $ilgiliProje
     * @param \StructType\SatisFaturasiPointer $satisFaturasi
     * @param \ArrayType\ArrayOfCariFisiIlgiliAlimEvragi $ilgiliAlimEvraklari
     * @param \StructType\DovizliTutar $odemeTalepFormundaKullanilanTutar
     */
    public function __construct($kdvOrani = null, $kDVDahilMi = null, $ilgiliOdemeTalepFormuSatirObjId = null, \StructType\CariHesabiPointer $cari = null, \StructType\CariHesabiPointer $karsiCari = null, \StructType\KasaHesabiPointer $karsiKasa = null, \StructType\DovizliTutar $borc = null, \StructType\DovizliTutar $alacak = null, \StructType\OdemePlaniPointer $alacakSatirPlani = null, \StructType\OdemePlaniPointer $satirPlani = null, \StructType\NesneGrubu $satirGrubu = null, $makbuzNo = null, $aciklama = null, \StructType\DovizTuruPointer $kurFarkiDovizi = null, \StructType\DovizliTutar $kdvTutari = null, \StructType\EvrakIslemTuruPointer $islem = null, \StructType\CariFisiPointer $cariFisi = null, \StructType\IsYeriPointer $borcIsyeri = null, \StructType\IsYeriPointer $alacakIsyeri = null, \StructType\PYProjePointer $ilgiliProje = null, \StructType\SatisFaturasiPointer $satisFaturasi = null, \ArrayType\ArrayOfCariFisiIlgiliAlimEvragi $ilgiliAlimEvraklari = null, \StructType\DovizliTutar $odemeTalepFormundaKullanilanTutar = null)
    {
        $this
            ->setKdvOrani($kdvOrani)
            ->setKDVDahilMi($kDVDahilMi)
            ->setIlgiliOdemeTalepFormuSatirObjId($ilgiliOdemeTalepFormuSatirObjId)
            ->setCari($cari)
            ->setKarsiCari($karsiCari)
            ->setKarsiKasa($karsiKasa)
            ->setBorc($borc)
            ->setAlacak($alacak)
            ->setAlacakSatirPlani($alacakSatirPlani)
            ->setSatirPlani($satirPlani)
            ->setSatirGrubu($satirGrubu)
            ->setMakbuzNo($makbuzNo)
            ->setAciklama($aciklama)
            ->setKurFarkiDovizi($kurFarkiDovizi)
            ->setKdvTutari($kdvTutari)
            ->setIslem($islem)
            ->setCariFisi($cariFisi)
            ->setBorcIsyeri($borcIsyeri)
            ->setAlacakIsyeri($alacakIsyeri)
            ->setIlgiliProje($ilgiliProje)
            ->setSatisFaturasi($satisFaturasi)
            ->setIlgiliAlimEvraklari($ilgiliAlimEvraklari)
            ->setOdemeTalepFormundaKullanilanTutar($odemeTalepFormundaKullanilanTutar);
    }
    /**
     * Get KdvOrani value
     * @return float
     */
    public function getKdvOrani()
    {
        return $this->KdvOrani;
    }
    /**
     * Set KdvOrani value
     * @param float $kdvOrani
     * @return \StructType\CariFisiSatiri
     */
    public function setKdvOrani($kdvOrani = null)
    {
        // validation for constraint: float
        if (!is_null($kdvOrani) && !(is_float($kdvOrani) || is_numeric($kdvOrani))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($kdvOrani, true), gettype($kdvOrani)), __LINE__);
        }
        $this->KdvOrani = $kdvOrani;
        return $this;
    }
    /**
     * Get KDVDahilMi value
     * @return bool
     */
    public function getKDVDahilMi()
    {
        return $this->KDVDahilMi;
    }
    /**
     * Set KDVDahilMi value
     * @param bool $kDVDahilMi
     * @return \StructType\CariFisiSatiri
     */
    public function setKDVDahilMi($kDVDahilMi = null)
    {
        // validation for constraint: boolean
        if (!is_null($kDVDahilMi) && !is_bool($kDVDahilMi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($kDVDahilMi, true), gettype($kDVDahilMi)), __LINE__);
        }
        $this->KDVDahilMi = $kDVDahilMi;
        return $this;
    }
    /**
     * Get IlgiliOdemeTalepFormuSatirObjId value
     * @return int
     */
    public function getIlgiliOdemeTalepFormuSatirObjId()
    {
        return $this->IlgiliOdemeTalepFormuSatirObjId;
    }
    /**
     * Set IlgiliOdemeTalepFormuSatirObjId value
     * @param int $ilgiliOdemeTalepFormuSatirObjId
     * @return \StructType\CariFisiSatiri
     */
    public function setIlgiliOdemeTalepFormuSatirObjId($ilgiliOdemeTalepFormuSatirObjId = null)
    {
        // validation for constraint: int
        if (!is_null($ilgiliOdemeTalepFormuSatirObjId) && !(is_int($ilgiliOdemeTalepFormuSatirObjId) || ctype_digit($ilgiliOdemeTalepFormuSatirObjId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ilgiliOdemeTalepFormuSatirObjId, true), gettype($ilgiliOdemeTalepFormuSatirObjId)), __LINE__);
        }
        $this->IlgiliOdemeTalepFormuSatirObjId = $ilgiliOdemeTalepFormuSatirObjId;
        return $this;
    }
    /**
     * Get Cari value
     * @return \StructType\CariHesabiPointer|null
     */
    public function getCari()
    {
        return $this->Cari;
    }
    /**
     * Set Cari value
     * @param \StructType\CariHesabiPointer $cari
     * @return \StructType\CariFisiSatiri
     */
    public function setCari(\StructType\CariHesabiPointer $cari = null)
    {
        $this->Cari = $cari;
        return $this;
    }
    /**
     * Get KarsiCari value
     * @return \StructType\CariHesabiPointer|null
     */
    public function getKarsiCari()
    {
        return $this->KarsiCari;
    }
    /**
     * Set KarsiCari value
     * @param \StructType\CariHesabiPointer $karsiCari
     * @return \StructType\CariFisiSatiri
     */
    public function setKarsiCari(\StructType\CariHesabiPointer $karsiCari = null)
    {
        $this->KarsiCari = $karsiCari;
        return $this;
    }
    /**
     * Get KarsiKasa value
     * @return \StructType\KasaHesabiPointer|null
     */
    public function getKarsiKasa()
    {
        return $this->KarsiKasa;
    }
    /**
     * Set KarsiKasa value
     * @param \StructType\KasaHesabiPointer $karsiKasa
     * @return \StructType\CariFisiSatiri
     */
    public function setKarsiKasa(\StructType\KasaHesabiPointer $karsiKasa = null)
    {
        $this->KarsiKasa = $karsiKasa;
        return $this;
    }
    /**
     * Get Borc value
     * @return \StructType\DovizliTutar|null
     */
    public function getBorc()
    {
        return $this->Borc;
    }
    /**
     * Set Borc value
     * @param \StructType\DovizliTutar $borc
     * @return \StructType\CariFisiSatiri
     */
    public function setBorc(\StructType\DovizliTutar $borc = null)
    {
        $this->Borc = $borc;
        return $this;
    }
    /**
     * Get Alacak value
     * @return \StructType\DovizliTutar|null
     */
    public function getAlacak()
    {
        return $this->Alacak;
    }
    /**
     * Set Alacak value
     * @param \StructType\DovizliTutar $alacak
     * @return \StructType\CariFisiSatiri
     */
    public function setAlacak(\StructType\DovizliTutar $alacak = null)
    {
        $this->Alacak = $alacak;
        return $this;
    }
    /**
     * Get AlacakSatirPlani value
     * @return \StructType\OdemePlaniPointer|null
     */
    public function getAlacakSatirPlani()
    {
        return $this->AlacakSatirPlani;
    }
    /**
     * Set AlacakSatirPlani value
     * @param \StructType\OdemePlaniPointer $alacakSatirPlani
     * @return \StructType\CariFisiSatiri
     */
    public function setAlacakSatirPlani(\StructType\OdemePlaniPointer $alacakSatirPlani = null)
    {
        $this->AlacakSatirPlani = $alacakSatirPlani;
        return $this;
    }
    /**
     * Get SatirPlani value
     * @return \StructType\OdemePlaniPointer|null
     */
    public function getSatirPlani()
    {
        return $this->SatirPlani;
    }
    /**
     * Set SatirPlani value
     * @param \StructType\OdemePlaniPointer $satirPlani
     * @return \StructType\CariFisiSatiri
     */
    public function setSatirPlani(\StructType\OdemePlaniPointer $satirPlani = null)
    {
        $this->SatirPlani = $satirPlani;
        return $this;
    }
    /**
     * Get SatirGrubu value
     * @return \StructType\NesneGrubu|null
     */
    public function getSatirGrubu()
    {
        return $this->SatirGrubu;
    }
    /**
     * Set SatirGrubu value
     * @param \StructType\NesneGrubu $satirGrubu
     * @return \StructType\CariFisiSatiri
     */
    public function setSatirGrubu(\StructType\NesneGrubu $satirGrubu = null)
    {
        $this->SatirGrubu = $satirGrubu;
        return $this;
    }
    /**
     * Get MakbuzNo value
     * @return string|null
     */
    public function getMakbuzNo()
    {
        return $this->MakbuzNo;
    }
    /**
     * Set MakbuzNo value
     * @param string $makbuzNo
     * @return \StructType\CariFisiSatiri
     */
    public function setMakbuzNo($makbuzNo = null)
    {
        // validation for constraint: string
        if (!is_null($makbuzNo) && !is_string($makbuzNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($makbuzNo, true), gettype($makbuzNo)), __LINE__);
        }
        $this->MakbuzNo = $makbuzNo;
        return $this;
    }
    /**
     * Get Aciklama value
     * @return string|null
     */
    public function getAciklama()
    {
        return $this->Aciklama;
    }
    /**
     * Set Aciklama value
     * @param string $aciklama
     * @return \StructType\CariFisiSatiri
     */
    public function setAciklama($aciklama = null)
    {
        // validation for constraint: string
        if (!is_null($aciklama) && !is_string($aciklama)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aciklama, true), gettype($aciklama)), __LINE__);
        }
        $this->Aciklama = $aciklama;
        return $this;
    }
    /**
     * Get KurFarkiDovizi value
     * @return \StructType\DovizTuruPointer|null
     */
    public function getKurFarkiDovizi()
    {
        return $this->KurFarkiDovizi;
    }
    /**
     * Set KurFarkiDovizi value
     * @param \StructType\DovizTuruPointer $kurFarkiDovizi
     * @return \StructType\CariFisiSatiri
     */
    public function setKurFarkiDovizi(\StructType\DovizTuruPointer $kurFarkiDovizi = null)
    {
        $this->KurFarkiDovizi = $kurFarkiDovizi;
        return $this;
    }
    /**
     * Get KdvTutari value
     * @return \StructType\DovizliTutar|null
     */
    public function getKdvTutari()
    {
        return $this->KdvTutari;
    }
    /**
     * Set KdvTutari value
     * @param \StructType\DovizliTutar $kdvTutari
     * @return \StructType\CariFisiSatiri
     */
    public function setKdvTutari(\StructType\DovizliTutar $kdvTutari = null)
    {
        $this->KdvTutari = $kdvTutari;
        return $this;
    }
    /**
     * Get Islem value
     * @return \StructType\EvrakIslemTuruPointer|null
     */
    public function getIslem()
    {
        return $this->Islem;
    }
    /**
     * Set Islem value
     * @param \StructType\EvrakIslemTuruPointer $islem
     * @return \StructType\CariFisiSatiri
     */
    public function setIslem(\StructType\EvrakIslemTuruPointer $islem = null)
    {
        $this->Islem = $islem;
        return $this;
    }
    /**
     * Get CariFisi value
     * @return \StructType\CariFisiPointer|null
     */
    public function getCariFisi()
    {
        return $this->CariFisi;
    }
    /**
     * Set CariFisi value
     * @param \StructType\CariFisiPointer $cariFisi
     * @return \StructType\CariFisiSatiri
     */
    public function setCariFisi(\StructType\CariFisiPointer $cariFisi = null)
    {
        $this->CariFisi = $cariFisi;
        return $this;
    }
    /**
     * Get BorcIsyeri value
     * @return \StructType\IsYeriPointer|null
     */
    public function getBorcIsyeri()
    {
        return $this->BorcIsyeri;
    }
    /**
     * Set BorcIsyeri value
     * @param \StructType\IsYeriPointer $borcIsyeri
     * @return \StructType\CariFisiSatiri
     */
    public function setBorcIsyeri(\StructType\IsYeriPointer $borcIsyeri = null)
    {
        $this->BorcIsyeri = $borcIsyeri;
        return $this;
    }
    /**
     * Get AlacakIsyeri value
     * @return \StructType\IsYeriPointer|null
     */
    public function getAlacakIsyeri()
    {
        return $this->AlacakIsyeri;
    }
    /**
     * Set AlacakIsyeri value
     * @param \StructType\IsYeriPointer $alacakIsyeri
     * @return \StructType\CariFisiSatiri
     */
    public function setAlacakIsyeri(\StructType\IsYeriPointer $alacakIsyeri = null)
    {
        $this->AlacakIsyeri = $alacakIsyeri;
        return $this;
    }
    /**
     * Get IlgiliProje value
     * @return \StructType\PYProjePointer|null
     */
    public function getIlgiliProje()
    {
        return $this->IlgiliProje;
    }
    /**
     * Set IlgiliProje value
     * @param \StructType\PYProjePointer $ilgiliProje
     * @return \StructType\CariFisiSatiri
     */
    public function setIlgiliProje(\StructType\PYProjePointer $ilgiliProje = null)
    {
        $this->IlgiliProje = $ilgiliProje;
        return $this;
    }
    /**
     * Get SatisFaturasi value
     * @return \StructType\SatisFaturasiPointer|null
     */
    public function getSatisFaturasi()
    {
        return $this->SatisFaturasi;
    }
    /**
     * Set SatisFaturasi value
     * @param \StructType\SatisFaturasiPointer $satisFaturasi
     * @return \StructType\CariFisiSatiri
     */
    public function setSatisFaturasi(\StructType\SatisFaturasiPointer $satisFaturasi = null)
    {
        $this->SatisFaturasi = $satisFaturasi;
        return $this;
    }
    /**
     * Get IlgiliAlimEvraklari value
     * @return \ArrayType\ArrayOfCariFisiIlgiliAlimEvragi|null
     */
    public function getIlgiliAlimEvraklari()
    {
        return $this->IlgiliAlimEvraklari;
    }
    /**
     * Set IlgiliAlimEvraklari value
     * @param \ArrayType\ArrayOfCariFisiIlgiliAlimEvragi $ilgiliAlimEvraklari
     * @return \StructType\CariFisiSatiri
     */
    public function setIlgiliAlimEvraklari(\ArrayType\ArrayOfCariFisiIlgiliAlimEvragi $ilgiliAlimEvraklari = null)
    {
        $this->IlgiliAlimEvraklari = $ilgiliAlimEvraklari;
        return $this;
    }
    /**
     * Get OdemeTalepFormundaKullanilanTutar value
     * @return \StructType\DovizliTutar|null
     */
    public function getOdemeTalepFormundaKullanilanTutar()
    {
        return $this->OdemeTalepFormundaKullanilanTutar;
    }
    /**
     * Set OdemeTalepFormundaKullanilanTutar value
     * @param \StructType\DovizliTutar $odemeTalepFormundaKullanilanTutar
     * @return \StructType\CariFisiSatiri
     */
    public function setOdemeTalepFormundaKullanilanTutar(\StructType\DovizliTutar $odemeTalepFormundaKullanilanTutar = null)
    {
        $this->OdemeTalepFormundaKullanilanTutar = $odemeTalepFormundaKullanilanTutar;
        return $this;
    }
}
