<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BankaSubesi StructType
 * @subpackage Structs
 */
class BankaSubesi extends SerendipEntity
{
    /**
     * The Aciklama
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Aciklama;
    /**
     * The Bankasi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\BankaPointer
     */
    public $Bankasi;
    /**
     * The Adresi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Adres
     */
    public $Adresi;
    /**
     * The IletisimBilgileri
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Iletisim
     */
    public $IletisimBilgileri;
    /**
     * The Kodu
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Kodu;
    /**
     * The Adi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Adi;
    /**
     * Constructor method for BankaSubesi
     * @uses BankaSubesi::setAciklama()
     * @uses BankaSubesi::setBankasi()
     * @uses BankaSubesi::setAdresi()
     * @uses BankaSubesi::setIletisimBilgileri()
     * @uses BankaSubesi::setKodu()
     * @uses BankaSubesi::setAdi()
     * @param string $aciklama
     * @param \StructType\BankaPointer $bankasi
     * @param \StructType\Adres $adresi
     * @param \StructType\Iletisim $iletisimBilgileri
     * @param string $kodu
     * @param string $adi
     */
    public function __construct($aciklama = null, \StructType\BankaPointer $bankasi = null, \StructType\Adres $adresi = null, \StructType\Iletisim $iletisimBilgileri = null, $kodu = null, $adi = null)
    {
        $this
            ->setAciklama($aciklama)
            ->setBankasi($bankasi)
            ->setAdresi($adresi)
            ->setIletisimBilgileri($iletisimBilgileri)
            ->setKodu($kodu)
            ->setAdi($adi);
    }
    /**
     * Get Aciklama value
     * @return string|null
     */
    public function getAciklama()
    {
        return $this->Aciklama;
    }
    /**
     * Set Aciklama value
     * @param string $aciklama
     * @return \StructType\BankaSubesi
     */
    public function setAciklama($aciklama = null)
    {
        // validation for constraint: string
        if (!is_null($aciklama) && !is_string($aciklama)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aciklama, true), gettype($aciklama)), __LINE__);
        }
        $this->Aciklama = $aciklama;
        return $this;
    }
    /**
     * Get Bankasi value
     * @return \StructType\BankaPointer|null
     */
    public function getBankasi()
    {
        return $this->Bankasi;
    }
    /**
     * Set Bankasi value
     * @param \StructType\BankaPointer $bankasi
     * @return \StructType\BankaSubesi
     */
    public function setBankasi(\StructType\BankaPointer $bankasi = null)
    {
        $this->Bankasi = $bankasi;
        return $this;
    }
    /**
     * Get Adresi value
     * @return \StructType\Adres|null
     */
    public function getAdresi()
    {
        return $this->Adresi;
    }
    /**
     * Set Adresi value
     * @param \StructType\Adres $adresi
     * @return \StructType\BankaSubesi
     */
    public function setAdresi(\StructType\Adres $adresi = null)
    {
        $this->Adresi = $adresi;
        return $this;
    }
    /**
     * Get IletisimBilgileri value
     * @return \StructType\Iletisim|null
     */
    public function getIletisimBilgileri()
    {
        return $this->IletisimBilgileri;
    }
    /**
     * Set IletisimBilgileri value
     * @param \StructType\Iletisim $iletisimBilgileri
     * @return \StructType\BankaSubesi
     */
    public function setIletisimBilgileri(\StructType\Iletisim $iletisimBilgileri = null)
    {
        $this->IletisimBilgileri = $iletisimBilgileri;
        return $this;
    }
    /**
     * Get Kodu value
     * @return string|null
     */
    public function getKodu()
    {
        return $this->Kodu;
    }
    /**
     * Set Kodu value
     * @param string $kodu
     * @return \StructType\BankaSubesi
     */
    public function setKodu($kodu = null)
    {
        // validation for constraint: string
        if (!is_null($kodu) && !is_string($kodu)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kodu, true), gettype($kodu)), __LINE__);
        }
        $this->Kodu = $kodu;
        return $this;
    }
    /**
     * Get Adi value
     * @return string|null
     */
    public function getAdi()
    {
        return $this->Adi;
    }
    /**
     * Set Adi value
     * @param string $adi
     * @return \StructType\BankaSubesi
     */
    public function setAdi($adi = null)
    {
        // validation for constraint: string
        if (!is_null($adi) && !is_string($adi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($adi, true), gettype($adi)), __LINE__);
        }
        $this->Adi = $adi;
        return $this;
    }
}
