<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for KTesellum StructType
 * @subpackage Structs
 */
class KTesellum extends TESFAT
{
    /**
     * The TesellumTuru
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $TesellumTuru;
    /**
     * The OdemeSekli
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $OdemeSekli;
    /**
     * The TATNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $TATNo;
    /**
     * The IsHizliTesellumEvrak
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsHizliTesellumEvrak;
    /**
     * The IsKampanyaSozlemesiKullanabilir
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsKampanyaSozlemesiKullanabilir;
    /**
     * The IadeMi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IadeMi;
    /**
     * The IsEphHesaplansin
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsEphHesaplansin;
    /**
     * The Faturasi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\KFaturaPointer
     */
    public $Faturasi;
    /**
     * The FaturalayacakSube
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\KSubePointer
     */
    public $FaturalayacakSube;
    /**
     * The IadeTesellum
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\KTesellumPointer
     */
    public $IadeTesellum;
    /**
     * The KampanyaSifresi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $KampanyaSifresi;
    /**
     * The TesellumEkBilgi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\KTesellumEkBilgi
     */
    public $TesellumEkBilgi;
    /**
     * Constructor method for KTesellum
     * @uses KTesellum::setTesellumTuru()
     * @uses KTesellum::setOdemeSekli()
     * @uses KTesellum::setTATNo()
     * @uses KTesellum::setIsHizliTesellumEvrak()
     * @uses KTesellum::setIsKampanyaSozlemesiKullanabilir()
     * @uses KTesellum::setIadeMi()
     * @uses KTesellum::setIsEphHesaplansin()
     * @uses KTesellum::setFaturasi()
     * @uses KTesellum::setFaturalayacakSube()
     * @uses KTesellum::setIadeTesellum()
     * @uses KTesellum::setKampanyaSifresi()
     * @uses KTesellum::setTesellumEkBilgi()
     * @param string $tesellumTuru
     * @param string $odemeSekli
     * @param int $tATNo
     * @param bool $isHizliTesellumEvrak
     * @param bool $isKampanyaSozlemesiKullanabilir
     * @param bool $iadeMi
     * @param bool $isEphHesaplansin
     * @param \StructType\KFaturaPointer $faturasi
     * @param \StructType\KSubePointer $faturalayacakSube
     * @param \StructType\KTesellumPointer $iadeTesellum
     * @param string $kampanyaSifresi
     * @param \StructType\KTesellumEkBilgi $tesellumEkBilgi
     */
    public function __construct($tesellumTuru = null, $odemeSekli = null, $tATNo = null, $isHizliTesellumEvrak = null, $isKampanyaSozlemesiKullanabilir = null, $iadeMi = null, $isEphHesaplansin = null, \StructType\KFaturaPointer $faturasi = null, \StructType\KSubePointer $faturalayacakSube = null, \StructType\KTesellumPointer $iadeTesellum = null, $kampanyaSifresi = null, \StructType\KTesellumEkBilgi $tesellumEkBilgi = null)
    {
        $this
            ->setTesellumTuru($tesellumTuru)
            ->setOdemeSekli($odemeSekli)
            ->setTATNo($tATNo)
            ->setIsHizliTesellumEvrak($isHizliTesellumEvrak)
            ->setIsKampanyaSozlemesiKullanabilir($isKampanyaSozlemesiKullanabilir)
            ->setIadeMi($iadeMi)
            ->setIsEphHesaplansin($isEphHesaplansin)
            ->setFaturasi($faturasi)
            ->setFaturalayacakSube($faturalayacakSube)
            ->setIadeTesellum($iadeTesellum)
            ->setKampanyaSifresi($kampanyaSifresi)
            ->setTesellumEkBilgi($tesellumEkBilgi);
    }
    /**
     * Get TesellumTuru value
     * @return string
     */
    public function getTesellumTuru()
    {
        return $this->TesellumTuru;
    }
    /**
     * Set TesellumTuru value
     * @uses \EnumType\KEvrakTurleri::valueIsValid()
     * @uses \EnumType\KEvrakTurleri::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $tesellumTuru
     * @return \StructType\KTesellum
     */
    public function setTesellumTuru($tesellumTuru = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\KEvrakTurleri::valueIsValid($tesellumTuru)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\KEvrakTurleri', is_array($tesellumTuru) ? implode(', ', $tesellumTuru) : var_export($tesellumTuru, true), implode(', ', \EnumType\KEvrakTurleri::getValidValues())), __LINE__);
        }
        $this->TesellumTuru = $tesellumTuru;
        return $this;
    }
    /**
     * Get OdemeSekli value
     * @return string
     */
    public function getOdemeSekli()
    {
        return $this->OdemeSekli;
    }
    /**
     * Set OdemeSekli value
     * @uses \EnumType\KTesellumOdemeSekli::valueIsValid()
     * @uses \EnumType\KTesellumOdemeSekli::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $odemeSekli
     * @return \StructType\KTesellum
     */
    public function setOdemeSekli($odemeSekli = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\KTesellumOdemeSekli::valueIsValid($odemeSekli)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\KTesellumOdemeSekli', is_array($odemeSekli) ? implode(', ', $odemeSekli) : var_export($odemeSekli, true), implode(', ', \EnumType\KTesellumOdemeSekli::getValidValues())), __LINE__);
        }
        $this->OdemeSekli = $odemeSekli;
        return $this;
    }
    /**
     * Get TATNo value
     * @return int
     */
    public function getTATNo()
    {
        return $this->TATNo;
    }
    /**
     * Set TATNo value
     * @param int $tATNo
     * @return \StructType\KTesellum
     */
    public function setTATNo($tATNo = null)
    {
        // validation for constraint: int
        if (!is_null($tATNo) && !(is_int($tATNo) || ctype_digit($tATNo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($tATNo, true), gettype($tATNo)), __LINE__);
        }
        $this->TATNo = $tATNo;
        return $this;
    }
    /**
     * Get IsHizliTesellumEvrak value
     * @return bool
     */
    public function getIsHizliTesellumEvrak()
    {
        return $this->IsHizliTesellumEvrak;
    }
    /**
     * Set IsHizliTesellumEvrak value
     * @param bool $isHizliTesellumEvrak
     * @return \StructType\KTesellum
     */
    public function setIsHizliTesellumEvrak($isHizliTesellumEvrak = null)
    {
        // validation for constraint: boolean
        if (!is_null($isHizliTesellumEvrak) && !is_bool($isHizliTesellumEvrak)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isHizliTesellumEvrak, true), gettype($isHizliTesellumEvrak)), __LINE__);
        }
        $this->IsHizliTesellumEvrak = $isHizliTesellumEvrak;
        return $this;
    }
    /**
     * Get IsKampanyaSozlemesiKullanabilir value
     * @return bool
     */
    public function getIsKampanyaSozlemesiKullanabilir()
    {
        return $this->IsKampanyaSozlemesiKullanabilir;
    }
    /**
     * Set IsKampanyaSozlemesiKullanabilir value
     * @param bool $isKampanyaSozlemesiKullanabilir
     * @return \StructType\KTesellum
     */
    public function setIsKampanyaSozlemesiKullanabilir($isKampanyaSozlemesiKullanabilir = null)
    {
        // validation for constraint: boolean
        if (!is_null($isKampanyaSozlemesiKullanabilir) && !is_bool($isKampanyaSozlemesiKullanabilir)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isKampanyaSozlemesiKullanabilir, true), gettype($isKampanyaSozlemesiKullanabilir)), __LINE__);
        }
        $this->IsKampanyaSozlemesiKullanabilir = $isKampanyaSozlemesiKullanabilir;
        return $this;
    }
    /**
     * Get IadeMi value
     * @return bool
     */
    public function getIadeMi()
    {
        return $this->IadeMi;
    }
    /**
     * Set IadeMi value
     * @param bool $iadeMi
     * @return \StructType\KTesellum
     */
    public function setIadeMi($iadeMi = null)
    {
        // validation for constraint: boolean
        if (!is_null($iadeMi) && !is_bool($iadeMi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($iadeMi, true), gettype($iadeMi)), __LINE__);
        }
        $this->IadeMi = $iadeMi;
        return $this;
    }
    /**
     * Get IsEphHesaplansin value
     * @return bool
     */
    public function getIsEphHesaplansin()
    {
        return $this->IsEphHesaplansin;
    }
    /**
     * Set IsEphHesaplansin value
     * @param bool $isEphHesaplansin
     * @return \StructType\KTesellum
     */
    public function setIsEphHesaplansin($isEphHesaplansin = null)
    {
        // validation for constraint: boolean
        if (!is_null($isEphHesaplansin) && !is_bool($isEphHesaplansin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isEphHesaplansin, true), gettype($isEphHesaplansin)), __LINE__);
        }
        $this->IsEphHesaplansin = $isEphHesaplansin;
        return $this;
    }
    /**
     * Get Faturasi value
     * @return \StructType\KFaturaPointer|null
     */
    public function getFaturasi()
    {
        return $this->Faturasi;
    }
    /**
     * Set Faturasi value
     * @param \StructType\KFaturaPointer $faturasi
     * @return \StructType\KTesellum
     */
    public function setFaturasi(\StructType\KFaturaPointer $faturasi = null)
    {
        $this->Faturasi = $faturasi;
        return $this;
    }
    /**
     * Get FaturalayacakSube value
     * @return \StructType\KSubePointer|null
     */
    public function getFaturalayacakSube()
    {
        return $this->FaturalayacakSube;
    }
    /**
     * Set FaturalayacakSube value
     * @param \StructType\KSubePointer $faturalayacakSube
     * @return \StructType\KTesellum
     */
    public function setFaturalayacakSube(\StructType\KSubePointer $faturalayacakSube = null)
    {
        $this->FaturalayacakSube = $faturalayacakSube;
        return $this;
    }
    /**
     * Get IadeTesellum value
     * @return \StructType\KTesellumPointer|null
     */
    public function getIadeTesellum()
    {
        return $this->IadeTesellum;
    }
    /**
     * Set IadeTesellum value
     * @param \StructType\KTesellumPointer $iadeTesellum
     * @return \StructType\KTesellum
     */
    public function setIadeTesellum(\StructType\KTesellumPointer $iadeTesellum = null)
    {
        $this->IadeTesellum = $iadeTesellum;
        return $this;
    }
    /**
     * Get KampanyaSifresi value
     * @return string|null
     */
    public function getKampanyaSifresi()
    {
        return $this->KampanyaSifresi;
    }
    /**
     * Set KampanyaSifresi value
     * @param string $kampanyaSifresi
     * @return \StructType\KTesellum
     */
    public function setKampanyaSifresi($kampanyaSifresi = null)
    {
        // validation for constraint: string
        if (!is_null($kampanyaSifresi) && !is_string($kampanyaSifresi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kampanyaSifresi, true), gettype($kampanyaSifresi)), __LINE__);
        }
        $this->KampanyaSifresi = $kampanyaSifresi;
        return $this;
    }
    /**
     * Get TesellumEkBilgi value
     * @return \StructType\KTesellumEkBilgi|null
     */
    public function getTesellumEkBilgi()
    {
        return $this->TesellumEkBilgi;
    }
    /**
     * Set TesellumEkBilgi value
     * @param \StructType\KTesellumEkBilgi $tesellumEkBilgi
     * @return \StructType\KTesellum
     */
    public function setTesellumEkBilgi(\StructType\KTesellumEkBilgi $tesellumEkBilgi = null)
    {
        $this->TesellumEkBilgi = $tesellumEkBilgi;
        return $this;
    }
}
