<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for KSurucuHareket StructType
 * @subpackage Structs
 */
class KSurucuHareket extends Entity
{
    /**
     * The HareketTar
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $HareketTar;
    /**
     * The HareketTip
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $HareketTip;
    /**
     * The Surucu
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\KSurucuPointer
     */
    public $Surucu;
    /**
     * The AracSeferAyak
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\KAracSeferAyakPointer
     */
    public $AracSeferAyak;
    /**
     * The HareketSube
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\KSubePointer
     */
    public $HareketSube;
    /**
     * The HareketYer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\KSevkAdresPointer
     */
    public $HareketYer;
    /**
     * The Aciklama
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Aciklama;
    /**
     * Constructor method for KSurucuHareket
     * @uses KSurucuHareket::setHareketTar()
     * @uses KSurucuHareket::setHareketTip()
     * @uses KSurucuHareket::setSurucu()
     * @uses KSurucuHareket::setAracSeferAyak()
     * @uses KSurucuHareket::setHareketSube()
     * @uses KSurucuHareket::setHareketYer()
     * @uses KSurucuHareket::setAciklama()
     * @param string $hareketTar
     * @param string $hareketTip
     * @param \StructType\KSurucuPointer $surucu
     * @param \StructType\KAracSeferAyakPointer $aracSeferAyak
     * @param \StructType\KSubePointer $hareketSube
     * @param \StructType\KSevkAdresPointer $hareketYer
     * @param string $aciklama
     */
    public function __construct($hareketTar = null, $hareketTip = null, \StructType\KSurucuPointer $surucu = null, \StructType\KAracSeferAyakPointer $aracSeferAyak = null, \StructType\KSubePointer $hareketSube = null, \StructType\KSevkAdresPointer $hareketYer = null, $aciklama = null)
    {
        $this
            ->setHareketTar($hareketTar)
            ->setHareketTip($hareketTip)
            ->setSurucu($surucu)
            ->setAracSeferAyak($aracSeferAyak)
            ->setHareketSube($hareketSube)
            ->setHareketYer($hareketYer)
            ->setAciklama($aciklama);
    }
    /**
     * Get HareketTar value
     * @return string
     */
    public function getHareketTar()
    {
        return $this->HareketTar;
    }
    /**
     * Set HareketTar value
     * @param string $hareketTar
     * @return \StructType\KSurucuHareket
     */
    public function setHareketTar($hareketTar = null)
    {
        // validation for constraint: string
        if (!is_null($hareketTar) && !is_string($hareketTar)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hareketTar, true), gettype($hareketTar)), __LINE__);
        }
        $this->HareketTar = $hareketTar;
        return $this;
    }
    /**
     * Get HareketTip value
     * @return string
     */
    public function getHareketTip()
    {
        return $this->HareketTip;
    }
    /**
     * Set HareketTip value
     * @uses \EnumType\AracHareketTip::valueIsValid()
     * @uses \EnumType\AracHareketTip::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $hareketTip
     * @return \StructType\KSurucuHareket
     */
    public function setHareketTip($hareketTip = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AracHareketTip::valueIsValid($hareketTip)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\AracHareketTip', is_array($hareketTip) ? implode(', ', $hareketTip) : var_export($hareketTip, true), implode(', ', \EnumType\AracHareketTip::getValidValues())), __LINE__);
        }
        $this->HareketTip = $hareketTip;
        return $this;
    }
    /**
     * Get Surucu value
     * @return \StructType\KSurucuPointer|null
     */
    public function getSurucu()
    {
        return $this->Surucu;
    }
    /**
     * Set Surucu value
     * @param \StructType\KSurucuPointer $surucu
     * @return \StructType\KSurucuHareket
     */
    public function setSurucu(\StructType\KSurucuPointer $surucu = null)
    {
        $this->Surucu = $surucu;
        return $this;
    }
    /**
     * Get AracSeferAyak value
     * @return \StructType\KAracSeferAyakPointer|null
     */
    public function getAracSeferAyak()
    {
        return $this->AracSeferAyak;
    }
    /**
     * Set AracSeferAyak value
     * @param \StructType\KAracSeferAyakPointer $aracSeferAyak
     * @return \StructType\KSurucuHareket
     */
    public function setAracSeferAyak(\StructType\KAracSeferAyakPointer $aracSeferAyak = null)
    {
        $this->AracSeferAyak = $aracSeferAyak;
        return $this;
    }
    /**
     * Get HareketSube value
     * @return \StructType\KSubePointer|null
     */
    public function getHareketSube()
    {
        return $this->HareketSube;
    }
    /**
     * Set HareketSube value
     * @param \StructType\KSubePointer $hareketSube
     * @return \StructType\KSurucuHareket
     */
    public function setHareketSube(\StructType\KSubePointer $hareketSube = null)
    {
        $this->HareketSube = $hareketSube;
        return $this;
    }
    /**
     * Get HareketYer value
     * @return \StructType\KSevkAdresPointer|null
     */
    public function getHareketYer()
    {
        return $this->HareketYer;
    }
    /**
     * Set HareketYer value
     * @param \StructType\KSevkAdresPointer $hareketYer
     * @return \StructType\KSurucuHareket
     */
    public function setHareketYer(\StructType\KSevkAdresPointer $hareketYer = null)
    {
        $this->HareketYer = $hareketYer;
        return $this;
    }
    /**
     * Get Aciklama value
     * @return string|null
     */
    public function getAciklama()
    {
        return $this->Aciklama;
    }
    /**
     * Set Aciklama value
     * @param string $aciklama
     * @return \StructType\KSurucuHareket
     */
    public function setAciklama($aciklama = null)
    {
        // validation for constraint: string
        if (!is_null($aciklama) && !is_string($aciklama)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aciklama, true), gettype($aciklama)), __LINE__);
        }
        $this->Aciklama = $aciklama;
        return $this;
    }
}
