<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for KBirim StructType
 * @subpackage Structs
 */
class KBirim extends Tanim
{
    /**
     * The DesiBas
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $DesiBas;
    /**
     * The DesiBit
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $DesiBit;
    /**
     * The KargoTakipVar
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $KargoTakipVar;
    /**
     * The BirimFiyat
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $BirimFiyat;
    /**
     * Constructor method for KBirim
     * @uses KBirim::setDesiBas()
     * @uses KBirim::setDesiBit()
     * @uses KBirim::setKargoTakipVar()
     * @uses KBirim::setBirimFiyat()
     * @param float $desiBas
     * @param float $desiBit
     * @param bool $kargoTakipVar
     * @param float $birimFiyat
     */
    public function __construct($desiBas = null, $desiBit = null, $kargoTakipVar = null, $birimFiyat = null)
    {
        $this
            ->setDesiBas($desiBas)
            ->setDesiBit($desiBit)
            ->setKargoTakipVar($kargoTakipVar)
            ->setBirimFiyat($birimFiyat);
    }
    /**
     * Get DesiBas value
     * @return float
     */
    public function getDesiBas()
    {
        return $this->DesiBas;
    }
    /**
     * Set DesiBas value
     * @param float $desiBas
     * @return \StructType\KBirim
     */
    public function setDesiBas($desiBas = null)
    {
        // validation for constraint: float
        if (!is_null($desiBas) && !(is_float($desiBas) || is_numeric($desiBas))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($desiBas, true), gettype($desiBas)), __LINE__);
        }
        $this->DesiBas = $desiBas;
        return $this;
    }
    /**
     * Get DesiBit value
     * @return float
     */
    public function getDesiBit()
    {
        return $this->DesiBit;
    }
    /**
     * Set DesiBit value
     * @param float $desiBit
     * @return \StructType\KBirim
     */
    public function setDesiBit($desiBit = null)
    {
        // validation for constraint: float
        if (!is_null($desiBit) && !(is_float($desiBit) || is_numeric($desiBit))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($desiBit, true), gettype($desiBit)), __LINE__);
        }
        $this->DesiBit = $desiBit;
        return $this;
    }
    /**
     * Get KargoTakipVar value
     * @return bool
     */
    public function getKargoTakipVar()
    {
        return $this->KargoTakipVar;
    }
    /**
     * Set KargoTakipVar value
     * @param bool $kargoTakipVar
     * @return \StructType\KBirim
     */
    public function setKargoTakipVar($kargoTakipVar = null)
    {
        // validation for constraint: boolean
        if (!is_null($kargoTakipVar) && !is_bool($kargoTakipVar)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($kargoTakipVar, true), gettype($kargoTakipVar)), __LINE__);
        }
        $this->KargoTakipVar = $kargoTakipVar;
        return $this;
    }
    /**
     * Get BirimFiyat value
     * @return float
     */
    public function getBirimFiyat()
    {
        return $this->BirimFiyat;
    }
    /**
     * Set BirimFiyat value
     * @param float $birimFiyat
     * @return \StructType\KBirim
     */
    public function setBirimFiyat($birimFiyat = null)
    {
        // validation for constraint: float
        if (!is_null($birimFiyat) && !(is_float($birimFiyat) || is_numeric($birimFiyat))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($birimFiyat, true), gettype($birimFiyat)), __LINE__);
        }
        $this->BirimFiyat = $birimFiyat;
        return $this;
    }
}
