<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for KAraciFirmaHareket StructType
 * @subpackage Structs
 */
class KAraciFirmaHareket extends ValueEntity
{
    /**
     * The KDVOrani
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $KDVOrani;
    /**
     * The Tarih
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Tarih;
    /**
     * The TakipNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TakipNo;
    /**
     * The AraciFirma
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\KCariPointer
     */
    public $AraciFirma;
    /**
     * The AraciFirmaSube
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\KCariPointer
     */
    public $AraciFirmaSube;
    /**
     * The ToplamTutar
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\DovizliTutar
     */
    public $ToplamTutar;
    /**
     * The KDVTutar
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\DovizliTutar
     */
    public $KDVTutar;
    /**
     * The Faturasi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\KFaturaPointer
     */
    public $Faturasi;
    /**
     * Constructor method for KAraciFirmaHareket
     * @uses KAraciFirmaHareket::setKDVOrani()
     * @uses KAraciFirmaHareket::setTarih()
     * @uses KAraciFirmaHareket::setTakipNo()
     * @uses KAraciFirmaHareket::setAraciFirma()
     * @uses KAraciFirmaHareket::setAraciFirmaSube()
     * @uses KAraciFirmaHareket::setToplamTutar()
     * @uses KAraciFirmaHareket::setKDVTutar()
     * @uses KAraciFirmaHareket::setFaturasi()
     * @param float $kDVOrani
     * @param string $tarih
     * @param string $takipNo
     * @param \StructType\KCariPointer $araciFirma
     * @param \StructType\KCariPointer $araciFirmaSube
     * @param \StructType\DovizliTutar $toplamTutar
     * @param \StructType\DovizliTutar $kDVTutar
     * @param \StructType\KFaturaPointer $faturasi
     */
    public function __construct($kDVOrani = null, $tarih = null, $takipNo = null, \StructType\KCariPointer $araciFirma = null, \StructType\KCariPointer $araciFirmaSube = null, \StructType\DovizliTutar $toplamTutar = null, \StructType\DovizliTutar $kDVTutar = null, \StructType\KFaturaPointer $faturasi = null)
    {
        $this
            ->setKDVOrani($kDVOrani)
            ->setTarih($tarih)
            ->setTakipNo($takipNo)
            ->setAraciFirma($araciFirma)
            ->setAraciFirmaSube($araciFirmaSube)
            ->setToplamTutar($toplamTutar)
            ->setKDVTutar($kDVTutar)
            ->setFaturasi($faturasi);
    }
    /**
     * Get KDVOrani value
     * @return float
     */
    public function getKDVOrani()
    {
        return $this->KDVOrani;
    }
    /**
     * Set KDVOrani value
     * @param float $kDVOrani
     * @return \StructType\KAraciFirmaHareket
     */
    public function setKDVOrani($kDVOrani = null)
    {
        // validation for constraint: float
        if (!is_null($kDVOrani) && !(is_float($kDVOrani) || is_numeric($kDVOrani))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($kDVOrani, true), gettype($kDVOrani)), __LINE__);
        }
        $this->KDVOrani = $kDVOrani;
        return $this;
    }
    /**
     * Get Tarih value
     * @return string
     */
    public function getTarih()
    {
        return $this->Tarih;
    }
    /**
     * Set Tarih value
     * @param string $tarih
     * @return \StructType\KAraciFirmaHareket
     */
    public function setTarih($tarih = null)
    {
        // validation for constraint: string
        if (!is_null($tarih) && !is_string($tarih)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tarih, true), gettype($tarih)), __LINE__);
        }
        $this->Tarih = $tarih;
        return $this;
    }
    /**
     * Get TakipNo value
     * @return string|null
     */
    public function getTakipNo()
    {
        return $this->TakipNo;
    }
    /**
     * Set TakipNo value
     * @param string $takipNo
     * @return \StructType\KAraciFirmaHareket
     */
    public function setTakipNo($takipNo = null)
    {
        // validation for constraint: string
        if (!is_null($takipNo) && !is_string($takipNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($takipNo, true), gettype($takipNo)), __LINE__);
        }
        $this->TakipNo = $takipNo;
        return $this;
    }
    /**
     * Get AraciFirma value
     * @return \StructType\KCariPointer|null
     */
    public function getAraciFirma()
    {
        return $this->AraciFirma;
    }
    /**
     * Set AraciFirma value
     * @param \StructType\KCariPointer $araciFirma
     * @return \StructType\KAraciFirmaHareket
     */
    public function setAraciFirma(\StructType\KCariPointer $araciFirma = null)
    {
        $this->AraciFirma = $araciFirma;
        return $this;
    }
    /**
     * Get AraciFirmaSube value
     * @return \StructType\KCariPointer|null
     */
    public function getAraciFirmaSube()
    {
        return $this->AraciFirmaSube;
    }
    /**
     * Set AraciFirmaSube value
     * @param \StructType\KCariPointer $araciFirmaSube
     * @return \StructType\KAraciFirmaHareket
     */
    public function setAraciFirmaSube(\StructType\KCariPointer $araciFirmaSube = null)
    {
        $this->AraciFirmaSube = $araciFirmaSube;
        return $this;
    }
    /**
     * Get ToplamTutar value
     * @return \StructType\DovizliTutar|null
     */
    public function getToplamTutar()
    {
        return $this->ToplamTutar;
    }
    /**
     * Set ToplamTutar value
     * @param \StructType\DovizliTutar $toplamTutar
     * @return \StructType\KAraciFirmaHareket
     */
    public function setToplamTutar(\StructType\DovizliTutar $toplamTutar = null)
    {
        $this->ToplamTutar = $toplamTutar;
        return $this;
    }
    /**
     * Get KDVTutar value
     * @return \StructType\DovizliTutar|null
     */
    public function getKDVTutar()
    {
        return $this->KDVTutar;
    }
    /**
     * Set KDVTutar value
     * @param \StructType\DovizliTutar $kDVTutar
     * @return \StructType\KAraciFirmaHareket
     */
    public function setKDVTutar(\StructType\DovizliTutar $kDVTutar = null)
    {
        $this->KDVTutar = $kDVTutar;
        return $this;
    }
    /**
     * Get Faturasi value
     * @return \StructType\KFaturaPointer|null
     */
    public function getFaturasi()
    {
        return $this->Faturasi;
    }
    /**
     * Set Faturasi value
     * @param \StructType\KFaturaPointer $faturasi
     * @return \StructType\KAraciFirmaHareket
     */
    public function setFaturasi(\StructType\KFaturaPointer $faturasi = null)
    {
        $this->Faturasi = $faturasi;
        return $this;
    }
}
