<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for KAdres StructType
 * @subpackage Structs
 */
class KAdres extends Entity
{
    /**
     * The AdresTip
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AdresTip;
    /**
     * The IsMahalleZorunlumu
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsMahalleZorunlumu;
    /**
     * The IsSemtZorunlumu
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsSemtZorunlumu;
    /**
     * The IL_ID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $IL_ID;
    /**
     * The ILCE_ID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ILCE_ID;
    /**
     * The DagitimSubesi_ObjId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $DagitimSubesi_ObjId;
    /**
     * The Nokta
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\KInterlandPointer
     */
    public $Nokta;
    /**
     * The NoktaAdi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NoktaAdi;
    /**
     * The Site
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\KInterlandPointer
     */
    public $Site;
    /**
     * The SiteAdi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SiteAdi;
    /**
     * The Sokak
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\KInterlandPointer
     */
    public $Sokak;
    /**
     * The SokakAdi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SokakAdi;
    /**
     * The Cadde
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\KInterlandPointer
     */
    public $Cadde;
    /**
     * The CaddeAdi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CaddeAdi;
    /**
     * The Semt
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\KInterlandPointer
     */
    public $Semt;
    /**
     * The SemtAdi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SemtAdi;
    /**
     * The Bucak
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\KInterlandPointer
     */
    public $Bucak;
    /**
     * The BucakAdi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BucakAdi;
    /**
     * The Mahalle
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\KInterlandPointer
     */
    public $Mahalle;
    /**
     * The MahalleAdi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MahalleAdi;
    /**
     * The Koy
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\KInterlandPointer
     */
    public $Koy;
    /**
     * The KoyAdi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $KoyAdi;
    /**
     * The Ilcesi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\KInterlandPointer
     */
    public $Ilcesi;
    /**
     * The IlceAdi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IlceAdi;
    /**
     * The Ili
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\KInterlandPointer
     */
    public $Ili;
    /**
     * The IlAdi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IlAdi;
    /**
     * The Ulkesi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\KInterlandPointer
     */
    public $Ulkesi;
    /**
     * The UlkeAdi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UlkeAdi;
    /**
     * The UlkeBolgesi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\KInterlandPointer
     */
    public $UlkeBolgesi;
    /**
     * The UlkeBolgeAdi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UlkeBolgeAdi;
    /**
     * The KapiNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $KapiNo;
    /**
     * The HaneNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $HaneNo;
    /**
     * The Blok
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Blok;
    /**
     * The Kat
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Kat;
    /**
     * The AdresSatiri
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AdresSatiri;
    /**
     * The UniqueTextCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UniqueTextCode;
    /**
     * The UniqueTextCodeGIS
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UniqueTextCodeGIS;
    /**
     * The UniqueTextHash
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UniqueTextHash;
    /**
     * The ToText
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ToText;
    /**
     * The IL_ADI
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IL_ADI;
    /**
     * The ILCE_ADI
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ILCE_ADI;
    /**
     * The TespitTip
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TespitTip;
    /**
     * The XCOOR
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $XCOOR;
    /**
     * The YCOOR
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $YCOOR;
    /**
     * The DagitimSubesi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DagitimSubesi;
    /**
     * The PostaKodu
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PostaKodu;
    /**
     * The FreeText
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FreeText;
    /**
     * Constructor method for KAdres
     * @uses KAdres::setAdresTip()
     * @uses KAdres::setIsMahalleZorunlumu()
     * @uses KAdres::setIsSemtZorunlumu()
     * @uses KAdres::setIL_ID()
     * @uses KAdres::setILCE_ID()
     * @uses KAdres::setDagitimSubesi_ObjId()
     * @uses KAdres::setNokta()
     * @uses KAdres::setNoktaAdi()
     * @uses KAdres::setSite()
     * @uses KAdres::setSiteAdi()
     * @uses KAdres::setSokak()
     * @uses KAdres::setSokakAdi()
     * @uses KAdres::setCadde()
     * @uses KAdres::setCaddeAdi()
     * @uses KAdres::setSemt()
     * @uses KAdres::setSemtAdi()
     * @uses KAdres::setBucak()
     * @uses KAdres::setBucakAdi()
     * @uses KAdres::setMahalle()
     * @uses KAdres::setMahalleAdi()
     * @uses KAdres::setKoy()
     * @uses KAdres::setKoyAdi()
     * @uses KAdres::setIlcesi()
     * @uses KAdres::setIlceAdi()
     * @uses KAdres::setIli()
     * @uses KAdres::setIlAdi()
     * @uses KAdres::setUlkesi()
     * @uses KAdres::setUlkeAdi()
     * @uses KAdres::setUlkeBolgesi()
     * @uses KAdres::setUlkeBolgeAdi()
     * @uses KAdres::setKapiNo()
     * @uses KAdres::setHaneNo()
     * @uses KAdres::setBlok()
     * @uses KAdres::setKat()
     * @uses KAdres::setAdresSatiri()
     * @uses KAdres::setUniqueTextCode()
     * @uses KAdres::setUniqueTextCodeGIS()
     * @uses KAdres::setUniqueTextHash()
     * @uses KAdres::setToText()
     * @uses KAdres::setIL_ADI()
     * @uses KAdres::setILCE_ADI()
     * @uses KAdres::setTespitTip()
     * @uses KAdres::setXCOOR()
     * @uses KAdres::setYCOOR()
     * @uses KAdres::setDagitimSubesi()
     * @uses KAdres::setPostaKodu()
     * @uses KAdres::setFreeText()
     * @param int $adresTip
     * @param bool $isMahalleZorunlumu
     * @param bool $isSemtZorunlumu
     * @param int $iL_ID
     * @param int $iLCE_ID
     * @param int $dagitimSubesi_ObjId
     * @param \StructType\KInterlandPointer $nokta
     * @param string $noktaAdi
     * @param \StructType\KInterlandPointer $site
     * @param string $siteAdi
     * @param \StructType\KInterlandPointer $sokak
     * @param string $sokakAdi
     * @param \StructType\KInterlandPointer $cadde
     * @param string $caddeAdi
     * @param \StructType\KInterlandPointer $semt
     * @param string $semtAdi
     * @param \StructType\KInterlandPointer $bucak
     * @param string $bucakAdi
     * @param \StructType\KInterlandPointer $mahalle
     * @param string $mahalleAdi
     * @param \StructType\KInterlandPointer $koy
     * @param string $koyAdi
     * @param \StructType\KInterlandPointer $ilcesi
     * @param string $ilceAdi
     * @param \StructType\KInterlandPointer $ili
     * @param string $ilAdi
     * @param \StructType\KInterlandPointer $ulkesi
     * @param string $ulkeAdi
     * @param \StructType\KInterlandPointer $ulkeBolgesi
     * @param string $ulkeBolgeAdi
     * @param string $kapiNo
     * @param string $haneNo
     * @param string $blok
     * @param string $kat
     * @param string $adresSatiri
     * @param string $uniqueTextCode
     * @param string $uniqueTextCodeGIS
     * @param string $uniqueTextHash
     * @param string $toText
     * @param string $iL_ADI
     * @param string $iLCE_ADI
     * @param string $tespitTip
     * @param string $xCOOR
     * @param string $yCOOR
     * @param string $dagitimSubesi
     * @param string $postaKodu
     * @param string $freeText
     */
    public function __construct($adresTip = null, $isMahalleZorunlumu = null, $isSemtZorunlumu = null, $iL_ID = null, $iLCE_ID = null, $dagitimSubesi_ObjId = null, \StructType\KInterlandPointer $nokta = null, $noktaAdi = null, \StructType\KInterlandPointer $site = null, $siteAdi = null, \StructType\KInterlandPointer $sokak = null, $sokakAdi = null, \StructType\KInterlandPointer $cadde = null, $caddeAdi = null, \StructType\KInterlandPointer $semt = null, $semtAdi = null, \StructType\KInterlandPointer $bucak = null, $bucakAdi = null, \StructType\KInterlandPointer $mahalle = null, $mahalleAdi = null, \StructType\KInterlandPointer $koy = null, $koyAdi = null, \StructType\KInterlandPointer $ilcesi = null, $ilceAdi = null, \StructType\KInterlandPointer $ili = null, $ilAdi = null, \StructType\KInterlandPointer $ulkesi = null, $ulkeAdi = null, \StructType\KInterlandPointer $ulkeBolgesi = null, $ulkeBolgeAdi = null, $kapiNo = null, $haneNo = null, $blok = null, $kat = null, $adresSatiri = null, $uniqueTextCode = null, $uniqueTextCodeGIS = null, $uniqueTextHash = null, $toText = null, $iL_ADI = null, $iLCE_ADI = null, $tespitTip = null, $xCOOR = null, $yCOOR = null, $dagitimSubesi = null, $postaKodu = null, $freeText = null)
    {
        $this
            ->setAdresTip($adresTip)
            ->setIsMahalleZorunlumu($isMahalleZorunlumu)
            ->setIsSemtZorunlumu($isSemtZorunlumu)
            ->setIL_ID($iL_ID)
            ->setILCE_ID($iLCE_ID)
            ->setDagitimSubesi_ObjId($dagitimSubesi_ObjId)
            ->setNokta($nokta)
            ->setNoktaAdi($noktaAdi)
            ->setSite($site)
            ->setSiteAdi($siteAdi)
            ->setSokak($sokak)
            ->setSokakAdi($sokakAdi)
            ->setCadde($cadde)
            ->setCaddeAdi($caddeAdi)
            ->setSemt($semt)
            ->setSemtAdi($semtAdi)
            ->setBucak($bucak)
            ->setBucakAdi($bucakAdi)
            ->setMahalle($mahalle)
            ->setMahalleAdi($mahalleAdi)
            ->setKoy($koy)
            ->setKoyAdi($koyAdi)
            ->setIlcesi($ilcesi)
            ->setIlceAdi($ilceAdi)
            ->setIli($ili)
            ->setIlAdi($ilAdi)
            ->setUlkesi($ulkesi)
            ->setUlkeAdi($ulkeAdi)
            ->setUlkeBolgesi($ulkeBolgesi)
            ->setUlkeBolgeAdi($ulkeBolgeAdi)
            ->setKapiNo($kapiNo)
            ->setHaneNo($haneNo)
            ->setBlok($blok)
            ->setKat($kat)
            ->setAdresSatiri($adresSatiri)
            ->setUniqueTextCode($uniqueTextCode)
            ->setUniqueTextCodeGIS($uniqueTextCodeGIS)
            ->setUniqueTextHash($uniqueTextHash)
            ->setToText($toText)
            ->setIL_ADI($iL_ADI)
            ->setILCE_ADI($iLCE_ADI)
            ->setTespitTip($tespitTip)
            ->setXCOOR($xCOOR)
            ->setYCOOR($yCOOR)
            ->setDagitimSubesi($dagitimSubesi)
            ->setPostaKodu($postaKodu)
            ->setFreeText($freeText);
    }
    /**
     * Get AdresTip value
     * @return int
     */
    public function getAdresTip()
    {
        return $this->AdresTip;
    }
    /**
     * Set AdresTip value
     * @param int $adresTip
     * @return \StructType\KAdres
     */
    public function setAdresTip($adresTip = null)
    {
        // validation for constraint: int
        if (!is_null($adresTip) && !(is_int($adresTip) || ctype_digit($adresTip))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($adresTip, true), gettype($adresTip)), __LINE__);
        }
        $this->AdresTip = $adresTip;
        return $this;
    }
    /**
     * Get IsMahalleZorunlumu value
     * @return bool
     */
    public function getIsMahalleZorunlumu()
    {
        return $this->IsMahalleZorunlumu;
    }
    /**
     * Set IsMahalleZorunlumu value
     * @param bool $isMahalleZorunlumu
     * @return \StructType\KAdres
     */
    public function setIsMahalleZorunlumu($isMahalleZorunlumu = null)
    {
        // validation for constraint: boolean
        if (!is_null($isMahalleZorunlumu) && !is_bool($isMahalleZorunlumu)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isMahalleZorunlumu, true), gettype($isMahalleZorunlumu)), __LINE__);
        }
        $this->IsMahalleZorunlumu = $isMahalleZorunlumu;
        return $this;
    }
    /**
     * Get IsSemtZorunlumu value
     * @return bool
     */
    public function getIsSemtZorunlumu()
    {
        return $this->IsSemtZorunlumu;
    }
    /**
     * Set IsSemtZorunlumu value
     * @param bool $isSemtZorunlumu
     * @return \StructType\KAdres
     */
    public function setIsSemtZorunlumu($isSemtZorunlumu = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSemtZorunlumu) && !is_bool($isSemtZorunlumu)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isSemtZorunlumu, true), gettype($isSemtZorunlumu)), __LINE__);
        }
        $this->IsSemtZorunlumu = $isSemtZorunlumu;
        return $this;
    }
    /**
     * Get IL_ID value
     * @return int
     */
    public function getIL_ID()
    {
        return $this->IL_ID;
    }
    /**
     * Set IL_ID value
     * @param int $iL_ID
     * @return \StructType\KAdres
     */
    public function setIL_ID($iL_ID = null)
    {
        // validation for constraint: int
        if (!is_null($iL_ID) && !(is_int($iL_ID) || ctype_digit($iL_ID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($iL_ID, true), gettype($iL_ID)), __LINE__);
        }
        $this->IL_ID = $iL_ID;
        return $this;
    }
    /**
     * Get ILCE_ID value
     * @return int
     */
    public function getILCE_ID()
    {
        return $this->ILCE_ID;
    }
    /**
     * Set ILCE_ID value
     * @param int $iLCE_ID
     * @return \StructType\KAdres
     */
    public function setILCE_ID($iLCE_ID = null)
    {
        // validation for constraint: int
        if (!is_null($iLCE_ID) && !(is_int($iLCE_ID) || ctype_digit($iLCE_ID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($iLCE_ID, true), gettype($iLCE_ID)), __LINE__);
        }
        $this->ILCE_ID = $iLCE_ID;
        return $this;
    }
    /**
     * Get DagitimSubesi_ObjId value
     * @return int
     */
    public function getDagitimSubesi_ObjId()
    {
        return $this->DagitimSubesi_ObjId;
    }
    /**
     * Set DagitimSubesi_ObjId value
     * @param int $dagitimSubesi_ObjId
     * @return \StructType\KAdres
     */
    public function setDagitimSubesi_ObjId($dagitimSubesi_ObjId = null)
    {
        // validation for constraint: int
        if (!is_null($dagitimSubesi_ObjId) && !(is_int($dagitimSubesi_ObjId) || ctype_digit($dagitimSubesi_ObjId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($dagitimSubesi_ObjId, true), gettype($dagitimSubesi_ObjId)), __LINE__);
        }
        $this->DagitimSubesi_ObjId = $dagitimSubesi_ObjId;
        return $this;
    }
    /**
     * Get Nokta value
     * @return \StructType\KInterlandPointer|null
     */
    public function getNokta()
    {
        return $this->Nokta;
    }
    /**
     * Set Nokta value
     * @param \StructType\KInterlandPointer $nokta
     * @return \StructType\KAdres
     */
    public function setNokta(\StructType\KInterlandPointer $nokta = null)
    {
        $this->Nokta = $nokta;
        return $this;
    }
    /**
     * Get NoktaAdi value
     * @return string|null
     */
    public function getNoktaAdi()
    {
        return $this->NoktaAdi;
    }
    /**
     * Set NoktaAdi value
     * @param string $noktaAdi
     * @return \StructType\KAdres
     */
    public function setNoktaAdi($noktaAdi = null)
    {
        // validation for constraint: string
        if (!is_null($noktaAdi) && !is_string($noktaAdi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($noktaAdi, true), gettype($noktaAdi)), __LINE__);
        }
        $this->NoktaAdi = $noktaAdi;
        return $this;
    }
    /**
     * Get Site value
     * @return \StructType\KInterlandPointer|null
     */
    public function getSite()
    {
        return $this->Site;
    }
    /**
     * Set Site value
     * @param \StructType\KInterlandPointer $site
     * @return \StructType\KAdres
     */
    public function setSite(\StructType\KInterlandPointer $site = null)
    {
        $this->Site = $site;
        return $this;
    }
    /**
     * Get SiteAdi value
     * @return string|null
     */
    public function getSiteAdi()
    {
        return $this->SiteAdi;
    }
    /**
     * Set SiteAdi value
     * @param string $siteAdi
     * @return \StructType\KAdres
     */
    public function setSiteAdi($siteAdi = null)
    {
        // validation for constraint: string
        if (!is_null($siteAdi) && !is_string($siteAdi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($siteAdi, true), gettype($siteAdi)), __LINE__);
        }
        $this->SiteAdi = $siteAdi;
        return $this;
    }
    /**
     * Get Sokak value
     * @return \StructType\KInterlandPointer|null
     */
    public function getSokak()
    {
        return $this->Sokak;
    }
    /**
     * Set Sokak value
     * @param \StructType\KInterlandPointer $sokak
     * @return \StructType\KAdres
     */
    public function setSokak(\StructType\KInterlandPointer $sokak = null)
    {
        $this->Sokak = $sokak;
        return $this;
    }
    /**
     * Get SokakAdi value
     * @return string|null
     */
    public function getSokakAdi()
    {
        return $this->SokakAdi;
    }
    /**
     * Set SokakAdi value
     * @param string $sokakAdi
     * @return \StructType\KAdres
     */
    public function setSokakAdi($sokakAdi = null)
    {
        // validation for constraint: string
        if (!is_null($sokakAdi) && !is_string($sokakAdi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sokakAdi, true), gettype($sokakAdi)), __LINE__);
        }
        $this->SokakAdi = $sokakAdi;
        return $this;
    }
    /**
     * Get Cadde value
     * @return \StructType\KInterlandPointer|null
     */
    public function getCadde()
    {
        return $this->Cadde;
    }
    /**
     * Set Cadde value
     * @param \StructType\KInterlandPointer $cadde
     * @return \StructType\KAdres
     */
    public function setCadde(\StructType\KInterlandPointer $cadde = null)
    {
        $this->Cadde = $cadde;
        return $this;
    }
    /**
     * Get CaddeAdi value
     * @return string|null
     */
    public function getCaddeAdi()
    {
        return $this->CaddeAdi;
    }
    /**
     * Set CaddeAdi value
     * @param string $caddeAdi
     * @return \StructType\KAdres
     */
    public function setCaddeAdi($caddeAdi = null)
    {
        // validation for constraint: string
        if (!is_null($caddeAdi) && !is_string($caddeAdi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($caddeAdi, true), gettype($caddeAdi)), __LINE__);
        }
        $this->CaddeAdi = $caddeAdi;
        return $this;
    }
    /**
     * Get Semt value
     * @return \StructType\KInterlandPointer|null
     */
    public function getSemt()
    {
        return $this->Semt;
    }
    /**
     * Set Semt value
     * @param \StructType\KInterlandPointer $semt
     * @return \StructType\KAdres
     */
    public function setSemt(\StructType\KInterlandPointer $semt = null)
    {
        $this->Semt = $semt;
        return $this;
    }
    /**
     * Get SemtAdi value
     * @return string|null
     */
    public function getSemtAdi()
    {
        return $this->SemtAdi;
    }
    /**
     * Set SemtAdi value
     * @param string $semtAdi
     * @return \StructType\KAdres
     */
    public function setSemtAdi($semtAdi = null)
    {
        // validation for constraint: string
        if (!is_null($semtAdi) && !is_string($semtAdi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($semtAdi, true), gettype($semtAdi)), __LINE__);
        }
        $this->SemtAdi = $semtAdi;
        return $this;
    }
    /**
     * Get Bucak value
     * @return \StructType\KInterlandPointer|null
     */
    public function getBucak()
    {
        return $this->Bucak;
    }
    /**
     * Set Bucak value
     * @param \StructType\KInterlandPointer $bucak
     * @return \StructType\KAdres
     */
    public function setBucak(\StructType\KInterlandPointer $bucak = null)
    {
        $this->Bucak = $bucak;
        return $this;
    }
    /**
     * Get BucakAdi value
     * @return string|null
     */
    public function getBucakAdi()
    {
        return $this->BucakAdi;
    }
    /**
     * Set BucakAdi value
     * @param string $bucakAdi
     * @return \StructType\KAdres
     */
    public function setBucakAdi($bucakAdi = null)
    {
        // validation for constraint: string
        if (!is_null($bucakAdi) && !is_string($bucakAdi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bucakAdi, true), gettype($bucakAdi)), __LINE__);
        }
        $this->BucakAdi = $bucakAdi;
        return $this;
    }
    /**
     * Get Mahalle value
     * @return \StructType\KInterlandPointer|null
     */
    public function getMahalle()
    {
        return $this->Mahalle;
    }
    /**
     * Set Mahalle value
     * @param \StructType\KInterlandPointer $mahalle
     * @return \StructType\KAdres
     */
    public function setMahalle(\StructType\KInterlandPointer $mahalle = null)
    {
        $this->Mahalle = $mahalle;
        return $this;
    }
    /**
     * Get MahalleAdi value
     * @return string|null
     */
    public function getMahalleAdi()
    {
        return $this->MahalleAdi;
    }
    /**
     * Set MahalleAdi value
     * @param string $mahalleAdi
     * @return \StructType\KAdres
     */
    public function setMahalleAdi($mahalleAdi = null)
    {
        // validation for constraint: string
        if (!is_null($mahalleAdi) && !is_string($mahalleAdi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mahalleAdi, true), gettype($mahalleAdi)), __LINE__);
        }
        $this->MahalleAdi = $mahalleAdi;
        return $this;
    }
    /**
     * Get Koy value
     * @return \StructType\KInterlandPointer|null
     */
    public function getKoy()
    {
        return $this->Koy;
    }
    /**
     * Set Koy value
     * @param \StructType\KInterlandPointer $koy
     * @return \StructType\KAdres
     */
    public function setKoy(\StructType\KInterlandPointer $koy = null)
    {
        $this->Koy = $koy;
        return $this;
    }
    /**
     * Get KoyAdi value
     * @return string|null
     */
    public function getKoyAdi()
    {
        return $this->KoyAdi;
    }
    /**
     * Set KoyAdi value
     * @param string $koyAdi
     * @return \StructType\KAdres
     */
    public function setKoyAdi($koyAdi = null)
    {
        // validation for constraint: string
        if (!is_null($koyAdi) && !is_string($koyAdi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($koyAdi, true), gettype($koyAdi)), __LINE__);
        }
        $this->KoyAdi = $koyAdi;
        return $this;
    }
    /**
     * Get Ilcesi value
     * @return \StructType\KInterlandPointer|null
     */
    public function getIlcesi()
    {
        return $this->Ilcesi;
    }
    /**
     * Set Ilcesi value
     * @param \StructType\KInterlandPointer $ilcesi
     * @return \StructType\KAdres
     */
    public function setIlcesi(\StructType\KInterlandPointer $ilcesi = null)
    {
        $this->Ilcesi = $ilcesi;
        return $this;
    }
    /**
     * Get IlceAdi value
     * @return string|null
     */
    public function getIlceAdi()
    {
        return $this->IlceAdi;
    }
    /**
     * Set IlceAdi value
     * @param string $ilceAdi
     * @return \StructType\KAdres
     */
    public function setIlceAdi($ilceAdi = null)
    {
        // validation for constraint: string
        if (!is_null($ilceAdi) && !is_string($ilceAdi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ilceAdi, true), gettype($ilceAdi)), __LINE__);
        }
        $this->IlceAdi = $ilceAdi;
        return $this;
    }
    /**
     * Get Ili value
     * @return \StructType\KInterlandPointer|null
     */
    public function getIli()
    {
        return $this->Ili;
    }
    /**
     * Set Ili value
     * @param \StructType\KInterlandPointer $ili
     * @return \StructType\KAdres
     */
    public function setIli(\StructType\KInterlandPointer $ili = null)
    {
        $this->Ili = $ili;
        return $this;
    }
    /**
     * Get IlAdi value
     * @return string|null
     */
    public function getIlAdi()
    {
        return $this->IlAdi;
    }
    /**
     * Set IlAdi value
     * @param string $ilAdi
     * @return \StructType\KAdres
     */
    public function setIlAdi($ilAdi = null)
    {
        // validation for constraint: string
        if (!is_null($ilAdi) && !is_string($ilAdi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ilAdi, true), gettype($ilAdi)), __LINE__);
        }
        $this->IlAdi = $ilAdi;
        return $this;
    }
    /**
     * Get Ulkesi value
     * @return \StructType\KInterlandPointer|null
     */
    public function getUlkesi()
    {
        return $this->Ulkesi;
    }
    /**
     * Set Ulkesi value
     * @param \StructType\KInterlandPointer $ulkesi
     * @return \StructType\KAdres
     */
    public function setUlkesi(\StructType\KInterlandPointer $ulkesi = null)
    {
        $this->Ulkesi = $ulkesi;
        return $this;
    }
    /**
     * Get UlkeAdi value
     * @return string|null
     */
    public function getUlkeAdi()
    {
        return $this->UlkeAdi;
    }
    /**
     * Set UlkeAdi value
     * @param string $ulkeAdi
     * @return \StructType\KAdres
     */
    public function setUlkeAdi($ulkeAdi = null)
    {
        // validation for constraint: string
        if (!is_null($ulkeAdi) && !is_string($ulkeAdi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ulkeAdi, true), gettype($ulkeAdi)), __LINE__);
        }
        $this->UlkeAdi = $ulkeAdi;
        return $this;
    }
    /**
     * Get UlkeBolgesi value
     * @return \StructType\KInterlandPointer|null
     */
    public function getUlkeBolgesi()
    {
        return $this->UlkeBolgesi;
    }
    /**
     * Set UlkeBolgesi value
     * @param \StructType\KInterlandPointer $ulkeBolgesi
     * @return \StructType\KAdres
     */
    public function setUlkeBolgesi(\StructType\KInterlandPointer $ulkeBolgesi = null)
    {
        $this->UlkeBolgesi = $ulkeBolgesi;
        return $this;
    }
    /**
     * Get UlkeBolgeAdi value
     * @return string|null
     */
    public function getUlkeBolgeAdi()
    {
        return $this->UlkeBolgeAdi;
    }
    /**
     * Set UlkeBolgeAdi value
     * @param string $ulkeBolgeAdi
     * @return \StructType\KAdres
     */
    public function setUlkeBolgeAdi($ulkeBolgeAdi = null)
    {
        // validation for constraint: string
        if (!is_null($ulkeBolgeAdi) && !is_string($ulkeBolgeAdi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ulkeBolgeAdi, true), gettype($ulkeBolgeAdi)), __LINE__);
        }
        $this->UlkeBolgeAdi = $ulkeBolgeAdi;
        return $this;
    }
    /**
     * Get KapiNo value
     * @return string|null
     */
    public function getKapiNo()
    {
        return $this->KapiNo;
    }
    /**
     * Set KapiNo value
     * @param string $kapiNo
     * @return \StructType\KAdres
     */
    public function setKapiNo($kapiNo = null)
    {
        // validation for constraint: string
        if (!is_null($kapiNo) && !is_string($kapiNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kapiNo, true), gettype($kapiNo)), __LINE__);
        }
        $this->KapiNo = $kapiNo;
        return $this;
    }
    /**
     * Get HaneNo value
     * @return string|null
     */
    public function getHaneNo()
    {
        return $this->HaneNo;
    }
    /**
     * Set HaneNo value
     * @param string $haneNo
     * @return \StructType\KAdres
     */
    public function setHaneNo($haneNo = null)
    {
        // validation for constraint: string
        if (!is_null($haneNo) && !is_string($haneNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($haneNo, true), gettype($haneNo)), __LINE__);
        }
        $this->HaneNo = $haneNo;
        return $this;
    }
    /**
     * Get Blok value
     * @return string|null
     */
    public function getBlok()
    {
        return $this->Blok;
    }
    /**
     * Set Blok value
     * @param string $blok
     * @return \StructType\KAdres
     */
    public function setBlok($blok = null)
    {
        // validation for constraint: string
        if (!is_null($blok) && !is_string($blok)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($blok, true), gettype($blok)), __LINE__);
        }
        $this->Blok = $blok;
        return $this;
    }
    /**
     * Get Kat value
     * @return string|null
     */
    public function getKat()
    {
        return $this->Kat;
    }
    /**
     * Set Kat value
     * @param string $kat
     * @return \StructType\KAdres
     */
    public function setKat($kat = null)
    {
        // validation for constraint: string
        if (!is_null($kat) && !is_string($kat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kat, true), gettype($kat)), __LINE__);
        }
        $this->Kat = $kat;
        return $this;
    }
    /**
     * Get AdresSatiri value
     * @return string|null
     */
    public function getAdresSatiri()
    {
        return $this->AdresSatiri;
    }
    /**
     * Set AdresSatiri value
     * @param string $adresSatiri
     * @return \StructType\KAdres
     */
    public function setAdresSatiri($adresSatiri = null)
    {
        // validation for constraint: string
        if (!is_null($adresSatiri) && !is_string($adresSatiri)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($adresSatiri, true), gettype($adresSatiri)), __LINE__);
        }
        $this->AdresSatiri = $adresSatiri;
        return $this;
    }
    /**
     * Get UniqueTextCode value
     * @return string|null
     */
    public function getUniqueTextCode()
    {
        return $this->UniqueTextCode;
    }
    /**
     * Set UniqueTextCode value
     * @param string $uniqueTextCode
     * @return \StructType\KAdres
     */
    public function setUniqueTextCode($uniqueTextCode = null)
    {
        // validation for constraint: string
        if (!is_null($uniqueTextCode) && !is_string($uniqueTextCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uniqueTextCode, true), gettype($uniqueTextCode)), __LINE__);
        }
        $this->UniqueTextCode = $uniqueTextCode;
        return $this;
    }
    /**
     * Get UniqueTextCodeGIS value
     * @return string|null
     */
    public function getUniqueTextCodeGIS()
    {
        return $this->UniqueTextCodeGIS;
    }
    /**
     * Set UniqueTextCodeGIS value
     * @param string $uniqueTextCodeGIS
     * @return \StructType\KAdres
     */
    public function setUniqueTextCodeGIS($uniqueTextCodeGIS = null)
    {
        // validation for constraint: string
        if (!is_null($uniqueTextCodeGIS) && !is_string($uniqueTextCodeGIS)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uniqueTextCodeGIS, true), gettype($uniqueTextCodeGIS)), __LINE__);
        }
        $this->UniqueTextCodeGIS = $uniqueTextCodeGIS;
        return $this;
    }
    /**
     * Get UniqueTextHash value
     * @return string|null
     */
    public function getUniqueTextHash()
    {
        return $this->UniqueTextHash;
    }
    /**
     * Set UniqueTextHash value
     * @param string $uniqueTextHash
     * @return \StructType\KAdres
     */
    public function setUniqueTextHash($uniqueTextHash = null)
    {
        // validation for constraint: string
        if (!is_null($uniqueTextHash) && !is_string($uniqueTextHash)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uniqueTextHash, true), gettype($uniqueTextHash)), __LINE__);
        }
        $this->UniqueTextHash = $uniqueTextHash;
        return $this;
    }
    /**
     * Get ToText value
     * @return string|null
     */
    public function getToText()
    {
        return $this->ToText;
    }
    /**
     * Set ToText value
     * @param string $toText
     * @return \StructType\KAdres
     */
    public function setToText($toText = null)
    {
        // validation for constraint: string
        if (!is_null($toText) && !is_string($toText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($toText, true), gettype($toText)), __LINE__);
        }
        $this->ToText = $toText;
        return $this;
    }
    /**
     * Get IL_ADI value
     * @return string|null
     */
    public function getIL_ADI()
    {
        return $this->IL_ADI;
    }
    /**
     * Set IL_ADI value
     * @param string $iL_ADI
     * @return \StructType\KAdres
     */
    public function setIL_ADI($iL_ADI = null)
    {
        // validation for constraint: string
        if (!is_null($iL_ADI) && !is_string($iL_ADI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iL_ADI, true), gettype($iL_ADI)), __LINE__);
        }
        $this->IL_ADI = $iL_ADI;
        return $this;
    }
    /**
     * Get ILCE_ADI value
     * @return string|null
     */
    public function getILCE_ADI()
    {
        return $this->ILCE_ADI;
    }
    /**
     * Set ILCE_ADI value
     * @param string $iLCE_ADI
     * @return \StructType\KAdres
     */
    public function setILCE_ADI($iLCE_ADI = null)
    {
        // validation for constraint: string
        if (!is_null($iLCE_ADI) && !is_string($iLCE_ADI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iLCE_ADI, true), gettype($iLCE_ADI)), __LINE__);
        }
        $this->ILCE_ADI = $iLCE_ADI;
        return $this;
    }
    /**
     * Get TespitTip value
     * @return string|null
     */
    public function getTespitTip()
    {
        return $this->TespitTip;
    }
    /**
     * Set TespitTip value
     * @param string $tespitTip
     * @return \StructType\KAdres
     */
    public function setTespitTip($tespitTip = null)
    {
        // validation for constraint: string
        if (!is_null($tespitTip) && !is_string($tespitTip)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tespitTip, true), gettype($tespitTip)), __LINE__);
        }
        $this->TespitTip = $tespitTip;
        return $this;
    }
    /**
     * Get XCOOR value
     * @return string|null
     */
    public function getXCOOR()
    {
        return $this->XCOOR;
    }
    /**
     * Set XCOOR value
     * @param string $xCOOR
     * @return \StructType\KAdres
     */
    public function setXCOOR($xCOOR = null)
    {
        // validation for constraint: string
        if (!is_null($xCOOR) && !is_string($xCOOR)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($xCOOR, true), gettype($xCOOR)), __LINE__);
        }
        $this->XCOOR = $xCOOR;
        return $this;
    }
    /**
     * Get YCOOR value
     * @return string|null
     */
    public function getYCOOR()
    {
        return $this->YCOOR;
    }
    /**
     * Set YCOOR value
     * @param string $yCOOR
     * @return \StructType\KAdres
     */
    public function setYCOOR($yCOOR = null)
    {
        // validation for constraint: string
        if (!is_null($yCOOR) && !is_string($yCOOR)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($yCOOR, true), gettype($yCOOR)), __LINE__);
        }
        $this->YCOOR = $yCOOR;
        return $this;
    }
    /**
     * Get DagitimSubesi value
     * @return string|null
     */
    public function getDagitimSubesi()
    {
        return $this->DagitimSubesi;
    }
    /**
     * Set DagitimSubesi value
     * @param string $dagitimSubesi
     * @return \StructType\KAdres
     */
    public function setDagitimSubesi($dagitimSubesi = null)
    {
        // validation for constraint: string
        if (!is_null($dagitimSubesi) && !is_string($dagitimSubesi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dagitimSubesi, true), gettype($dagitimSubesi)), __LINE__);
        }
        $this->DagitimSubesi = $dagitimSubesi;
        return $this;
    }
    /**
     * Get PostaKodu value
     * @return string|null
     */
    public function getPostaKodu()
    {
        return $this->PostaKodu;
    }
    /**
     * Set PostaKodu value
     * @param string $postaKodu
     * @return \StructType\KAdres
     */
    public function setPostaKodu($postaKodu = null)
    {
        // validation for constraint: string
        if (!is_null($postaKodu) && !is_string($postaKodu)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postaKodu, true), gettype($postaKodu)), __LINE__);
        }
        $this->PostaKodu = $postaKodu;
        return $this;
    }
    /**
     * Get FreeText value
     * @return string|null
     */
    public function getFreeText()
    {
        return $this->FreeText;
    }
    /**
     * Set FreeText value
     * @param string $freeText
     * @return \StructType\KAdres
     */
    public function setFreeText($freeText = null)
    {
        // validation for constraint: string
        if (!is_null($freeText) && !is_string($freeText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($freeText, true), gettype($freeText)), __LINE__);
        }
        $this->FreeText = $freeText;
        return $this;
    }
}
