<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EvrakBase StructType
 * @subpackage Structs
 */
abstract class EvrakBase extends SerendipEvrakBase
{
    /**
     * The EvrakNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EvrakNo;
    /**
     * The Turu
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\EvrakTuruPointer
     */
    public $Turu;
    /**
     * The EvrakBolumu
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\BolumPointer
     */
    public $EvrakBolumu;
    /**
     * The EvrakIsYeri
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IsYeriPointer
     */
    public $EvrakIsYeri;
    /**
     * The EvrakGrubu
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\NesneGrubu
     */
    public $EvrakGrubu;
    /**
     * The Aciklama
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Aciklama;
    /**
     * Constructor method for EvrakBase
     * @uses EvrakBase::setEvrakNo()
     * @uses EvrakBase::setTuru()
     * @uses EvrakBase::setEvrakBolumu()
     * @uses EvrakBase::setEvrakIsYeri()
     * @uses EvrakBase::setEvrakGrubu()
     * @uses EvrakBase::setAciklama()
     * @param string $evrakNo
     * @param \StructType\EvrakTuruPointer $turu
     * @param \StructType\BolumPointer $evrakBolumu
     * @param \StructType\IsYeriPointer $evrakIsYeri
     * @param \StructType\NesneGrubu $evrakGrubu
     * @param string $aciklama
     */
    public function __construct($evrakNo = null, \StructType\EvrakTuruPointer $turu = null, \StructType\BolumPointer $evrakBolumu = null, \StructType\IsYeriPointer $evrakIsYeri = null, \StructType\NesneGrubu $evrakGrubu = null, $aciklama = null)
    {
        $this
            ->setEvrakNo($evrakNo)
            ->setTuru($turu)
            ->setEvrakBolumu($evrakBolumu)
            ->setEvrakIsYeri($evrakIsYeri)
            ->setEvrakGrubu($evrakGrubu)
            ->setAciklama($aciklama);
    }
    /**
     * Get EvrakNo value
     * @return string|null
     */
    public function getEvrakNo()
    {
        return $this->EvrakNo;
    }
    /**
     * Set EvrakNo value
     * @param string $evrakNo
     * @return \StructType\EvrakBase
     */
    public function setEvrakNo($evrakNo = null)
    {
        // validation for constraint: string
        if (!is_null($evrakNo) && !is_string($evrakNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($evrakNo, true), gettype($evrakNo)), __LINE__);
        }
        $this->EvrakNo = $evrakNo;
        return $this;
    }
    /**
     * Get Turu value
     * @return \StructType\EvrakTuruPointer|null
     */
    public function getTuru()
    {
        return $this->Turu;
    }
    /**
     * Set Turu value
     * @param \StructType\EvrakTuruPointer $turu
     * @return \StructType\EvrakBase
     */
    public function setTuru(\StructType\EvrakTuruPointer $turu = null)
    {
        $this->Turu = $turu;
        return $this;
    }
    /**
     * Get EvrakBolumu value
     * @return \StructType\BolumPointer|null
     */
    public function getEvrakBolumu()
    {
        return $this->EvrakBolumu;
    }
    /**
     * Set EvrakBolumu value
     * @param \StructType\BolumPointer $evrakBolumu
     * @return \StructType\EvrakBase
     */
    public function setEvrakBolumu(\StructType\BolumPointer $evrakBolumu = null)
    {
        $this->EvrakBolumu = $evrakBolumu;
        return $this;
    }
    /**
     * Get EvrakIsYeri value
     * @return \StructType\IsYeriPointer|null
     */
    public function getEvrakIsYeri()
    {
        return $this->EvrakIsYeri;
    }
    /**
     * Set EvrakIsYeri value
     * @param \StructType\IsYeriPointer $evrakIsYeri
     * @return \StructType\EvrakBase
     */
    public function setEvrakIsYeri(\StructType\IsYeriPointer $evrakIsYeri = null)
    {
        $this->EvrakIsYeri = $evrakIsYeri;
        return $this;
    }
    /**
     * Get EvrakGrubu value
     * @return \StructType\NesneGrubu|null
     */
    public function getEvrakGrubu()
    {
        return $this->EvrakGrubu;
    }
    /**
     * Set EvrakGrubu value
     * @param \StructType\NesneGrubu $evrakGrubu
     * @return \StructType\EvrakBase
     */
    public function setEvrakGrubu(\StructType\NesneGrubu $evrakGrubu = null)
    {
        $this->EvrakGrubu = $evrakGrubu;
        return $this;
    }
    /**
     * Get Aciklama value
     * @return string|null
     */
    public function getAciklama()
    {
        return $this->Aciklama;
    }
    /**
     * Set Aciklama value
     * @param string $aciklama
     * @return \StructType\EvrakBase
     */
    public function setAciklama($aciklama = null)
    {
        // validation for constraint: string
        if (!is_null($aciklama) && !is_string($aciklama)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aciklama, true), gettype($aciklama)), __LINE__);
        }
        $this->Aciklama = $aciklama;
        return $this;
    }
}
