<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Evrak StructType
 * @subpackage Structs
 */
abstract class Evrak extends EvrakBase
{
    /**
     * The FaaliyetMerkezi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\FaaliyetMerkeziPointer
     */
    public $FaaliyetMerkezi;
    /**
     * The MaliyetHavuzu
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\FaaliyetMerkeziMaliyetHavuzuPointer
     */
    public $MaliyetHavuzu;
    /**
     * The DagitimAnahtari
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\FaaliyetMerkeziDagitimAnahtariPointer
     */
    public $DagitimAnahtari;
    /**
     * The ToplamTutar
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\DovizliTutar
     */
    public $ToplamTutar;
    /**
     * Constructor method for Evrak
     * @uses Evrak::setFaaliyetMerkezi()
     * @uses Evrak::setMaliyetHavuzu()
     * @uses Evrak::setDagitimAnahtari()
     * @uses Evrak::setToplamTutar()
     * @param \StructType\FaaliyetMerkeziPointer $faaliyetMerkezi
     * @param \StructType\FaaliyetMerkeziMaliyetHavuzuPointer $maliyetHavuzu
     * @param \StructType\FaaliyetMerkeziDagitimAnahtariPointer $dagitimAnahtari
     * @param \StructType\DovizliTutar $toplamTutar
     */
    public function __construct(\StructType\FaaliyetMerkeziPointer $faaliyetMerkezi = null, \StructType\FaaliyetMerkeziMaliyetHavuzuPointer $maliyetHavuzu = null, \StructType\FaaliyetMerkeziDagitimAnahtariPointer $dagitimAnahtari = null, \StructType\DovizliTutar $toplamTutar = null)
    {
        $this
            ->setFaaliyetMerkezi($faaliyetMerkezi)
            ->setMaliyetHavuzu($maliyetHavuzu)
            ->setDagitimAnahtari($dagitimAnahtari)
            ->setToplamTutar($toplamTutar);
    }
    /**
     * Get FaaliyetMerkezi value
     * @return \StructType\FaaliyetMerkeziPointer|null
     */
    public function getFaaliyetMerkezi()
    {
        return $this->FaaliyetMerkezi;
    }
    /**
     * Set FaaliyetMerkezi value
     * @param \StructType\FaaliyetMerkeziPointer $faaliyetMerkezi
     * @return \StructType\Evrak
     */
    public function setFaaliyetMerkezi(\StructType\FaaliyetMerkeziPointer $faaliyetMerkezi = null)
    {
        $this->FaaliyetMerkezi = $faaliyetMerkezi;
        return $this;
    }
    /**
     * Get MaliyetHavuzu value
     * @return \StructType\FaaliyetMerkeziMaliyetHavuzuPointer|null
     */
    public function getMaliyetHavuzu()
    {
        return $this->MaliyetHavuzu;
    }
    /**
     * Set MaliyetHavuzu value
     * @param \StructType\FaaliyetMerkeziMaliyetHavuzuPointer $maliyetHavuzu
     * @return \StructType\Evrak
     */
    public function setMaliyetHavuzu(\StructType\FaaliyetMerkeziMaliyetHavuzuPointer $maliyetHavuzu = null)
    {
        $this->MaliyetHavuzu = $maliyetHavuzu;
        return $this;
    }
    /**
     * Get DagitimAnahtari value
     * @return \StructType\FaaliyetMerkeziDagitimAnahtariPointer|null
     */
    public function getDagitimAnahtari()
    {
        return $this->DagitimAnahtari;
    }
    /**
     * Set DagitimAnahtari value
     * @param \StructType\FaaliyetMerkeziDagitimAnahtariPointer $dagitimAnahtari
     * @return \StructType\Evrak
     */
    public function setDagitimAnahtari(\StructType\FaaliyetMerkeziDagitimAnahtariPointer $dagitimAnahtari = null)
    {
        $this->DagitimAnahtari = $dagitimAnahtari;
        return $this;
    }
    /**
     * Get ToplamTutar value
     * @return \StructType\DovizliTutar|null
     */
    public function getToplamTutar()
    {
        return $this->ToplamTutar;
    }
    /**
     * Set ToplamTutar value
     * @param \StructType\DovizliTutar $toplamTutar
     * @return \StructType\Evrak
     */
    public function setToplamTutar(\StructType\DovizliTutar $toplamTutar = null)
    {
        $this->ToplamTutar = $toplamTutar;
        return $this;
    }
}
