<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CariFisi StructType
 * @subpackage Structs
 */
class CariFisi extends Evrak
{
    /**
     * The KaynakEvrakObjId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $KaynakEvrakObjId;
    /**
     * The VirmanSebep
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $VirmanSebep;
    /**
     * The CreatedFromOdemeTalebi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $CreatedFromOdemeTalebi;
    /**
     * The ToplamBorc
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\DovizliTutar
     */
    public $ToplamBorc;
    /**
     * The ToplamAlacak
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\DovizliTutar
     */
    public $ToplamAlacak;
    /**
     * The DokumanIzlemeNumarasi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DokumanIzlemeNumarasi;
    /**
     * The Satici
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\SatisElemaniPointer
     */
    public $Satici;
    /**
     * The Satirlar
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfCariFisiSatiri
     */
    public $Satirlar;
    /**
     * The ZKaynakModul
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ZKaynakModul;
    /**
     * Constructor method for CariFisi
     * @uses CariFisi::setKaynakEvrakObjId()
     * @uses CariFisi::setVirmanSebep()
     * @uses CariFisi::setCreatedFromOdemeTalebi()
     * @uses CariFisi::setToplamBorc()
     * @uses CariFisi::setToplamAlacak()
     * @uses CariFisi::setDokumanIzlemeNumarasi()
     * @uses CariFisi::setSatici()
     * @uses CariFisi::setSatirlar()
     * @uses CariFisi::setZKaynakModul()
     * @param int $kaynakEvrakObjId
     * @param string $virmanSebep
     * @param bool $createdFromOdemeTalebi
     * @param \StructType\DovizliTutar $toplamBorc
     * @param \StructType\DovizliTutar $toplamAlacak
     * @param string $dokumanIzlemeNumarasi
     * @param \StructType\SatisElemaniPointer $satici
     * @param \ArrayType\ArrayOfCariFisiSatiri $satirlar
     * @param string $zKaynakModul
     */
    public function __construct($kaynakEvrakObjId = null, $virmanSebep = null, $createdFromOdemeTalebi = null, \StructType\DovizliTutar $toplamBorc = null, \StructType\DovizliTutar $toplamAlacak = null, $dokumanIzlemeNumarasi = null, \StructType\SatisElemaniPointer $satici = null, \ArrayType\ArrayOfCariFisiSatiri $satirlar = null, $zKaynakModul = null)
    {
        $this
            ->setKaynakEvrakObjId($kaynakEvrakObjId)
            ->setVirmanSebep($virmanSebep)
            ->setCreatedFromOdemeTalebi($createdFromOdemeTalebi)
            ->setToplamBorc($toplamBorc)
            ->setToplamAlacak($toplamAlacak)
            ->setDokumanIzlemeNumarasi($dokumanIzlemeNumarasi)
            ->setSatici($satici)
            ->setSatirlar($satirlar)
            ->setZKaynakModul($zKaynakModul);
    }
    /**
     * Get KaynakEvrakObjId value
     * @return int
     */
    public function getKaynakEvrakObjId()
    {
        return $this->KaynakEvrakObjId;
    }
    /**
     * Set KaynakEvrakObjId value
     * @param int $kaynakEvrakObjId
     * @return \StructType\CariFisi
     */
    public function setKaynakEvrakObjId($kaynakEvrakObjId = null)
    {
        // validation for constraint: int
        if (!is_null($kaynakEvrakObjId) && !(is_int($kaynakEvrakObjId) || ctype_digit($kaynakEvrakObjId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($kaynakEvrakObjId, true), gettype($kaynakEvrakObjId)), __LINE__);
        }
        $this->KaynakEvrakObjId = $kaynakEvrakObjId;
        return $this;
    }
    /**
     * Get VirmanSebep value
     * @return string
     */
    public function getVirmanSebep()
    {
        return $this->VirmanSebep;
    }
    /**
     * Set VirmanSebep value
     * @uses \EnumType\VirmanSebep::valueIsValid()
     * @uses \EnumType\VirmanSebep::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $virmanSebep
     * @return \StructType\CariFisi
     */
    public function setVirmanSebep($virmanSebep = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\VirmanSebep::valueIsValid($virmanSebep)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\VirmanSebep', is_array($virmanSebep) ? implode(', ', $virmanSebep) : var_export($virmanSebep, true), implode(', ', \EnumType\VirmanSebep::getValidValues())), __LINE__);
        }
        $this->VirmanSebep = $virmanSebep;
        return $this;
    }
    /**
     * Get CreatedFromOdemeTalebi value
     * @return bool
     */
    public function getCreatedFromOdemeTalebi()
    {
        return $this->CreatedFromOdemeTalebi;
    }
    /**
     * Set CreatedFromOdemeTalebi value
     * @param bool $createdFromOdemeTalebi
     * @return \StructType\CariFisi
     */
    public function setCreatedFromOdemeTalebi($createdFromOdemeTalebi = null)
    {
        // validation for constraint: boolean
        if (!is_null($createdFromOdemeTalebi) && !is_bool($createdFromOdemeTalebi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($createdFromOdemeTalebi, true), gettype($createdFromOdemeTalebi)), __LINE__);
        }
        $this->CreatedFromOdemeTalebi = $createdFromOdemeTalebi;
        return $this;
    }
    /**
     * Get ToplamBorc value
     * @return \StructType\DovizliTutar|null
     */
    public function getToplamBorc()
    {
        return $this->ToplamBorc;
    }
    /**
     * Set ToplamBorc value
     * @param \StructType\DovizliTutar $toplamBorc
     * @return \StructType\CariFisi
     */
    public function setToplamBorc(\StructType\DovizliTutar $toplamBorc = null)
    {
        $this->ToplamBorc = $toplamBorc;
        return $this;
    }
    /**
     * Get ToplamAlacak value
     * @return \StructType\DovizliTutar|null
     */
    public function getToplamAlacak()
    {
        return $this->ToplamAlacak;
    }
    /**
     * Set ToplamAlacak value
     * @param \StructType\DovizliTutar $toplamAlacak
     * @return \StructType\CariFisi
     */
    public function setToplamAlacak(\StructType\DovizliTutar $toplamAlacak = null)
    {
        $this->ToplamAlacak = $toplamAlacak;
        return $this;
    }
    /**
     * Get DokumanIzlemeNumarasi value
     * @return string|null
     */
    public function getDokumanIzlemeNumarasi()
    {
        return $this->DokumanIzlemeNumarasi;
    }
    /**
     * Set DokumanIzlemeNumarasi value
     * @param string $dokumanIzlemeNumarasi
     * @return \StructType\CariFisi
     */
    public function setDokumanIzlemeNumarasi($dokumanIzlemeNumarasi = null)
    {
        // validation for constraint: string
        if (!is_null($dokumanIzlemeNumarasi) && !is_string($dokumanIzlemeNumarasi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dokumanIzlemeNumarasi, true), gettype($dokumanIzlemeNumarasi)), __LINE__);
        }
        $this->DokumanIzlemeNumarasi = $dokumanIzlemeNumarasi;
        return $this;
    }
    /**
     * Get Satici value
     * @return \StructType\SatisElemaniPointer|null
     */
    public function getSatici()
    {
        return $this->Satici;
    }
    /**
     * Set Satici value
     * @param \StructType\SatisElemaniPointer $satici
     * @return \StructType\CariFisi
     */
    public function setSatici(\StructType\SatisElemaniPointer $satici = null)
    {
        $this->Satici = $satici;
        return $this;
    }
    /**
     * Get Satirlar value
     * @return \ArrayType\ArrayOfCariFisiSatiri|null
     */
    public function getSatirlar()
    {
        return $this->Satirlar;
    }
    /**
     * Set Satirlar value
     * @param \ArrayType\ArrayOfCariFisiSatiri $satirlar
     * @return \StructType\CariFisi
     */
    public function setSatirlar(\ArrayType\ArrayOfCariFisiSatiri $satirlar = null)
    {
        $this->Satirlar = $satirlar;
        return $this;
    }
    /**
     * Get ZKaynakModul value
     * @return string|null
     */
    public function getZKaynakModul()
    {
        return $this->ZKaynakModul;
    }
    /**
     * Set ZKaynakModul value
     * @param string $zKaynakModul
     * @return \StructType\CariFisi
     */
    public function setZKaynakModul($zKaynakModul = null)
    {
        // validation for constraint: string
        if (!is_null($zKaynakModul) && !is_string($zKaynakModul)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($zKaynakModul, true), gettype($zKaynakModul)), __LINE__);
        }
        $this->ZKaynakModul = $zKaynakModul;
        return $this;
    }
}
