<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RiskKontrol StructType
 * @subpackage Structs
 */
class RiskKontrol extends SerendipEntity
{
    /**
     * The RiskTakipDovizi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $RiskTakipDovizi;
    /**
     * The CekCarpani
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $CekCarpani;
    /**
     * The SenetCarpani
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $SenetCarpani;
    /**
     * The SiparisCarpani
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $SiparisCarpani;
    /**
     * The BorcRiskLimiti
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $BorcRiskLimiti;
    /**
     * The AlacakRiskLimiti
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $AlacakRiskLimiti;
    /**
     * The Adi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Adi;
    /**
     * The Aciklama
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Aciklama;
    /**
     * Constructor method for RiskKontrol
     * @uses RiskKontrol::setRiskTakipDovizi()
     * @uses RiskKontrol::setCekCarpani()
     * @uses RiskKontrol::setSenetCarpani()
     * @uses RiskKontrol::setSiparisCarpani()
     * @uses RiskKontrol::setBorcRiskLimiti()
     * @uses RiskKontrol::setAlacakRiskLimiti()
     * @uses RiskKontrol::setAdi()
     * @uses RiskKontrol::setAciklama()
     * @param string $riskTakipDovizi
     * @param float $cekCarpani
     * @param float $senetCarpani
     * @param float $siparisCarpani
     * @param float $borcRiskLimiti
     * @param float $alacakRiskLimiti
     * @param string $adi
     * @param string $aciklama
     */
    public function __construct($riskTakipDovizi = null, $cekCarpani = null, $senetCarpani = null, $siparisCarpani = null, $borcRiskLimiti = null, $alacakRiskLimiti = null, $adi = null, $aciklama = null)
    {
        $this
            ->setRiskTakipDovizi($riskTakipDovizi)
            ->setCekCarpani($cekCarpani)
            ->setSenetCarpani($senetCarpani)
            ->setSiparisCarpani($siparisCarpani)
            ->setBorcRiskLimiti($borcRiskLimiti)
            ->setAlacakRiskLimiti($alacakRiskLimiti)
            ->setAdi($adi)
            ->setAciklama($aciklama);
    }
    /**
     * Get RiskTakipDovizi value
     * @return string
     */
    public function getRiskTakipDovizi()
    {
        return $this->RiskTakipDovizi;
    }
    /**
     * Set RiskTakipDovizi value
     * @uses \EnumType\RiskDovizTipi::valueIsValid()
     * @uses \EnumType\RiskDovizTipi::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $riskTakipDovizi
     * @return \StructType\RiskKontrol
     */
    public function setRiskTakipDovizi($riskTakipDovizi = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\RiskDovizTipi::valueIsValid($riskTakipDovizi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\RiskDovizTipi', is_array($riskTakipDovizi) ? implode(', ', $riskTakipDovizi) : var_export($riskTakipDovizi, true), implode(', ', \EnumType\RiskDovizTipi::getValidValues())), __LINE__);
        }
        $this->RiskTakipDovizi = $riskTakipDovizi;
        return $this;
    }
    /**
     * Get CekCarpani value
     * @return float
     */
    public function getCekCarpani()
    {
        return $this->CekCarpani;
    }
    /**
     * Set CekCarpani value
     * @param float $cekCarpani
     * @return \StructType\RiskKontrol
     */
    public function setCekCarpani($cekCarpani = null)
    {
        // validation for constraint: float
        if (!is_null($cekCarpani) && !(is_float($cekCarpani) || is_numeric($cekCarpani))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($cekCarpani, true), gettype($cekCarpani)), __LINE__);
        }
        $this->CekCarpani = $cekCarpani;
        return $this;
    }
    /**
     * Get SenetCarpani value
     * @return float
     */
    public function getSenetCarpani()
    {
        return $this->SenetCarpani;
    }
    /**
     * Set SenetCarpani value
     * @param float $senetCarpani
     * @return \StructType\RiskKontrol
     */
    public function setSenetCarpani($senetCarpani = null)
    {
        // validation for constraint: float
        if (!is_null($senetCarpani) && !(is_float($senetCarpani) || is_numeric($senetCarpani))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($senetCarpani, true), gettype($senetCarpani)), __LINE__);
        }
        $this->SenetCarpani = $senetCarpani;
        return $this;
    }
    /**
     * Get SiparisCarpani value
     * @return float
     */
    public function getSiparisCarpani()
    {
        return $this->SiparisCarpani;
    }
    /**
     * Set SiparisCarpani value
     * @param float $siparisCarpani
     * @return \StructType\RiskKontrol
     */
    public function setSiparisCarpani($siparisCarpani = null)
    {
        // validation for constraint: float
        if (!is_null($siparisCarpani) && !(is_float($siparisCarpani) || is_numeric($siparisCarpani))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($siparisCarpani, true), gettype($siparisCarpani)), __LINE__);
        }
        $this->SiparisCarpani = $siparisCarpani;
        return $this;
    }
    /**
     * Get BorcRiskLimiti value
     * @return float
     */
    public function getBorcRiskLimiti()
    {
        return $this->BorcRiskLimiti;
    }
    /**
     * Set BorcRiskLimiti value
     * @param float $borcRiskLimiti
     * @return \StructType\RiskKontrol
     */
    public function setBorcRiskLimiti($borcRiskLimiti = null)
    {
        // validation for constraint: float
        if (!is_null($borcRiskLimiti) && !(is_float($borcRiskLimiti) || is_numeric($borcRiskLimiti))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($borcRiskLimiti, true), gettype($borcRiskLimiti)), __LINE__);
        }
        $this->BorcRiskLimiti = $borcRiskLimiti;
        return $this;
    }
    /**
     * Get AlacakRiskLimiti value
     * @return float
     */
    public function getAlacakRiskLimiti()
    {
        return $this->AlacakRiskLimiti;
    }
    /**
     * Set AlacakRiskLimiti value
     * @param float $alacakRiskLimiti
     * @return \StructType\RiskKontrol
     */
    public function setAlacakRiskLimiti($alacakRiskLimiti = null)
    {
        // validation for constraint: float
        if (!is_null($alacakRiskLimiti) && !(is_float($alacakRiskLimiti) || is_numeric($alacakRiskLimiti))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($alacakRiskLimiti, true), gettype($alacakRiskLimiti)), __LINE__);
        }
        $this->AlacakRiskLimiti = $alacakRiskLimiti;
        return $this;
    }
    /**
     * Get Adi value
     * @return string|null
     */
    public function getAdi()
    {
        return $this->Adi;
    }
    /**
     * Set Adi value
     * @param string $adi
     * @return \StructType\RiskKontrol
     */
    public function setAdi($adi = null)
    {
        // validation for constraint: string
        if (!is_null($adi) && !is_string($adi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($adi, true), gettype($adi)), __LINE__);
        }
        $this->Adi = $adi;
        return $this;
    }
    /**
     * Get Aciklama value
     * @return string|null
     */
    public function getAciklama()
    {
        return $this->Aciklama;
    }
    /**
     * Set Aciklama value
     * @param string $aciklama
     * @return \StructType\RiskKontrol
     */
    public function setAciklama($aciklama = null)
    {
        // validation for constraint: string
        if (!is_null($aciklama) && !is_string($aciklama)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aciklama, true), gettype($aciklama)), __LINE__);
        }
        $this->Aciklama = $aciklama;
        return $this;
    }
}
