<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DovizliTutar StructType
 * @subpackage Structs
 */
class DovizliTutar extends ValueEntity
{
    /**
     * The RaporDoviziTutari
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $RaporDoviziTutari;
    /**
     * The YerelTutar
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $YerelTutar;
    /**
     * The IslemDoviziTutari
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $IslemDoviziTutari;
    /**
     * The IslemDovizTuru
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\DovizTuruPointer
     */
    public $IslemDovizTuru;
    /**
     * Constructor method for DovizliTutar
     * @uses DovizliTutar::setRaporDoviziTutari()
     * @uses DovizliTutar::setYerelTutar()
     * @uses DovizliTutar::setIslemDoviziTutari()
     * @uses DovizliTutar::setIslemDovizTuru()
     * @param float $raporDoviziTutari
     * @param float $yerelTutar
     * @param float $islemDoviziTutari
     * @param \StructType\DovizTuruPointer $islemDovizTuru
     */
    public function __construct($raporDoviziTutari = null, $yerelTutar = null, $islemDoviziTutari = null, \StructType\DovizTuruPointer $islemDovizTuru = null)
    {
        $this
            ->setRaporDoviziTutari($raporDoviziTutari)
            ->setYerelTutar($yerelTutar)
            ->setIslemDoviziTutari($islemDoviziTutari)
            ->setIslemDovizTuru($islemDovizTuru);
    }
    /**
     * Get RaporDoviziTutari value
     * @return float
     */
    public function getRaporDoviziTutari()
    {
        return $this->RaporDoviziTutari;
    }
    /**
     * Set RaporDoviziTutari value
     * @param float $raporDoviziTutari
     * @return \StructType\DovizliTutar
     */
    public function setRaporDoviziTutari($raporDoviziTutari = null)
    {
        // validation for constraint: float
        if (!is_null($raporDoviziTutari) && !(is_float($raporDoviziTutari) || is_numeric($raporDoviziTutari))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($raporDoviziTutari, true), gettype($raporDoviziTutari)), __LINE__);
        }
        $this->RaporDoviziTutari = $raporDoviziTutari;
        return $this;
    }
    /**
     * Get YerelTutar value
     * @return float
     */
    public function getYerelTutar()
    {
        return $this->YerelTutar;
    }
    /**
     * Set YerelTutar value
     * @param float $yerelTutar
     * @return \StructType\DovizliTutar
     */
    public function setYerelTutar($yerelTutar = null)
    {
        // validation for constraint: float
        if (!is_null($yerelTutar) && !(is_float($yerelTutar) || is_numeric($yerelTutar))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($yerelTutar, true), gettype($yerelTutar)), __LINE__);
        }
        $this->YerelTutar = $yerelTutar;
        return $this;
    }
    /**
     * Get IslemDoviziTutari value
     * @return float
     */
    public function getIslemDoviziTutari()
    {
        return $this->IslemDoviziTutari;
    }
    /**
     * Set IslemDoviziTutari value
     * @param float $islemDoviziTutari
     * @return \StructType\DovizliTutar
     */
    public function setIslemDoviziTutari($islemDoviziTutari = null)
    {
        // validation for constraint: float
        if (!is_null($islemDoviziTutari) && !(is_float($islemDoviziTutari) || is_numeric($islemDoviziTutari))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($islemDoviziTutari, true), gettype($islemDoviziTutari)), __LINE__);
        }
        $this->IslemDoviziTutari = $islemDoviziTutari;
        return $this;
    }
    /**
     * Get IslemDovizTuru value
     * @return \StructType\DovizTuruPointer|null
     */
    public function getIslemDovizTuru()
    {
        return $this->IslemDovizTuru;
    }
    /**
     * Set IslemDovizTuru value
     * @param \StructType\DovizTuruPointer $islemDovizTuru
     * @return \StructType\DovizliTutar
     */
    public function setIslemDovizTuru(\StructType\DovizTuruPointer $islemDovizTuru = null)
    {
        $this->IslemDovizTuru = $islemDovizTuru;
        return $this;
    }
}
