<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CariHesabiMusteriKartBilgisi StructType
 * @subpackage Structs
 */
class CariHesabiMusteriKartBilgisi extends SerendipEntity
{
    /**
     * The MusteriKartNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MusteriKartNo;
    /**
     * The CariHesabi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CariHesabiPointer
     */
    public $CariHesabi;
    /**
     * Constructor method for CariHesabiMusteriKartBilgisi
     * @uses CariHesabiMusteriKartBilgisi::setMusteriKartNo()
     * @uses CariHesabiMusteriKartBilgisi::setCariHesabi()
     * @param string $musteriKartNo
     * @param \StructType\CariHesabiPointer $cariHesabi
     */
    public function __construct($musteriKartNo = null, \StructType\CariHesabiPointer $cariHesabi = null)
    {
        $this
            ->setMusteriKartNo($musteriKartNo)
            ->setCariHesabi($cariHesabi);
    }
    /**
     * Get MusteriKartNo value
     * @return string|null
     */
    public function getMusteriKartNo()
    {
        return $this->MusteriKartNo;
    }
    /**
     * Set MusteriKartNo value
     * @param string $musteriKartNo
     * @return \StructType\CariHesabiMusteriKartBilgisi
     */
    public function setMusteriKartNo($musteriKartNo = null)
    {
        // validation for constraint: string
        if (!is_null($musteriKartNo) && !is_string($musteriKartNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($musteriKartNo, true), gettype($musteriKartNo)), __LINE__);
        }
        $this->MusteriKartNo = $musteriKartNo;
        return $this;
    }
    /**
     * Get CariHesabi value
     * @return \StructType\CariHesabiPointer|null
     */
    public function getCariHesabi()
    {
        return $this->CariHesabi;
    }
    /**
     * Set CariHesabi value
     * @param \StructType\CariHesabiPointer $cariHesabi
     * @return \StructType\CariHesabiMusteriKartBilgisi
     */
    public function setCariHesabi(\StructType\CariHesabiPointer $cariHesabi = null)
    {
        $this->CariHesabi = $cariHesabi;
        return $this;
    }
}
