<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BtcBMT StructType
 * @subpackage Structs
 */
class BtcBMT extends SerendipEntity
{
    /**
     * The kullaniciTipi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $kullaniciTipi;
    /**
     * The Kodu
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Kodu;
    /**
     * The Adi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Adi;
    /**
     * The Telefon1
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Telefon1;
    /**
     * The Telefon2
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Telefon2;
    /**
     * The CepTel
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CepTel;
    /**
     * The Faks
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Faks;
    /**
     * The EMail
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EMail;
    /**
     * The Aciklama
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Aciklama;
    /**
     * The SerendipUserLogin
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SerendipUserLogin;
    /**
     * The PazarlamaGruplari
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfBtcBMTPazarlamaGrubu
     */
    public $PazarlamaGruplari;
    /**
     * Constructor method for BtcBMT
     * @uses BtcBMT::setKullaniciTipi()
     * @uses BtcBMT::setKodu()
     * @uses BtcBMT::setAdi()
     * @uses BtcBMT::setTelefon1()
     * @uses BtcBMT::setTelefon2()
     * @uses BtcBMT::setCepTel()
     * @uses BtcBMT::setFaks()
     * @uses BtcBMT::setEMail()
     * @uses BtcBMT::setAciklama()
     * @uses BtcBMT::setSerendipUserLogin()
     * @uses BtcBMT::setPazarlamaGruplari()
     * @param string $kullaniciTipi
     * @param string $kodu
     * @param string $adi
     * @param string $telefon1
     * @param string $telefon2
     * @param string $cepTel
     * @param string $faks
     * @param string $eMail
     * @param string $aciklama
     * @param string $serendipUserLogin
     * @param \ArrayType\ArrayOfBtcBMTPazarlamaGrubu $pazarlamaGruplari
     */
    public function __construct($kullaniciTipi = null, $kodu = null, $adi = null, $telefon1 = null, $telefon2 = null, $cepTel = null, $faks = null, $eMail = null, $aciklama = null, $serendipUserLogin = null, \ArrayType\ArrayOfBtcBMTPazarlamaGrubu $pazarlamaGruplari = null)
    {
        $this
            ->setKullaniciTipi($kullaniciTipi)
            ->setKodu($kodu)
            ->setAdi($adi)
            ->setTelefon1($telefon1)
            ->setTelefon2($telefon2)
            ->setCepTel($cepTel)
            ->setFaks($faks)
            ->setEMail($eMail)
            ->setAciklama($aciklama)
            ->setSerendipUserLogin($serendipUserLogin)
            ->setPazarlamaGruplari($pazarlamaGruplari);
    }
    /**
     * Get kullaniciTipi value
     * @return string
     */
    public function getKullaniciTipi()
    {
        return $this->kullaniciTipi;
    }
    /**
     * Set kullaniciTipi value
     * @uses \EnumType\KullaniciTipi::valueIsValid()
     * @uses \EnumType\KullaniciTipi::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $kullaniciTipi
     * @return \StructType\BtcBMT
     */
    public function setKullaniciTipi($kullaniciTipi = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\KullaniciTipi::valueIsValid($kullaniciTipi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\KullaniciTipi', is_array($kullaniciTipi) ? implode(', ', $kullaniciTipi) : var_export($kullaniciTipi, true), implode(', ', \EnumType\KullaniciTipi::getValidValues())), __LINE__);
        }
        $this->kullaniciTipi = $kullaniciTipi;
        return $this;
    }
    /**
     * Get Kodu value
     * @return string|null
     */
    public function getKodu()
    {
        return $this->Kodu;
    }
    /**
     * Set Kodu value
     * @param string $kodu
     * @return \StructType\BtcBMT
     */
    public function setKodu($kodu = null)
    {
        // validation for constraint: string
        if (!is_null($kodu) && !is_string($kodu)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kodu, true), gettype($kodu)), __LINE__);
        }
        $this->Kodu = $kodu;
        return $this;
    }
    /**
     * Get Adi value
     * @return string|null
     */
    public function getAdi()
    {
        return $this->Adi;
    }
    /**
     * Set Adi value
     * @param string $adi
     * @return \StructType\BtcBMT
     */
    public function setAdi($adi = null)
    {
        // validation for constraint: string
        if (!is_null($adi) && !is_string($adi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($adi, true), gettype($adi)), __LINE__);
        }
        $this->Adi = $adi;
        return $this;
    }
    /**
     * Get Telefon1 value
     * @return string|null
     */
    public function getTelefon1()
    {
        return $this->Telefon1;
    }
    /**
     * Set Telefon1 value
     * @param string $telefon1
     * @return \StructType\BtcBMT
     */
    public function setTelefon1($telefon1 = null)
    {
        // validation for constraint: string
        if (!is_null($telefon1) && !is_string($telefon1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($telefon1, true), gettype($telefon1)), __LINE__);
        }
        $this->Telefon1 = $telefon1;
        return $this;
    }
    /**
     * Get Telefon2 value
     * @return string|null
     */
    public function getTelefon2()
    {
        return $this->Telefon2;
    }
    /**
     * Set Telefon2 value
     * @param string $telefon2
     * @return \StructType\BtcBMT
     */
    public function setTelefon2($telefon2 = null)
    {
        // validation for constraint: string
        if (!is_null($telefon2) && !is_string($telefon2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($telefon2, true), gettype($telefon2)), __LINE__);
        }
        $this->Telefon2 = $telefon2;
        return $this;
    }
    /**
     * Get CepTel value
     * @return string|null
     */
    public function getCepTel()
    {
        return $this->CepTel;
    }
    /**
     * Set CepTel value
     * @param string $cepTel
     * @return \StructType\BtcBMT
     */
    public function setCepTel($cepTel = null)
    {
        // validation for constraint: string
        if (!is_null($cepTel) && !is_string($cepTel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cepTel, true), gettype($cepTel)), __LINE__);
        }
        $this->CepTel = $cepTel;
        return $this;
    }
    /**
     * Get Faks value
     * @return string|null
     */
    public function getFaks()
    {
        return $this->Faks;
    }
    /**
     * Set Faks value
     * @param string $faks
     * @return \StructType\BtcBMT
     */
    public function setFaks($faks = null)
    {
        // validation for constraint: string
        if (!is_null($faks) && !is_string($faks)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($faks, true), gettype($faks)), __LINE__);
        }
        $this->Faks = $faks;
        return $this;
    }
    /**
     * Get EMail value
     * @return string|null
     */
    public function getEMail()
    {
        return $this->EMail;
    }
    /**
     * Set EMail value
     * @param string $eMail
     * @return \StructType\BtcBMT
     */
    public function setEMail($eMail = null)
    {
        // validation for constraint: string
        if (!is_null($eMail) && !is_string($eMail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eMail, true), gettype($eMail)), __LINE__);
        }
        $this->EMail = $eMail;
        return $this;
    }
    /**
     * Get Aciklama value
     * @return string|null
     */
    public function getAciklama()
    {
        return $this->Aciklama;
    }
    /**
     * Set Aciklama value
     * @param string $aciklama
     * @return \StructType\BtcBMT
     */
    public function setAciklama($aciklama = null)
    {
        // validation for constraint: string
        if (!is_null($aciklama) && !is_string($aciklama)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aciklama, true), gettype($aciklama)), __LINE__);
        }
        $this->Aciklama = $aciklama;
        return $this;
    }
    /**
     * Get SerendipUserLogin value
     * @return string|null
     */
    public function getSerendipUserLogin()
    {
        return $this->SerendipUserLogin;
    }
    /**
     * Set SerendipUserLogin value
     * @param string $serendipUserLogin
     * @return \StructType\BtcBMT
     */
    public function setSerendipUserLogin($serendipUserLogin = null)
    {
        // validation for constraint: string
        if (!is_null($serendipUserLogin) && !is_string($serendipUserLogin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serendipUserLogin, true), gettype($serendipUserLogin)), __LINE__);
        }
        $this->SerendipUserLogin = $serendipUserLogin;
        return $this;
    }
    /**
     * Get PazarlamaGruplari value
     * @return \ArrayType\ArrayOfBtcBMTPazarlamaGrubu|null
     */
    public function getPazarlamaGruplari()
    {
        return $this->PazarlamaGruplari;
    }
    /**
     * Set PazarlamaGruplari value
     * @param \ArrayType\ArrayOfBtcBMTPazarlamaGrubu $pazarlamaGruplari
     * @return \StructType\BtcBMT
     */
    public function setPazarlamaGruplari(\ArrayType\ArrayOfBtcBMTPazarlamaGrubu $pazarlamaGruplari = null)
    {
        $this->PazarlamaGruplari = $pazarlamaGruplari;
        return $this;
    }
}
