<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BaseEntity StructType
 * @subpackage Structs
 */
abstract class BaseEntity extends AbstractStructBase
{
    /**
     * The ReadState
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ReadState;
    /**
     * Constructor method for BaseEntity
     * @uses BaseEntity::setReadState()
     * @param string $readState
     */
    public function __construct($readState = null)
    {
        $this
            ->setReadState($readState);
    }
    /**
     * Get ReadState value
     * @return string
     */
    public function getReadState()
    {
        return $this->ReadState;
    }
    /**
     * Set ReadState value
     * @uses \EnumType\EntityReadState::valueIsValid()
     * @uses \EnumType\EntityReadState::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $readState
     * @return \StructType\BaseEntity
     */
    public function setReadState($readState = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EntityReadState::valueIsValid($readState)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\EntityReadState', is_array($readState) ? implode(', ', $readState) : var_export($readState, true), implode(', ', \EnumType\EntityReadState::getValidValues())), __LINE__);
        }
        $this->ReadState = $readState;
        return $this;
    }
}
