<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfKKargo ArrayType
 * @subpackage Arrays
 */
class ArrayOfKKargo extends AbstractStructArrayBase
{
    /**
     * The KKargo
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\KKargo[]
     */
    public $KKargo;
    /**
     * Constructor method for ArrayOfKKargo
     * @uses ArrayOfKKargo::setKKargo()
     * @param \StructType\KKargo[] $kKargo
     */
    public function __construct(array $kKargo = array())
    {
        $this
            ->setKKargo($kKargo);
    }
    /**
     * Get KKargo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\KKargo[]|null
     */
    public function getKKargo()
    {
        return isset($this->KKargo) ? $this->KKargo : null;
    }
    /**
     * This method is responsible for validating the values passed to the setKKargo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setKKargo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateKKargoForArrayConstraintsFromSetKKargo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfKKargoKKargoItem) {
            // validation for constraint: itemType
            if (!$arrayOfKKargoKKargoItem instanceof \StructType\KKargo) {
                $invalidValues[] = is_object($arrayOfKKargoKKargoItem) ? get_class($arrayOfKKargoKKargoItem) : sprintf('%s(%s)', gettype($arrayOfKKargoKKargoItem), var_export($arrayOfKKargoKKargoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The KKargo property can only contain items of type \StructType\KKargo, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set KKargo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\KKargo[] $kKargo
     * @return \ArrayType\ArrayOfKKargo
     */
    public function setKKargo(array $kKargo = array())
    {
        // validation for constraint: array
        if ('' !== ($kKargoArrayErrorMessage = self::validateKKargoForArrayConstraintsFromSetKKargo($kKargo))) {
            throw new \InvalidArgumentException($kKargoArrayErrorMessage, __LINE__);
        }
        if (is_null($kKargo) || (is_array($kKargo) && empty($kKargo))) {
            unset($this->KKargo);
        } else {
            $this->KKargo = $kKargo;
        }
        return $this;
    }
    /**
     * Add item to KKargo value
     * @throws \InvalidArgumentException
     * @param \StructType\KKargo $item
     * @return \ArrayType\ArrayOfKKargo
     */
    public function addToKKargo(\StructType\KKargo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\KKargo) {
            throw new \InvalidArgumentException(sprintf('The KKargo property can only contain items of type \StructType\KKargo, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->KKargo[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\KKargo|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\KKargo|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\KKargo|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\KKargo|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\KKargo|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string KKargo
     */
    public function getAttributeName()
    {
        return 'KKargo';
    }
}
