<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Pointer StructType
 * @subpackage Structs
 */
abstract class Pointer extends BaseEntity
{
    /**
     * The ObjId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ObjId;
    /**
     * Constructor method for Pointer
     * @uses Pointer::setObjId()
     * @param int $objId
     */
    public function __construct($objId = null)
    {
        $this
            ->setObjId($objId);
    }
    /**
     * Get ObjId value
     * @return int
     */
    public function getObjId()
    {
        return $this->ObjId;
    }
    /**
     * Set ObjId value
     * @param int $objId
     * @return \StructType\Pointer
     */
    public function setObjId($objId = null)
    {
        // validation for constraint: int
        if (!is_null($objId) && !(is_int($objId) || ctype_digit($objId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($objId, true), gettype($objId)), __LINE__);
        }
        $this->ObjId = $objId;
        return $this;
    }
}
