<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaketZimmet StructType
 * @subpackage Structs
 */
class PaketZimmet extends AbstractStructBase
{
    /**
     * The Adedi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Adedi;
    /**
     * The PaketAdi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PaketAdi;
    /**
     * Constructor method for PaketZimmet
     * @uses PaketZimmet::setAdedi()
     * @uses PaketZimmet::setPaketAdi()
     * @param int $adedi
     * @param string $paketAdi
     */
    public function __construct($adedi = null, $paketAdi = null)
    {
        $this
            ->setAdedi($adedi)
            ->setPaketAdi($paketAdi);
    }
    /**
     * Get Adedi value
     * @return int
     */
    public function getAdedi()
    {
        return $this->Adedi;
    }
    /**
     * Set Adedi value
     * @param int $adedi
     * @return \StructType\PaketZimmet
     */
    public function setAdedi($adedi = null)
    {
        // validation for constraint: int
        if (!is_null($adedi) && !(is_int($adedi) || ctype_digit($adedi))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($adedi, true), gettype($adedi)), __LINE__);
        }
        $this->Adedi = $adedi;
        return $this;
    }
    /**
     * Get PaketAdi value
     * @return string|null
     */
    public function getPaketAdi()
    {
        return $this->PaketAdi;
    }
    /**
     * Set PaketAdi value
     * @param string $paketAdi
     * @return \StructType\PaketZimmet
     */
    public function setPaketAdi($paketAdi = null)
    {
        // validation for constraint: string
        if (!is_null($paketAdi) && !is_string($paketAdi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paketAdi, true), gettype($paketAdi)), __LINE__);
        }
        $this->PaketAdi = $paketAdi;
        return $this;
    }
}
