<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MuhasebeHesabi StructType
 * @subpackage Structs
 */
class MuhasebeHesabi extends Hesap
{
    /**
     * The BakiyeTipi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $BakiyeTipi;
    /**
     * The CalismaTipi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $CalismaTipi;
    /**
     * The IslemParaCinsi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $IslemParaCinsi;
    /**
     * The Parasal
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Parasal;
    /**
     * The OnayTarihi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $OnayTarihi;
    /**
     * The ManuelFiseKapali
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $ManuelFiseKapali;
    /**
     * The BakiyeEksiyeDusunce
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $BakiyeEksiyeDusunce;
    /**
     * The KurFarkiHesaplanacak
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $KurFarkiHesaplanacak;
    /**
     * The Seviye
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Seviye;
    /**
     * The UcHesapMi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $UcHesapMi;
    /**
     * The HareketleriOlsadaKaydet
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $HareketleriOlsadaKaydet;
    /**
     * The UstHesap
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\MuhasebeHesabiPointer
     */
    public $UstHesap;
    /**
     * The HesapTuru
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\MuhasebeHesapTuruPointer
     */
    public $HesapTuru;
    /**
     * The KurFarkiGiderHesabi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\MuhasebeHesabiPointer
     */
    public $KurFarkiGiderHesabi;
    /**
     * The KurFarkiGelirHesabi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\MuhasebeHesabiPointer
     */
    public $KurFarkiGelirHesabi;
    /**
     * The Bakiyeler
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfMuhasebeHesabiBakiyesi
     */
    public $Bakiyeler;
    /**
     * The OrtakHesapPlaniKodu
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OrtakHesapPlaniKodu;
    /**
     * Constructor method for MuhasebeHesabi
     * @uses MuhasebeHesabi::setBakiyeTipi()
     * @uses MuhasebeHesabi::setCalismaTipi()
     * @uses MuhasebeHesabi::setIslemParaCinsi()
     * @uses MuhasebeHesabi::setParasal()
     * @uses MuhasebeHesabi::setOnayTarihi()
     * @uses MuhasebeHesabi::setManuelFiseKapali()
     * @uses MuhasebeHesabi::setBakiyeEksiyeDusunce()
     * @uses MuhasebeHesabi::setKurFarkiHesaplanacak()
     * @uses MuhasebeHesabi::setSeviye()
     * @uses MuhasebeHesabi::setUcHesapMi()
     * @uses MuhasebeHesabi::setHareketleriOlsadaKaydet()
     * @uses MuhasebeHesabi::setUstHesap()
     * @uses MuhasebeHesabi::setHesapTuru()
     * @uses MuhasebeHesabi::setKurFarkiGiderHesabi()
     * @uses MuhasebeHesabi::setKurFarkiGelirHesabi()
     * @uses MuhasebeHesabi::setBakiyeler()
     * @uses MuhasebeHesabi::setOrtakHesapPlaniKodu()
     * @param string $bakiyeTipi
     * @param string $calismaTipi
     * @param string $islemParaCinsi
     * @param bool $parasal
     * @param string $onayTarihi
     * @param bool $manuelFiseKapali
     * @param string $bakiyeEksiyeDusunce
     * @param bool $kurFarkiHesaplanacak
     * @param int $seviye
     * @param bool $ucHesapMi
     * @param bool $hareketleriOlsadaKaydet
     * @param \StructType\MuhasebeHesabiPointer $ustHesap
     * @param \StructType\MuhasebeHesapTuruPointer $hesapTuru
     * @param \StructType\MuhasebeHesabiPointer $kurFarkiGiderHesabi
     * @param \StructType\MuhasebeHesabiPointer $kurFarkiGelirHesabi
     * @param \ArrayType\ArrayOfMuhasebeHesabiBakiyesi $bakiyeler
     * @param string $ortakHesapPlaniKodu
     */
    public function __construct($bakiyeTipi = null, $calismaTipi = null, $islemParaCinsi = null, $parasal = null, $onayTarihi = null, $manuelFiseKapali = null, $bakiyeEksiyeDusunce = null, $kurFarkiHesaplanacak = null, $seviye = null, $ucHesapMi = null, $hareketleriOlsadaKaydet = null, \StructType\MuhasebeHesabiPointer $ustHesap = null, \StructType\MuhasebeHesapTuruPointer $hesapTuru = null, \StructType\MuhasebeHesabiPointer $kurFarkiGiderHesabi = null, \StructType\MuhasebeHesabiPointer $kurFarkiGelirHesabi = null, \ArrayType\ArrayOfMuhasebeHesabiBakiyesi $bakiyeler = null, $ortakHesapPlaniKodu = null)
    {
        $this
            ->setBakiyeTipi($bakiyeTipi)
            ->setCalismaTipi($calismaTipi)
            ->setIslemParaCinsi($islemParaCinsi)
            ->setParasal($parasal)
            ->setOnayTarihi($onayTarihi)
            ->setManuelFiseKapali($manuelFiseKapali)
            ->setBakiyeEksiyeDusunce($bakiyeEksiyeDusunce)
            ->setKurFarkiHesaplanacak($kurFarkiHesaplanacak)
            ->setSeviye($seviye)
            ->setUcHesapMi($ucHesapMi)
            ->setHareketleriOlsadaKaydet($hareketleriOlsadaKaydet)
            ->setUstHesap($ustHesap)
            ->setHesapTuru($hesapTuru)
            ->setKurFarkiGiderHesabi($kurFarkiGiderHesabi)
            ->setKurFarkiGelirHesabi($kurFarkiGelirHesabi)
            ->setBakiyeler($bakiyeler)
            ->setOrtakHesapPlaniKodu($ortakHesapPlaniKodu);
    }
    /**
     * Get BakiyeTipi value
     * @return string
     */
    public function getBakiyeTipi()
    {
        return $this->BakiyeTipi;
    }
    /**
     * Set BakiyeTipi value
     * @uses \EnumType\BakiyeTipi::valueIsValid()
     * @uses \EnumType\BakiyeTipi::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $bakiyeTipi
     * @return \StructType\MuhasebeHesabi
     */
    public function setBakiyeTipi($bakiyeTipi = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\BakiyeTipi::valueIsValid($bakiyeTipi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\BakiyeTipi', is_array($bakiyeTipi) ? implode(', ', $bakiyeTipi) : var_export($bakiyeTipi, true), implode(', ', \EnumType\BakiyeTipi::getValidValues())), __LINE__);
        }
        $this->BakiyeTipi = $bakiyeTipi;
        return $this;
    }
    /**
     * Get CalismaTipi value
     * @return string
     */
    public function getCalismaTipi()
    {
        return $this->CalismaTipi;
    }
    /**
     * Set CalismaTipi value
     * @uses \EnumType\BakiyeTipi::valueIsValid()
     * @uses \EnumType\BakiyeTipi::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $calismaTipi
     * @return \StructType\MuhasebeHesabi
     */
    public function setCalismaTipi($calismaTipi = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\BakiyeTipi::valueIsValid($calismaTipi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\BakiyeTipi', is_array($calismaTipi) ? implode(', ', $calismaTipi) : var_export($calismaTipi, true), implode(', ', \EnumType\BakiyeTipi::getValidValues())), __LINE__);
        }
        $this->CalismaTipi = $calismaTipi;
        return $this;
    }
    /**
     * Get IslemParaCinsi value
     * @return string
     */
    public function getIslemParaCinsi()
    {
        return $this->IslemParaCinsi;
    }
    /**
     * Set IslemParaCinsi value
     * @uses \EnumType\IslemParaCinsi::valueIsValid()
     * @uses \EnumType\IslemParaCinsi::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $islemParaCinsi
     * @return \StructType\MuhasebeHesabi
     */
    public function setIslemParaCinsi($islemParaCinsi = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\IslemParaCinsi::valueIsValid($islemParaCinsi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\IslemParaCinsi', is_array($islemParaCinsi) ? implode(', ', $islemParaCinsi) : var_export($islemParaCinsi, true), implode(', ', \EnumType\IslemParaCinsi::getValidValues())), __LINE__);
        }
        $this->IslemParaCinsi = $islemParaCinsi;
        return $this;
    }
    /**
     * Get Parasal value
     * @return bool
     */
    public function getParasal()
    {
        return $this->Parasal;
    }
    /**
     * Set Parasal value
     * @param bool $parasal
     * @return \StructType\MuhasebeHesabi
     */
    public function setParasal($parasal = null)
    {
        // validation for constraint: boolean
        if (!is_null($parasal) && !is_bool($parasal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($parasal, true), gettype($parasal)), __LINE__);
        }
        $this->Parasal = $parasal;
        return $this;
    }
    /**
     * Get OnayTarihi value
     * @return string
     */
    public function getOnayTarihi()
    {
        return $this->OnayTarihi;
    }
    /**
     * Set OnayTarihi value
     * @param string $onayTarihi
     * @return \StructType\MuhasebeHesabi
     */
    public function setOnayTarihi($onayTarihi = null)
    {
        // validation for constraint: string
        if (!is_null($onayTarihi) && !is_string($onayTarihi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($onayTarihi, true), gettype($onayTarihi)), __LINE__);
        }
        $this->OnayTarihi = $onayTarihi;
        return $this;
    }
    /**
     * Get ManuelFiseKapali value
     * @return bool
     */
    public function getManuelFiseKapali()
    {
        return $this->ManuelFiseKapali;
    }
    /**
     * Set ManuelFiseKapali value
     * @param bool $manuelFiseKapali
     * @return \StructType\MuhasebeHesabi
     */
    public function setManuelFiseKapali($manuelFiseKapali = null)
    {
        // validation for constraint: boolean
        if (!is_null($manuelFiseKapali) && !is_bool($manuelFiseKapali)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($manuelFiseKapali, true), gettype($manuelFiseKapali)), __LINE__);
        }
        $this->ManuelFiseKapali = $manuelFiseKapali;
        return $this;
    }
    /**
     * Get BakiyeEksiyeDusunce value
     * @return string
     */
    public function getBakiyeEksiyeDusunce()
    {
        return $this->BakiyeEksiyeDusunce;
    }
    /**
     * Set BakiyeEksiyeDusunce value
     * @uses \EnumType\KontrolSekilleri::valueIsValid()
     * @uses \EnumType\KontrolSekilleri::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $bakiyeEksiyeDusunce
     * @return \StructType\MuhasebeHesabi
     */
    public function setBakiyeEksiyeDusunce($bakiyeEksiyeDusunce = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\KontrolSekilleri::valueIsValid($bakiyeEksiyeDusunce)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\KontrolSekilleri', is_array($bakiyeEksiyeDusunce) ? implode(', ', $bakiyeEksiyeDusunce) : var_export($bakiyeEksiyeDusunce, true), implode(', ', \EnumType\KontrolSekilleri::getValidValues())), __LINE__);
        }
        $this->BakiyeEksiyeDusunce = $bakiyeEksiyeDusunce;
        return $this;
    }
    /**
     * Get KurFarkiHesaplanacak value
     * @return bool
     */
    public function getKurFarkiHesaplanacak()
    {
        return $this->KurFarkiHesaplanacak;
    }
    /**
     * Set KurFarkiHesaplanacak value
     * @param bool $kurFarkiHesaplanacak
     * @return \StructType\MuhasebeHesabi
     */
    public function setKurFarkiHesaplanacak($kurFarkiHesaplanacak = null)
    {
        // validation for constraint: boolean
        if (!is_null($kurFarkiHesaplanacak) && !is_bool($kurFarkiHesaplanacak)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($kurFarkiHesaplanacak, true), gettype($kurFarkiHesaplanacak)), __LINE__);
        }
        $this->KurFarkiHesaplanacak = $kurFarkiHesaplanacak;
        return $this;
    }
    /**
     * Get Seviye value
     * @return int
     */
    public function getSeviye()
    {
        return $this->Seviye;
    }
    /**
     * Set Seviye value
     * @param int $seviye
     * @return \StructType\MuhasebeHesabi
     */
    public function setSeviye($seviye = null)
    {
        // validation for constraint: int
        if (!is_null($seviye) && !(is_int($seviye) || ctype_digit($seviye))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($seviye, true), gettype($seviye)), __LINE__);
        }
        $this->Seviye = $seviye;
        return $this;
    }
    /**
     * Get UcHesapMi value
     * @return bool
     */
    public function getUcHesapMi()
    {
        return $this->UcHesapMi;
    }
    /**
     * Set UcHesapMi value
     * @param bool $ucHesapMi
     * @return \StructType\MuhasebeHesabi
     */
    public function setUcHesapMi($ucHesapMi = null)
    {
        // validation for constraint: boolean
        if (!is_null($ucHesapMi) && !is_bool($ucHesapMi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($ucHesapMi, true), gettype($ucHesapMi)), __LINE__);
        }
        $this->UcHesapMi = $ucHesapMi;
        return $this;
    }
    /**
     * Get HareketleriOlsadaKaydet value
     * @return bool
     */
    public function getHareketleriOlsadaKaydet()
    {
        return $this->HareketleriOlsadaKaydet;
    }
    /**
     * Set HareketleriOlsadaKaydet value
     * @param bool $hareketleriOlsadaKaydet
     * @return \StructType\MuhasebeHesabi
     */
    public function setHareketleriOlsadaKaydet($hareketleriOlsadaKaydet = null)
    {
        // validation for constraint: boolean
        if (!is_null($hareketleriOlsadaKaydet) && !is_bool($hareketleriOlsadaKaydet)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($hareketleriOlsadaKaydet, true), gettype($hareketleriOlsadaKaydet)), __LINE__);
        }
        $this->HareketleriOlsadaKaydet = $hareketleriOlsadaKaydet;
        return $this;
    }
    /**
     * Get UstHesap value
     * @return \StructType\MuhasebeHesabiPointer|null
     */
    public function getUstHesap()
    {
        return $this->UstHesap;
    }
    /**
     * Set UstHesap value
     * @param \StructType\MuhasebeHesabiPointer $ustHesap
     * @return \StructType\MuhasebeHesabi
     */
    public function setUstHesap(\StructType\MuhasebeHesabiPointer $ustHesap = null)
    {
        $this->UstHesap = $ustHesap;
        return $this;
    }
    /**
     * Get HesapTuru value
     * @return \StructType\MuhasebeHesapTuruPointer|null
     */
    public function getHesapTuru()
    {
        return $this->HesapTuru;
    }
    /**
     * Set HesapTuru value
     * @param \StructType\MuhasebeHesapTuruPointer $hesapTuru
     * @return \StructType\MuhasebeHesabi
     */
    public function setHesapTuru(\StructType\MuhasebeHesapTuruPointer $hesapTuru = null)
    {
        $this->HesapTuru = $hesapTuru;
        return $this;
    }
    /**
     * Get KurFarkiGiderHesabi value
     * @return \StructType\MuhasebeHesabiPointer|null
     */
    public function getKurFarkiGiderHesabi()
    {
        return $this->KurFarkiGiderHesabi;
    }
    /**
     * Set KurFarkiGiderHesabi value
     * @param \StructType\MuhasebeHesabiPointer $kurFarkiGiderHesabi
     * @return \StructType\MuhasebeHesabi
     */
    public function setKurFarkiGiderHesabi(\StructType\MuhasebeHesabiPointer $kurFarkiGiderHesabi = null)
    {
        $this->KurFarkiGiderHesabi = $kurFarkiGiderHesabi;
        return $this;
    }
    /**
     * Get KurFarkiGelirHesabi value
     * @return \StructType\MuhasebeHesabiPointer|null
     */
    public function getKurFarkiGelirHesabi()
    {
        return $this->KurFarkiGelirHesabi;
    }
    /**
     * Set KurFarkiGelirHesabi value
     * @param \StructType\MuhasebeHesabiPointer $kurFarkiGelirHesabi
     * @return \StructType\MuhasebeHesabi
     */
    public function setKurFarkiGelirHesabi(\StructType\MuhasebeHesabiPointer $kurFarkiGelirHesabi = null)
    {
        $this->KurFarkiGelirHesabi = $kurFarkiGelirHesabi;
        return $this;
    }
    /**
     * Get Bakiyeler value
     * @return \ArrayType\ArrayOfMuhasebeHesabiBakiyesi|null
     */
    public function getBakiyeler()
    {
        return $this->Bakiyeler;
    }
    /**
     * Set Bakiyeler value
     * @param \ArrayType\ArrayOfMuhasebeHesabiBakiyesi $bakiyeler
     * @return \StructType\MuhasebeHesabi
     */
    public function setBakiyeler(\ArrayType\ArrayOfMuhasebeHesabiBakiyesi $bakiyeler = null)
    {
        $this->Bakiyeler = $bakiyeler;
        return $this;
    }
    /**
     * Get OrtakHesapPlaniKodu value
     * @return string|null
     */
    public function getOrtakHesapPlaniKodu()
    {
        return $this->OrtakHesapPlaniKodu;
    }
    /**
     * Set OrtakHesapPlaniKodu value
     * @param string $ortakHesapPlaniKodu
     * @return \StructType\MuhasebeHesabi
     */
    public function setOrtakHesapPlaniKodu($ortakHesapPlaniKodu = null)
    {
        // validation for constraint: string
        if (!is_null($ortakHesapPlaniKodu) && !is_string($ortakHesapPlaniKodu)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ortakHesapPlaniKodu, true), gettype($ortakHesapPlaniKodu)), __LINE__);
        }
        $this->OrtakHesapPlaniKodu = $ortakHesapPlaniKodu;
        return $this;
    }
}
