<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MLYPersonelFaaliyet StructType
 * @subpackage Structs
 */
class MLYPersonelFaaliyet extends MaliyetBaseEntity
{
    /**
     * The Entity_ObjId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Entity_ObjId;
    /**
     * The DirektPersonel
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $DirektPersonel;
    /**
     * The PersonelCalismaDurumu
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $PersonelCalismaDurumu;
    /**
     * The EntityName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EntityName;
    /**
     * The MLYPersonelFaaliyetSatiri
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfMLYPersonelFaaliyetSatiri
     */
    public $MLYPersonelFaaliyetSatiri;
    /**
     * The PersonelNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PersonelNo;
    /**
     * The TcKimlikNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TcKimlikNo;
    /**
     * The Satirlar
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfMLYPersonelFaaliyetSatiri
     */
    public $Satirlar;
    /**
     * Constructor method for MLYPersonelFaaliyet
     * @uses MLYPersonelFaaliyet::setEntity_ObjId()
     * @uses MLYPersonelFaaliyet::setDirektPersonel()
     * @uses MLYPersonelFaaliyet::setPersonelCalismaDurumu()
     * @uses MLYPersonelFaaliyet::setEntityName()
     * @uses MLYPersonelFaaliyet::setMLYPersonelFaaliyetSatiri()
     * @uses MLYPersonelFaaliyet::setPersonelNo()
     * @uses MLYPersonelFaaliyet::setTcKimlikNo()
     * @uses MLYPersonelFaaliyet::setSatirlar()
     * @param int $entity_ObjId
     * @param bool $direktPersonel
     * @param bool $personelCalismaDurumu
     * @param string $entityName
     * @param \ArrayType\ArrayOfMLYPersonelFaaliyetSatiri $mLYPersonelFaaliyetSatiri
     * @param string $personelNo
     * @param string $tcKimlikNo
     * @param \ArrayType\ArrayOfMLYPersonelFaaliyetSatiri $satirlar
     */
    public function __construct($entity_ObjId = null, $direktPersonel = null, $personelCalismaDurumu = null, $entityName = null, \ArrayType\ArrayOfMLYPersonelFaaliyetSatiri $mLYPersonelFaaliyetSatiri = null, $personelNo = null, $tcKimlikNo = null, \ArrayType\ArrayOfMLYPersonelFaaliyetSatiri $satirlar = null)
    {
        $this
            ->setEntity_ObjId($entity_ObjId)
            ->setDirektPersonel($direktPersonel)
            ->setPersonelCalismaDurumu($personelCalismaDurumu)
            ->setEntityName($entityName)
            ->setMLYPersonelFaaliyetSatiri($mLYPersonelFaaliyetSatiri)
            ->setPersonelNo($personelNo)
            ->setTcKimlikNo($tcKimlikNo)
            ->setSatirlar($satirlar);
    }
    /**
     * Get Entity_ObjId value
     * @return int
     */
    public function getEntity_ObjId()
    {
        return $this->Entity_ObjId;
    }
    /**
     * Set Entity_ObjId value
     * @param int $entity_ObjId
     * @return \StructType\MLYPersonelFaaliyet
     */
    public function setEntity_ObjId($entity_ObjId = null)
    {
        // validation for constraint: int
        if (!is_null($entity_ObjId) && !(is_int($entity_ObjId) || ctype_digit($entity_ObjId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($entity_ObjId, true), gettype($entity_ObjId)), __LINE__);
        }
        $this->Entity_ObjId = $entity_ObjId;
        return $this;
    }
    /**
     * Get DirektPersonel value
     * @return bool
     */
    public function getDirektPersonel()
    {
        return $this->DirektPersonel;
    }
    /**
     * Set DirektPersonel value
     * @param bool $direktPersonel
     * @return \StructType\MLYPersonelFaaliyet
     */
    public function setDirektPersonel($direktPersonel = null)
    {
        // validation for constraint: boolean
        if (!is_null($direktPersonel) && !is_bool($direktPersonel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($direktPersonel, true), gettype($direktPersonel)), __LINE__);
        }
        $this->DirektPersonel = $direktPersonel;
        return $this;
    }
    /**
     * Get PersonelCalismaDurumu value
     * @return bool
     */
    public function getPersonelCalismaDurumu()
    {
        return $this->PersonelCalismaDurumu;
    }
    /**
     * Set PersonelCalismaDurumu value
     * @param bool $personelCalismaDurumu
     * @return \StructType\MLYPersonelFaaliyet
     */
    public function setPersonelCalismaDurumu($personelCalismaDurumu = null)
    {
        // validation for constraint: boolean
        if (!is_null($personelCalismaDurumu) && !is_bool($personelCalismaDurumu)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($personelCalismaDurumu, true), gettype($personelCalismaDurumu)), __LINE__);
        }
        $this->PersonelCalismaDurumu = $personelCalismaDurumu;
        return $this;
    }
    /**
     * Get EntityName value
     * @return string|null
     */
    public function getEntityName()
    {
        return $this->EntityName;
    }
    /**
     * Set EntityName value
     * @param string $entityName
     * @return \StructType\MLYPersonelFaaliyet
     */
    public function setEntityName($entityName = null)
    {
        // validation for constraint: string
        if (!is_null($entityName) && !is_string($entityName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($entityName, true), gettype($entityName)), __LINE__);
        }
        $this->EntityName = $entityName;
        return $this;
    }
    /**
     * Get MLYPersonelFaaliyetSatiri value
     * @return \ArrayType\ArrayOfMLYPersonelFaaliyetSatiri|null
     */
    public function getMLYPersonelFaaliyetSatiri()
    {
        return $this->MLYPersonelFaaliyetSatiri;
    }
    /**
     * Set MLYPersonelFaaliyetSatiri value
     * @param \ArrayType\ArrayOfMLYPersonelFaaliyetSatiri $mLYPersonelFaaliyetSatiri
     * @return \StructType\MLYPersonelFaaliyet
     */
    public function setMLYPersonelFaaliyetSatiri(\ArrayType\ArrayOfMLYPersonelFaaliyetSatiri $mLYPersonelFaaliyetSatiri = null)
    {
        $this->MLYPersonelFaaliyetSatiri = $mLYPersonelFaaliyetSatiri;
        return $this;
    }
    /**
     * Get PersonelNo value
     * @return string|null
     */
    public function getPersonelNo()
    {
        return $this->PersonelNo;
    }
    /**
     * Set PersonelNo value
     * @param string $personelNo
     * @return \StructType\MLYPersonelFaaliyet
     */
    public function setPersonelNo($personelNo = null)
    {
        // validation for constraint: string
        if (!is_null($personelNo) && !is_string($personelNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($personelNo, true), gettype($personelNo)), __LINE__);
        }
        $this->PersonelNo = $personelNo;
        return $this;
    }
    /**
     * Get TcKimlikNo value
     * @return string|null
     */
    public function getTcKimlikNo()
    {
        return $this->TcKimlikNo;
    }
    /**
     * Set TcKimlikNo value
     * @param string $tcKimlikNo
     * @return \StructType\MLYPersonelFaaliyet
     */
    public function setTcKimlikNo($tcKimlikNo = null)
    {
        // validation for constraint: string
        if (!is_null($tcKimlikNo) && !is_string($tcKimlikNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tcKimlikNo, true), gettype($tcKimlikNo)), __LINE__);
        }
        $this->TcKimlikNo = $tcKimlikNo;
        return $this;
    }
    /**
     * Get Satirlar value
     * @return \ArrayType\ArrayOfMLYPersonelFaaliyetSatiri|null
     */
    public function getSatirlar()
    {
        return $this->Satirlar;
    }
    /**
     * Set Satirlar value
     * @param \ArrayType\ArrayOfMLYPersonelFaaliyetSatiri $satirlar
     * @return \StructType\MLYPersonelFaaliyet
     */
    public function setSatirlar(\ArrayType\ArrayOfMLYPersonelFaaliyetSatiri $satirlar = null)
    {
        $this->Satirlar = $satirlar;
        return $this;
    }
}
