<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for KasaHesabi StructType
 * @subpackage Structs
 */
class KasaHesabi extends Hesap
{
    /**
     * The IslemLimiti
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $IslemLimiti;
    /**
     * The AylikIslemLimiti
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $AylikIslemLimiti;
    /**
     * The NegatifOlamaz
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $NegatifOlamaz;
    /**
     * The OnayTarihi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $OnayTarihi;
    /**
     * The IslemDovizi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\DovizTuruPointer
     */
    public $IslemDovizi;
    /**
     * The Adresi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Adres
     */
    public $Adresi;
    /**
     * The MuhasebeKodu
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\MuhasebeHesabiPointer
     */
    public $MuhasebeKodu;
    /**
     * The MuhasebeHesapSablonu
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\KasaMuhasebeHesapSablonuPointer
     */
    public $MuhasebeHesapSablonu;
    /**
     * The Bakiyeler
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfKasaHesabiBakiye
     */
    public $Bakiyeler;
    /**
     * The ReferansYetki
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\YetkiPointer
     */
    public $ReferansYetki;
    /**
     * Constructor method for KasaHesabi
     * @uses KasaHesabi::setIslemLimiti()
     * @uses KasaHesabi::setAylikIslemLimiti()
     * @uses KasaHesabi::setNegatifOlamaz()
     * @uses KasaHesabi::setOnayTarihi()
     * @uses KasaHesabi::setIslemDovizi()
     * @uses KasaHesabi::setAdresi()
     * @uses KasaHesabi::setMuhasebeKodu()
     * @uses KasaHesabi::setMuhasebeHesapSablonu()
     * @uses KasaHesabi::setBakiyeler()
     * @uses KasaHesabi::setReferansYetki()
     * @param float $islemLimiti
     * @param float $aylikIslemLimiti
     * @param bool $negatifOlamaz
     * @param string $onayTarihi
     * @param \StructType\DovizTuruPointer $islemDovizi
     * @param \StructType\Adres $adresi
     * @param \StructType\MuhasebeHesabiPointer $muhasebeKodu
     * @param \StructType\KasaMuhasebeHesapSablonuPointer $muhasebeHesapSablonu
     * @param \ArrayType\ArrayOfKasaHesabiBakiye $bakiyeler
     * @param \StructType\YetkiPointer $referansYetki
     */
    public function __construct($islemLimiti = null, $aylikIslemLimiti = null, $negatifOlamaz = null, $onayTarihi = null, \StructType\DovizTuruPointer $islemDovizi = null, \StructType\Adres $adresi = null, \StructType\MuhasebeHesabiPointer $muhasebeKodu = null, \StructType\KasaMuhasebeHesapSablonuPointer $muhasebeHesapSablonu = null, \ArrayType\ArrayOfKasaHesabiBakiye $bakiyeler = null, \StructType\YetkiPointer $referansYetki = null)
    {
        $this
            ->setIslemLimiti($islemLimiti)
            ->setAylikIslemLimiti($aylikIslemLimiti)
            ->setNegatifOlamaz($negatifOlamaz)
            ->setOnayTarihi($onayTarihi)
            ->setIslemDovizi($islemDovizi)
            ->setAdresi($adresi)
            ->setMuhasebeKodu($muhasebeKodu)
            ->setMuhasebeHesapSablonu($muhasebeHesapSablonu)
            ->setBakiyeler($bakiyeler)
            ->setReferansYetki($referansYetki);
    }
    /**
     * Get IslemLimiti value
     * @return float
     */
    public function getIslemLimiti()
    {
        return $this->IslemLimiti;
    }
    /**
     * Set IslemLimiti value
     * @param float $islemLimiti
     * @return \StructType\KasaHesabi
     */
    public function setIslemLimiti($islemLimiti = null)
    {
        // validation for constraint: float
        if (!is_null($islemLimiti) && !(is_float($islemLimiti) || is_numeric($islemLimiti))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($islemLimiti, true), gettype($islemLimiti)), __LINE__);
        }
        $this->IslemLimiti = $islemLimiti;
        return $this;
    }
    /**
     * Get AylikIslemLimiti value
     * @return float
     */
    public function getAylikIslemLimiti()
    {
        return $this->AylikIslemLimiti;
    }
    /**
     * Set AylikIslemLimiti value
     * @param float $aylikIslemLimiti
     * @return \StructType\KasaHesabi
     */
    public function setAylikIslemLimiti($aylikIslemLimiti = null)
    {
        // validation for constraint: float
        if (!is_null($aylikIslemLimiti) && !(is_float($aylikIslemLimiti) || is_numeric($aylikIslemLimiti))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($aylikIslemLimiti, true), gettype($aylikIslemLimiti)), __LINE__);
        }
        $this->AylikIslemLimiti = $aylikIslemLimiti;
        return $this;
    }
    /**
     * Get NegatifOlamaz value
     * @return bool
     */
    public function getNegatifOlamaz()
    {
        return $this->NegatifOlamaz;
    }
    /**
     * Set NegatifOlamaz value
     * @param bool $negatifOlamaz
     * @return \StructType\KasaHesabi
     */
    public function setNegatifOlamaz($negatifOlamaz = null)
    {
        // validation for constraint: boolean
        if (!is_null($negatifOlamaz) && !is_bool($negatifOlamaz)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($negatifOlamaz, true), gettype($negatifOlamaz)), __LINE__);
        }
        $this->NegatifOlamaz = $negatifOlamaz;
        return $this;
    }
    /**
     * Get OnayTarihi value
     * @return string
     */
    public function getOnayTarihi()
    {
        return $this->OnayTarihi;
    }
    /**
     * Set OnayTarihi value
     * @param string $onayTarihi
     * @return \StructType\KasaHesabi
     */
    public function setOnayTarihi($onayTarihi = null)
    {
        // validation for constraint: string
        if (!is_null($onayTarihi) && !is_string($onayTarihi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($onayTarihi, true), gettype($onayTarihi)), __LINE__);
        }
        $this->OnayTarihi = $onayTarihi;
        return $this;
    }
    /**
     * Get IslemDovizi value
     * @return \StructType\DovizTuruPointer|null
     */
    public function getIslemDovizi()
    {
        return $this->IslemDovizi;
    }
    /**
     * Set IslemDovizi value
     * @param \StructType\DovizTuruPointer $islemDovizi
     * @return \StructType\KasaHesabi
     */
    public function setIslemDovizi(\StructType\DovizTuruPointer $islemDovizi = null)
    {
        $this->IslemDovizi = $islemDovizi;
        return $this;
    }
    /**
     * Get Adresi value
     * @return \StructType\Adres|null
     */
    public function getAdresi()
    {
        return $this->Adresi;
    }
    /**
     * Set Adresi value
     * @param \StructType\Adres $adresi
     * @return \StructType\KasaHesabi
     */
    public function setAdresi(\StructType\Adres $adresi = null)
    {
        $this->Adresi = $adresi;
        return $this;
    }
    /**
     * Get MuhasebeKodu value
     * @return \StructType\MuhasebeHesabiPointer|null
     */
    public function getMuhasebeKodu()
    {
        return $this->MuhasebeKodu;
    }
    /**
     * Set MuhasebeKodu value
     * @param \StructType\MuhasebeHesabiPointer $muhasebeKodu
     * @return \StructType\KasaHesabi
     */
    public function setMuhasebeKodu(\StructType\MuhasebeHesabiPointer $muhasebeKodu = null)
    {
        $this->MuhasebeKodu = $muhasebeKodu;
        return $this;
    }
    /**
     * Get MuhasebeHesapSablonu value
     * @return \StructType\KasaMuhasebeHesapSablonuPointer|null
     */
    public function getMuhasebeHesapSablonu()
    {
        return $this->MuhasebeHesapSablonu;
    }
    /**
     * Set MuhasebeHesapSablonu value
     * @param \StructType\KasaMuhasebeHesapSablonuPointer $muhasebeHesapSablonu
     * @return \StructType\KasaHesabi
     */
    public function setMuhasebeHesapSablonu(\StructType\KasaMuhasebeHesapSablonuPointer $muhasebeHesapSablonu = null)
    {
        $this->MuhasebeHesapSablonu = $muhasebeHesapSablonu;
        return $this;
    }
    /**
     * Get Bakiyeler value
     * @return \ArrayType\ArrayOfKasaHesabiBakiye|null
     */
    public function getBakiyeler()
    {
        return $this->Bakiyeler;
    }
    /**
     * Set Bakiyeler value
     * @param \ArrayType\ArrayOfKasaHesabiBakiye $bakiyeler
     * @return \StructType\KasaHesabi
     */
    public function setBakiyeler(\ArrayType\ArrayOfKasaHesabiBakiye $bakiyeler = null)
    {
        $this->Bakiyeler = $bakiyeler;
        return $this;
    }
    /**
     * Get ReferansYetki value
     * @return \StructType\YetkiPointer|null
     */
    public function getReferansYetki()
    {
        return $this->ReferansYetki;
    }
    /**
     * Set ReferansYetki value
     * @param \StructType\YetkiPointer $referansYetki
     * @return \StructType\KasaHesabi
     */
    public function setReferansYetki(\StructType\YetkiPointer $referansYetki = null)
    {
        $this->ReferansYetki = $referansYetki;
        return $this;
    }
}
