<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for KWebCari StructType
 * @subpackage Structs
 */
class KWebCari extends Entity
{
    /**
     * The TelValidasyon
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $TelValidasyon;
    /**
     * The CarininGelisSekli
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $CarininGelisSekli;
    /**
     * The IsYonlendirmeGormus
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsYonlendirmeGormus;
    /**
     * The AliciCariAdi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AliciCariAdi;
    /**
     * The AliciAdresi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AliciAdresi;
    /**
     * The ForceIlIlceOku
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $ForceIlIlceOku;
    /**
     * The LojistikCariSevkAdresiObjId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $LojistikCariSevkAdresiObjId;
    /**
     * The LojistikCariSevkAktarimTuru
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $LojistikCariSevkAktarimTuru;
    /**
     * The BilgiTipi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $BilgiTipi;
    /**
     * The GonderenCari
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\KCari
     */
    public $GonderenCari;
    /**
     * The SerendipAliciCari
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\KCari
     */
    public $SerendipAliciCari;
    /**
     * The SerendipAliciCariAdresi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\KAdres
     */
    public $SerendipAliciCariAdresi;
    /**
     * The Il
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\KInterland
     */
    public $Il;
    /**
     * The IlAdi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IlAdi;
    /**
     * The Ilce
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\KInterland
     */
    public $Ilce;
    /**
     * The IlceAdi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IlceAdi;
    /**
     * The Mahalle
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\KInterland
     */
    public $Mahalle;
    /**
     * The MahalleAdi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MahalleAdi;
    /**
     * The Cadde
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\KInterland
     */
    public $Cadde;
    /**
     * The CaddeAdi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CaddeAdi;
    /**
     * The Sokak
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\KInterland
     */
    public $Sokak;
    /**
     * The SokakAdi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SokakAdi;
    /**
     * The Adres
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Adres;
    /**
     * The SadeceAdresTextBox
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SadeceAdresTextBox;
    /**
     * The CepTel
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CepTel;
    /**
     * The IsTel
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IsTel;
    /**
     * The EvTel
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EvTel;
    /**
     * The Email
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Email;
    /**
     * The VergiDaire
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $VergiDaire;
    /**
     * The VergiNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $VergiNo;
    /**
     * The Unvan
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Unvan;
    /**
     * The AliciKodu
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AliciKodu;
    /**
     * The BayiNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BayiNo;
    /**
     * The Kullanici
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\KWebKullanici
     */
    public $Kullanici;
    /**
     * The LojistikSirketKodu
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LojistikSirketKodu;
    /**
     * The XCoor
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $XCoor;
    /**
     * The YCoor
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $YCoor;
    /**
     * The TespitTipi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TespitTipi;
    /**
     * The VarisMerkezi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $VarisMerkezi;
    /**
     * The KapiNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $KapiNo;
    /**
     * The HaneNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $HaneNo;
    /**
     * The Kat
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Kat;
    /**
     * The Blok
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Blok;
    /**
     * The VarisSubeObjId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $VarisSubeObjId;
    /**
     * The NoktaAdi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NoktaAdi;
    /**
     * The KargoSubesi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\KSube
     */
    public $KargoSubesi;
    /**
     * Constructor method for KWebCari
     * @uses KWebCari::setTelValidasyon()
     * @uses KWebCari::setCarininGelisSekli()
     * @uses KWebCari::setIsYonlendirmeGormus()
     * @uses KWebCari::setAliciCariAdi()
     * @uses KWebCari::setAliciAdresi()
     * @uses KWebCari::setForceIlIlceOku()
     * @uses KWebCari::setLojistikCariSevkAdresiObjId()
     * @uses KWebCari::setLojistikCariSevkAktarimTuru()
     * @uses KWebCari::setBilgiTipi()
     * @uses KWebCari::setGonderenCari()
     * @uses KWebCari::setSerendipAliciCari()
     * @uses KWebCari::setSerendipAliciCariAdresi()
     * @uses KWebCari::setIl()
     * @uses KWebCari::setIlAdi()
     * @uses KWebCari::setIlce()
     * @uses KWebCari::setIlceAdi()
     * @uses KWebCari::setMahalle()
     * @uses KWebCari::setMahalleAdi()
     * @uses KWebCari::setCadde()
     * @uses KWebCari::setCaddeAdi()
     * @uses KWebCari::setSokak()
     * @uses KWebCari::setSokakAdi()
     * @uses KWebCari::setAdres()
     * @uses KWebCari::setSadeceAdresTextBox()
     * @uses KWebCari::setCepTel()
     * @uses KWebCari::setIsTel()
     * @uses KWebCari::setEvTel()
     * @uses KWebCari::setEmail()
     * @uses KWebCari::setVergiDaire()
     * @uses KWebCari::setVergiNo()
     * @uses KWebCari::setUnvan()
     * @uses KWebCari::setAliciKodu()
     * @uses KWebCari::setBayiNo()
     * @uses KWebCari::setKullanici()
     * @uses KWebCari::setLojistikSirketKodu()
     * @uses KWebCari::setXCoor()
     * @uses KWebCari::setYCoor()
     * @uses KWebCari::setTespitTipi()
     * @uses KWebCari::setVarisMerkezi()
     * @uses KWebCari::setKapiNo()
     * @uses KWebCari::setHaneNo()
     * @uses KWebCari::setKat()
     * @uses KWebCari::setBlok()
     * @uses KWebCari::setVarisSubeObjId()
     * @uses KWebCari::setNoktaAdi()
     * @uses KWebCari::setKargoSubesi()
     * @param bool $telValidasyon
     * @param string $carininGelisSekli
     * @param bool $isYonlendirmeGormus
     * @param int $aliciCariAdi
     * @param int $aliciAdresi
     * @param bool $forceIlIlceOku
     * @param int $lojistikCariSevkAdresiObjId
     * @param int $lojistikCariSevkAktarimTuru
     * @param int $bilgiTipi
     * @param \StructType\KCari $gonderenCari
     * @param \StructType\KCari $serendipAliciCari
     * @param \StructType\KAdres $serendipAliciCariAdresi
     * @param \StructType\KInterland $il
     * @param string $ilAdi
     * @param \StructType\KInterland $ilce
     * @param string $ilceAdi
     * @param \StructType\KInterland $mahalle
     * @param string $mahalleAdi
     * @param \StructType\KInterland $cadde
     * @param string $caddeAdi
     * @param \StructType\KInterland $sokak
     * @param string $sokakAdi
     * @param string $adres
     * @param string $sadeceAdresTextBox
     * @param string $cepTel
     * @param string $isTel
     * @param string $evTel
     * @param string $email
     * @param string $vergiDaire
     * @param string $vergiNo
     * @param string $unvan
     * @param string $aliciKodu
     * @param string $bayiNo
     * @param \StructType\KWebKullanici $kullanici
     * @param string $lojistikSirketKodu
     * @param string $xCoor
     * @param string $yCoor
     * @param string $tespitTipi
     * @param string $varisMerkezi
     * @param string $kapiNo
     * @param string $haneNo
     * @param string $kat
     * @param string $blok
     * @param string $varisSubeObjId
     * @param string $noktaAdi
     * @param \StructType\KSube $kargoSubesi
     */
    public function __construct($telValidasyon = null, $carininGelisSekli = null, $isYonlendirmeGormus = null, $aliciCariAdi = null, $aliciAdresi = null, $forceIlIlceOku = null, $lojistikCariSevkAdresiObjId = null, $lojistikCariSevkAktarimTuru = null, $bilgiTipi = null, \StructType\KCari $gonderenCari = null, \StructType\KCari $serendipAliciCari = null, \StructType\KAdres $serendipAliciCariAdresi = null, \StructType\KInterland $il = null, $ilAdi = null, \StructType\KInterland $ilce = null, $ilceAdi = null, \StructType\KInterland $mahalle = null, $mahalleAdi = null, \StructType\KInterland $cadde = null, $caddeAdi = null, \StructType\KInterland $sokak = null, $sokakAdi = null, $adres = null, $sadeceAdresTextBox = null, $cepTel = null, $isTel = null, $evTel = null, $email = null, $vergiDaire = null, $vergiNo = null, $unvan = null, $aliciKodu = null, $bayiNo = null, \StructType\KWebKullanici $kullanici = null, $lojistikSirketKodu = null, $xCoor = null, $yCoor = null, $tespitTipi = null, $varisMerkezi = null, $kapiNo = null, $haneNo = null, $kat = null, $blok = null, $varisSubeObjId = null, $noktaAdi = null, \StructType\KSube $kargoSubesi = null)
    {
        $this
            ->setTelValidasyon($telValidasyon)
            ->setCarininGelisSekli($carininGelisSekli)
            ->setIsYonlendirmeGormus($isYonlendirmeGormus)
            ->setAliciCariAdi($aliciCariAdi)
            ->setAliciAdresi($aliciAdresi)
            ->setForceIlIlceOku($forceIlIlceOku)
            ->setLojistikCariSevkAdresiObjId($lojistikCariSevkAdresiObjId)
            ->setLojistikCariSevkAktarimTuru($lojistikCariSevkAktarimTuru)
            ->setBilgiTipi($bilgiTipi)
            ->setGonderenCari($gonderenCari)
            ->setSerendipAliciCari($serendipAliciCari)
            ->setSerendipAliciCariAdresi($serendipAliciCariAdresi)
            ->setIl($il)
            ->setIlAdi($ilAdi)
            ->setIlce($ilce)
            ->setIlceAdi($ilceAdi)
            ->setMahalle($mahalle)
            ->setMahalleAdi($mahalleAdi)
            ->setCadde($cadde)
            ->setCaddeAdi($caddeAdi)
            ->setSokak($sokak)
            ->setSokakAdi($sokakAdi)
            ->setAdres($adres)
            ->setSadeceAdresTextBox($sadeceAdresTextBox)
            ->setCepTel($cepTel)
            ->setIsTel($isTel)
            ->setEvTel($evTel)
            ->setEmail($email)
            ->setVergiDaire($vergiDaire)
            ->setVergiNo($vergiNo)
            ->setUnvan($unvan)
            ->setAliciKodu($aliciKodu)
            ->setBayiNo($bayiNo)
            ->setKullanici($kullanici)
            ->setLojistikSirketKodu($lojistikSirketKodu)
            ->setXCoor($xCoor)
            ->setYCoor($yCoor)
            ->setTespitTipi($tespitTipi)
            ->setVarisMerkezi($varisMerkezi)
            ->setKapiNo($kapiNo)
            ->setHaneNo($haneNo)
            ->setKat($kat)
            ->setBlok($blok)
            ->setVarisSubeObjId($varisSubeObjId)
            ->setNoktaAdi($noktaAdi)
            ->setKargoSubesi($kargoSubesi);
    }
    /**
     * Get TelValidasyon value
     * @return bool
     */
    public function getTelValidasyon()
    {
        return $this->TelValidasyon;
    }
    /**
     * Set TelValidasyon value
     * @param bool $telValidasyon
     * @return \StructType\KWebCari
     */
    public function setTelValidasyon($telValidasyon = null)
    {
        // validation for constraint: boolean
        if (!is_null($telValidasyon) && !is_bool($telValidasyon)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($telValidasyon, true), gettype($telValidasyon)), __LINE__);
        }
        $this->TelValidasyon = $telValidasyon;
        return $this;
    }
    /**
     * Get CarininGelisSekli value
     * @return string
     */
    public function getCarininGelisSekli()
    {
        return $this->CarininGelisSekli;
    }
    /**
     * Set CarininGelisSekli value
     * @uses \EnumType\KWebCarininGelisSekli::valueIsValid()
     * @uses \EnumType\KWebCarininGelisSekli::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $carininGelisSekli
     * @return \StructType\KWebCari
     */
    public function setCarininGelisSekli($carininGelisSekli = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\KWebCarininGelisSekli::valueIsValid($carininGelisSekli)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\KWebCarininGelisSekli', is_array($carininGelisSekli) ? implode(', ', $carininGelisSekli) : var_export($carininGelisSekli, true), implode(', ', \EnumType\KWebCarininGelisSekli::getValidValues())), __LINE__);
        }
        $this->CarininGelisSekli = $carininGelisSekli;
        return $this;
    }
    /**
     * Get IsYonlendirmeGormus value
     * @return bool
     */
    public function getIsYonlendirmeGormus()
    {
        return $this->IsYonlendirmeGormus;
    }
    /**
     * Set IsYonlendirmeGormus value
     * @param bool $isYonlendirmeGormus
     * @return \StructType\KWebCari
     */
    public function setIsYonlendirmeGormus($isYonlendirmeGormus = null)
    {
        // validation for constraint: boolean
        if (!is_null($isYonlendirmeGormus) && !is_bool($isYonlendirmeGormus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isYonlendirmeGormus, true), gettype($isYonlendirmeGormus)), __LINE__);
        }
        $this->IsYonlendirmeGormus = $isYonlendirmeGormus;
        return $this;
    }
    /**
     * Get AliciCariAdi value
     * @return int
     */
    public function getAliciCariAdi()
    {
        return $this->AliciCariAdi;
    }
    /**
     * Set AliciCariAdi value
     * @param int $aliciCariAdi
     * @return \StructType\KWebCari
     */
    public function setAliciCariAdi($aliciCariAdi = null)
    {
        // validation for constraint: int
        if (!is_null($aliciCariAdi) && !(is_int($aliciCariAdi) || ctype_digit($aliciCariAdi))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($aliciCariAdi, true), gettype($aliciCariAdi)), __LINE__);
        }
        $this->AliciCariAdi = $aliciCariAdi;
        return $this;
    }
    /**
     * Get AliciAdresi value
     * @return int
     */
    public function getAliciAdresi()
    {
        return $this->AliciAdresi;
    }
    /**
     * Set AliciAdresi value
     * @param int $aliciAdresi
     * @return \StructType\KWebCari
     */
    public function setAliciAdresi($aliciAdresi = null)
    {
        // validation for constraint: int
        if (!is_null($aliciAdresi) && !(is_int($aliciAdresi) || ctype_digit($aliciAdresi))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($aliciAdresi, true), gettype($aliciAdresi)), __LINE__);
        }
        $this->AliciAdresi = $aliciAdresi;
        return $this;
    }
    /**
     * Get ForceIlIlceOku value
     * @return bool
     */
    public function getForceIlIlceOku()
    {
        return $this->ForceIlIlceOku;
    }
    /**
     * Set ForceIlIlceOku value
     * @param bool $forceIlIlceOku
     * @return \StructType\KWebCari
     */
    public function setForceIlIlceOku($forceIlIlceOku = null)
    {
        // validation for constraint: boolean
        if (!is_null($forceIlIlceOku) && !is_bool($forceIlIlceOku)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($forceIlIlceOku, true), gettype($forceIlIlceOku)), __LINE__);
        }
        $this->ForceIlIlceOku = $forceIlIlceOku;
        return $this;
    }
    /**
     * Get LojistikCariSevkAdresiObjId value
     * @return int
     */
    public function getLojistikCariSevkAdresiObjId()
    {
        return $this->LojistikCariSevkAdresiObjId;
    }
    /**
     * Set LojistikCariSevkAdresiObjId value
     * @param int $lojistikCariSevkAdresiObjId
     * @return \StructType\KWebCari
     */
    public function setLojistikCariSevkAdresiObjId($lojistikCariSevkAdresiObjId = null)
    {
        // validation for constraint: int
        if (!is_null($lojistikCariSevkAdresiObjId) && !(is_int($lojistikCariSevkAdresiObjId) || ctype_digit($lojistikCariSevkAdresiObjId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($lojistikCariSevkAdresiObjId, true), gettype($lojistikCariSevkAdresiObjId)), __LINE__);
        }
        $this->LojistikCariSevkAdresiObjId = $lojistikCariSevkAdresiObjId;
        return $this;
    }
    /**
     * Get LojistikCariSevkAktarimTuru value
     * @return int
     */
    public function getLojistikCariSevkAktarimTuru()
    {
        return $this->LojistikCariSevkAktarimTuru;
    }
    /**
     * Set LojistikCariSevkAktarimTuru value
     * @param int $lojistikCariSevkAktarimTuru
     * @return \StructType\KWebCari
     */
    public function setLojistikCariSevkAktarimTuru($lojistikCariSevkAktarimTuru = null)
    {
        // validation for constraint: int
        if (!is_null($lojistikCariSevkAktarimTuru) && !(is_int($lojistikCariSevkAktarimTuru) || ctype_digit($lojistikCariSevkAktarimTuru))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($lojistikCariSevkAktarimTuru, true), gettype($lojistikCariSevkAktarimTuru)), __LINE__);
        }
        $this->LojistikCariSevkAktarimTuru = $lojistikCariSevkAktarimTuru;
        return $this;
    }
    /**
     * Get BilgiTipi value
     * @return int
     */
    public function getBilgiTipi()
    {
        return $this->BilgiTipi;
    }
    /**
     * Set BilgiTipi value
     * @param int $bilgiTipi
     * @return \StructType\KWebCari
     */
    public function setBilgiTipi($bilgiTipi = null)
    {
        // validation for constraint: int
        if (!is_null($bilgiTipi) && !(is_int($bilgiTipi) || ctype_digit($bilgiTipi))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($bilgiTipi, true), gettype($bilgiTipi)), __LINE__);
        }
        $this->BilgiTipi = $bilgiTipi;
        return $this;
    }
    /**
     * Get GonderenCari value
     * @return \StructType\KCari|null
     */
    public function getGonderenCari()
    {
        return $this->GonderenCari;
    }
    /**
     * Set GonderenCari value
     * @param \StructType\KCari $gonderenCari
     * @return \StructType\KWebCari
     */
    public function setGonderenCari(\StructType\KCari $gonderenCari = null)
    {
        $this->GonderenCari = $gonderenCari;
        return $this;
    }
    /**
     * Get SerendipAliciCari value
     * @return \StructType\KCari|null
     */
    public function getSerendipAliciCari()
    {
        return $this->SerendipAliciCari;
    }
    /**
     * Set SerendipAliciCari value
     * @param \StructType\KCari $serendipAliciCari
     * @return \StructType\KWebCari
     */
    public function setSerendipAliciCari(\StructType\KCari $serendipAliciCari = null)
    {
        $this->SerendipAliciCari = $serendipAliciCari;
        return $this;
    }
    /**
     * Get SerendipAliciCariAdresi value
     * @return \StructType\KAdres|null
     */
    public function getSerendipAliciCariAdresi()
    {
        return $this->SerendipAliciCariAdresi;
    }
    /**
     * Set SerendipAliciCariAdresi value
     * @param \StructType\KAdres $serendipAliciCariAdresi
     * @return \StructType\KWebCari
     */
    public function setSerendipAliciCariAdresi(\StructType\KAdres $serendipAliciCariAdresi = null)
    {
        $this->SerendipAliciCariAdresi = $serendipAliciCariAdresi;
        return $this;
    }
    /**
     * Get Il value
     * @return \StructType\KInterland|null
     */
    public function getIl()
    {
        return $this->Il;
    }
    /**
     * Set Il value
     * @param \StructType\KInterland $il
     * @return \StructType\KWebCari
     */
    public function setIl(\StructType\KInterland $il = null)
    {
        $this->Il = $il;
        return $this;
    }
    /**
     * Get IlAdi value
     * @return string|null
     */
    public function getIlAdi()
    {
        return $this->IlAdi;
    }
    /**
     * Set IlAdi value
     * @param string $ilAdi
     * @return \StructType\KWebCari
     */
    public function setIlAdi($ilAdi = null)
    {
        // validation for constraint: string
        if (!is_null($ilAdi) && !is_string($ilAdi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ilAdi, true), gettype($ilAdi)), __LINE__);
        }
        $this->IlAdi = $ilAdi;
        return $this;
    }
    /**
     * Get Ilce value
     * @return \StructType\KInterland|null
     */
    public function getIlce()
    {
        return $this->Ilce;
    }
    /**
     * Set Ilce value
     * @param \StructType\KInterland $ilce
     * @return \StructType\KWebCari
     */
    public function setIlce(\StructType\KInterland $ilce = null)
    {
        $this->Ilce = $ilce;
        return $this;
    }
    /**
     * Get IlceAdi value
     * @return string|null
     */
    public function getIlceAdi()
    {
        return $this->IlceAdi;
    }
    /**
     * Set IlceAdi value
     * @param string $ilceAdi
     * @return \StructType\KWebCari
     */
    public function setIlceAdi($ilceAdi = null)
    {
        // validation for constraint: string
        if (!is_null($ilceAdi) && !is_string($ilceAdi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ilceAdi, true), gettype($ilceAdi)), __LINE__);
        }
        $this->IlceAdi = $ilceAdi;
        return $this;
    }
    /**
     * Get Mahalle value
     * @return \StructType\KInterland|null
     */
    public function getMahalle()
    {
        return $this->Mahalle;
    }
    /**
     * Set Mahalle value
     * @param \StructType\KInterland $mahalle
     * @return \StructType\KWebCari
     */
    public function setMahalle(\StructType\KInterland $mahalle = null)
    {
        $this->Mahalle = $mahalle;
        return $this;
    }
    /**
     * Get MahalleAdi value
     * @return string|null
     */
    public function getMahalleAdi()
    {
        return $this->MahalleAdi;
    }
    /**
     * Set MahalleAdi value
     * @param string $mahalleAdi
     * @return \StructType\KWebCari
     */
    public function setMahalleAdi($mahalleAdi = null)
    {
        // validation for constraint: string
        if (!is_null($mahalleAdi) && !is_string($mahalleAdi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mahalleAdi, true), gettype($mahalleAdi)), __LINE__);
        }
        $this->MahalleAdi = $mahalleAdi;
        return $this;
    }
    /**
     * Get Cadde value
     * @return \StructType\KInterland|null
     */
    public function getCadde()
    {
        return $this->Cadde;
    }
    /**
     * Set Cadde value
     * @param \StructType\KInterland $cadde
     * @return \StructType\KWebCari
     */
    public function setCadde(\StructType\KInterland $cadde = null)
    {
        $this->Cadde = $cadde;
        return $this;
    }
    /**
     * Get CaddeAdi value
     * @return string|null
     */
    public function getCaddeAdi()
    {
        return $this->CaddeAdi;
    }
    /**
     * Set CaddeAdi value
     * @param string $caddeAdi
     * @return \StructType\KWebCari
     */
    public function setCaddeAdi($caddeAdi = null)
    {
        // validation for constraint: string
        if (!is_null($caddeAdi) && !is_string($caddeAdi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($caddeAdi, true), gettype($caddeAdi)), __LINE__);
        }
        $this->CaddeAdi = $caddeAdi;
        return $this;
    }
    /**
     * Get Sokak value
     * @return \StructType\KInterland|null
     */
    public function getSokak()
    {
        return $this->Sokak;
    }
    /**
     * Set Sokak value
     * @param \StructType\KInterland $sokak
     * @return \StructType\KWebCari
     */
    public function setSokak(\StructType\KInterland $sokak = null)
    {
        $this->Sokak = $sokak;
        return $this;
    }
    /**
     * Get SokakAdi value
     * @return string|null
     */
    public function getSokakAdi()
    {
        return $this->SokakAdi;
    }
    /**
     * Set SokakAdi value
     * @param string $sokakAdi
     * @return \StructType\KWebCari
     */
    public function setSokakAdi($sokakAdi = null)
    {
        // validation for constraint: string
        if (!is_null($sokakAdi) && !is_string($sokakAdi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sokakAdi, true), gettype($sokakAdi)), __LINE__);
        }
        $this->SokakAdi = $sokakAdi;
        return $this;
    }
    /**
     * Get Adres value
     * @return string|null
     */
    public function getAdres()
    {
        return $this->Adres;
    }
    /**
     * Set Adres value
     * @param string $adres
     * @return \StructType\KWebCari
     */
    public function setAdres($adres = null)
    {
        // validation for constraint: string
        if (!is_null($adres) && !is_string($adres)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($adres, true), gettype($adres)), __LINE__);
        }
        $this->Adres = $adres;
        return $this;
    }
    /**
     * Get SadeceAdresTextBox value
     * @return string|null
     */
    public function getSadeceAdresTextBox()
    {
        return $this->SadeceAdresTextBox;
    }
    /**
     * Set SadeceAdresTextBox value
     * @param string $sadeceAdresTextBox
     * @return \StructType\KWebCari
     */
    public function setSadeceAdresTextBox($sadeceAdresTextBox = null)
    {
        // validation for constraint: string
        if (!is_null($sadeceAdresTextBox) && !is_string($sadeceAdresTextBox)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sadeceAdresTextBox, true), gettype($sadeceAdresTextBox)), __LINE__);
        }
        $this->SadeceAdresTextBox = $sadeceAdresTextBox;
        return $this;
    }
    /**
     * Get CepTel value
     * @return string|null
     */
    public function getCepTel()
    {
        return $this->CepTel;
    }
    /**
     * Set CepTel value
     * @param string $cepTel
     * @return \StructType\KWebCari
     */
    public function setCepTel($cepTel = null)
    {
        // validation for constraint: string
        if (!is_null($cepTel) && !is_string($cepTel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cepTel, true), gettype($cepTel)), __LINE__);
        }
        $this->CepTel = $cepTel;
        return $this;
    }
    /**
     * Get IsTel value
     * @return string|null
     */
    public function getIsTel()
    {
        return $this->IsTel;
    }
    /**
     * Set IsTel value
     * @param string $isTel
     * @return \StructType\KWebCari
     */
    public function setIsTel($isTel = null)
    {
        // validation for constraint: string
        if (!is_null($isTel) && !is_string($isTel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($isTel, true), gettype($isTel)), __LINE__);
        }
        $this->IsTel = $isTel;
        return $this;
    }
    /**
     * Get EvTel value
     * @return string|null
     */
    public function getEvTel()
    {
        return $this->EvTel;
    }
    /**
     * Set EvTel value
     * @param string $evTel
     * @return \StructType\KWebCari
     */
    public function setEvTel($evTel = null)
    {
        // validation for constraint: string
        if (!is_null($evTel) && !is_string($evTel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($evTel, true), gettype($evTel)), __LINE__);
        }
        $this->EvTel = $evTel;
        return $this;
    }
    /**
     * Get Email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->Email;
    }
    /**
     * Set Email value
     * @param string $email
     * @return \StructType\KWebCari
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        $this->Email = $email;
        return $this;
    }
    /**
     * Get VergiDaire value
     * @return string|null
     */
    public function getVergiDaire()
    {
        return $this->VergiDaire;
    }
    /**
     * Set VergiDaire value
     * @param string $vergiDaire
     * @return \StructType\KWebCari
     */
    public function setVergiDaire($vergiDaire = null)
    {
        // validation for constraint: string
        if (!is_null($vergiDaire) && !is_string($vergiDaire)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vergiDaire, true), gettype($vergiDaire)), __LINE__);
        }
        $this->VergiDaire = $vergiDaire;
        return $this;
    }
    /**
     * Get VergiNo value
     * @return string|null
     */
    public function getVergiNo()
    {
        return $this->VergiNo;
    }
    /**
     * Set VergiNo value
     * @param string $vergiNo
     * @return \StructType\KWebCari
     */
    public function setVergiNo($vergiNo = null)
    {
        // validation for constraint: string
        if (!is_null($vergiNo) && !is_string($vergiNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vergiNo, true), gettype($vergiNo)), __LINE__);
        }
        $this->VergiNo = $vergiNo;
        return $this;
    }
    /**
     * Get Unvan value
     * @return string|null
     */
    public function getUnvan()
    {
        return $this->Unvan;
    }
    /**
     * Set Unvan value
     * @param string $unvan
     * @return \StructType\KWebCari
     */
    public function setUnvan($unvan = null)
    {
        // validation for constraint: string
        if (!is_null($unvan) && !is_string($unvan)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($unvan, true), gettype($unvan)), __LINE__);
        }
        $this->Unvan = $unvan;
        return $this;
    }
    /**
     * Get AliciKodu value
     * @return string|null
     */
    public function getAliciKodu()
    {
        return $this->AliciKodu;
    }
    /**
     * Set AliciKodu value
     * @param string $aliciKodu
     * @return \StructType\KWebCari
     */
    public function setAliciKodu($aliciKodu = null)
    {
        // validation for constraint: string
        if (!is_null($aliciKodu) && !is_string($aliciKodu)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aliciKodu, true), gettype($aliciKodu)), __LINE__);
        }
        $this->AliciKodu = $aliciKodu;
        return $this;
    }
    /**
     * Get BayiNo value
     * @return string|null
     */
    public function getBayiNo()
    {
        return $this->BayiNo;
    }
    /**
     * Set BayiNo value
     * @param string $bayiNo
     * @return \StructType\KWebCari
     */
    public function setBayiNo($bayiNo = null)
    {
        // validation for constraint: string
        if (!is_null($bayiNo) && !is_string($bayiNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bayiNo, true), gettype($bayiNo)), __LINE__);
        }
        $this->BayiNo = $bayiNo;
        return $this;
    }
    /**
     * Get Kullanici value
     * @return \StructType\KWebKullanici|null
     */
    public function getKullanici()
    {
        return $this->Kullanici;
    }
    /**
     * Set Kullanici value
     * @param \StructType\KWebKullanici $kullanici
     * @return \StructType\KWebCari
     */
    public function setKullanici(\StructType\KWebKullanici $kullanici = null)
    {
        $this->Kullanici = $kullanici;
        return $this;
    }
    /**
     * Get LojistikSirketKodu value
     * @return string|null
     */
    public function getLojistikSirketKodu()
    {
        return $this->LojistikSirketKodu;
    }
    /**
     * Set LojistikSirketKodu value
     * @param string $lojistikSirketKodu
     * @return \StructType\KWebCari
     */
    public function setLojistikSirketKodu($lojistikSirketKodu = null)
    {
        // validation for constraint: string
        if (!is_null($lojistikSirketKodu) && !is_string($lojistikSirketKodu)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lojistikSirketKodu, true), gettype($lojistikSirketKodu)), __LINE__);
        }
        $this->LojistikSirketKodu = $lojistikSirketKodu;
        return $this;
    }
    /**
     * Get XCoor value
     * @return string|null
     */
    public function getXCoor()
    {
        return $this->XCoor;
    }
    /**
     * Set XCoor value
     * @param string $xCoor
     * @return \StructType\KWebCari
     */
    public function setXCoor($xCoor = null)
    {
        // validation for constraint: string
        if (!is_null($xCoor) && !is_string($xCoor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($xCoor, true), gettype($xCoor)), __LINE__);
        }
        $this->XCoor = $xCoor;
        return $this;
    }
    /**
     * Get YCoor value
     * @return string|null
     */
    public function getYCoor()
    {
        return $this->YCoor;
    }
    /**
     * Set YCoor value
     * @param string $yCoor
     * @return \StructType\KWebCari
     */
    public function setYCoor($yCoor = null)
    {
        // validation for constraint: string
        if (!is_null($yCoor) && !is_string($yCoor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($yCoor, true), gettype($yCoor)), __LINE__);
        }
        $this->YCoor = $yCoor;
        return $this;
    }
    /**
     * Get TespitTipi value
     * @return string|null
     */
    public function getTespitTipi()
    {
        return $this->TespitTipi;
    }
    /**
     * Set TespitTipi value
     * @param string $tespitTipi
     * @return \StructType\KWebCari
     */
    public function setTespitTipi($tespitTipi = null)
    {
        // validation for constraint: string
        if (!is_null($tespitTipi) && !is_string($tespitTipi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tespitTipi, true), gettype($tespitTipi)), __LINE__);
        }
        $this->TespitTipi = $tespitTipi;
        return $this;
    }
    /**
     * Get VarisMerkezi value
     * @return string|null
     */
    public function getVarisMerkezi()
    {
        return $this->VarisMerkezi;
    }
    /**
     * Set VarisMerkezi value
     * @param string $varisMerkezi
     * @return \StructType\KWebCari
     */
    public function setVarisMerkezi($varisMerkezi = null)
    {
        // validation for constraint: string
        if (!is_null($varisMerkezi) && !is_string($varisMerkezi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($varisMerkezi, true), gettype($varisMerkezi)), __LINE__);
        }
        $this->VarisMerkezi = $varisMerkezi;
        return $this;
    }
    /**
     * Get KapiNo value
     * @return string|null
     */
    public function getKapiNo()
    {
        return $this->KapiNo;
    }
    /**
     * Set KapiNo value
     * @param string $kapiNo
     * @return \StructType\KWebCari
     */
    public function setKapiNo($kapiNo = null)
    {
        // validation for constraint: string
        if (!is_null($kapiNo) && !is_string($kapiNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kapiNo, true), gettype($kapiNo)), __LINE__);
        }
        $this->KapiNo = $kapiNo;
        return $this;
    }
    /**
     * Get HaneNo value
     * @return string|null
     */
    public function getHaneNo()
    {
        return $this->HaneNo;
    }
    /**
     * Set HaneNo value
     * @param string $haneNo
     * @return \StructType\KWebCari
     */
    public function setHaneNo($haneNo = null)
    {
        // validation for constraint: string
        if (!is_null($haneNo) && !is_string($haneNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($haneNo, true), gettype($haneNo)), __LINE__);
        }
        $this->HaneNo = $haneNo;
        return $this;
    }
    /**
     * Get Kat value
     * @return string|null
     */
    public function getKat()
    {
        return $this->Kat;
    }
    /**
     * Set Kat value
     * @param string $kat
     * @return \StructType\KWebCari
     */
    public function setKat($kat = null)
    {
        // validation for constraint: string
        if (!is_null($kat) && !is_string($kat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kat, true), gettype($kat)), __LINE__);
        }
        $this->Kat = $kat;
        return $this;
    }
    /**
     * Get Blok value
     * @return string|null
     */
    public function getBlok()
    {
        return $this->Blok;
    }
    /**
     * Set Blok value
     * @param string $blok
     * @return \StructType\KWebCari
     */
    public function setBlok($blok = null)
    {
        // validation for constraint: string
        if (!is_null($blok) && !is_string($blok)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($blok, true), gettype($blok)), __LINE__);
        }
        $this->Blok = $blok;
        return $this;
    }
    /**
     * Get VarisSubeObjId value
     * @return string|null
     */
    public function getVarisSubeObjId()
    {
        return $this->VarisSubeObjId;
    }
    /**
     * Set VarisSubeObjId value
     * @param string $varisSubeObjId
     * @return \StructType\KWebCari
     */
    public function setVarisSubeObjId($varisSubeObjId = null)
    {
        // validation for constraint: string
        if (!is_null($varisSubeObjId) && !is_string($varisSubeObjId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($varisSubeObjId, true), gettype($varisSubeObjId)), __LINE__);
        }
        $this->VarisSubeObjId = $varisSubeObjId;
        return $this;
    }
    /**
     * Get NoktaAdi value
     * @return string|null
     */
    public function getNoktaAdi()
    {
        return $this->NoktaAdi;
    }
    /**
     * Set NoktaAdi value
     * @param string $noktaAdi
     * @return \StructType\KWebCari
     */
    public function setNoktaAdi($noktaAdi = null)
    {
        // validation for constraint: string
        if (!is_null($noktaAdi) && !is_string($noktaAdi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($noktaAdi, true), gettype($noktaAdi)), __LINE__);
        }
        $this->NoktaAdi = $noktaAdi;
        return $this;
    }
    /**
     * Get KargoSubesi value
     * @return \StructType\KSube|null
     */
    public function getKargoSubesi()
    {
        return $this->KargoSubesi;
    }
    /**
     * Set KargoSubesi value
     * @param \StructType\KSube $kargoSubesi
     * @return \StructType\KWebCari
     */
    public function setKargoSubesi(\StructType\KSube $kargoSubesi = null)
    {
        $this->KargoSubesi = $kargoSubesi;
        return $this;
    }
}
