<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Hesap StructType
 * @subpackage Structs
 */
abstract class Hesap extends SerendipEntity
{
    /**
     * The Aciklama
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Aciklama;
    /**
     * The AcanIsYeri
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IsYeriPointer
     */
    public $AcanIsYeri;
    /**
     * The AcanBolum
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\BolumPointer
     */
    public $AcanBolum;
    /**
     * The HesapGrubu
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\NesneGrubu
     */
    public $HesapGrubu;
    /**
     * The Grubu
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\HesapGrubu
     */
    public $Grubu;
    /**
     * The Kodu
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Kodu;
    /**
     * The Adi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Adi;
    /**
     * Constructor method for Hesap
     * @uses Hesap::setAciklama()
     * @uses Hesap::setAcanIsYeri()
     * @uses Hesap::setAcanBolum()
     * @uses Hesap::setHesapGrubu()
     * @uses Hesap::setGrubu()
     * @uses Hesap::setKodu()
     * @uses Hesap::setAdi()
     * @param string $aciklama
     * @param \StructType\IsYeriPointer $acanIsYeri
     * @param \StructType\BolumPointer $acanBolum
     * @param \StructType\NesneGrubu $hesapGrubu
     * @param \StructType\HesapGrubu $grubu
     * @param string $kodu
     * @param string $adi
     */
    public function __construct($aciklama = null, \StructType\IsYeriPointer $acanIsYeri = null, \StructType\BolumPointer $acanBolum = null, \StructType\NesneGrubu $hesapGrubu = null, \StructType\HesapGrubu $grubu = null, $kodu = null, $adi = null)
    {
        $this
            ->setAciklama($aciklama)
            ->setAcanIsYeri($acanIsYeri)
            ->setAcanBolum($acanBolum)
            ->setHesapGrubu($hesapGrubu)
            ->setGrubu($grubu)
            ->setKodu($kodu)
            ->setAdi($adi);
    }
    /**
     * Get Aciklama value
     * @return string|null
     */
    public function getAciklama()
    {
        return $this->Aciklama;
    }
    /**
     * Set Aciklama value
     * @param string $aciklama
     * @return \StructType\Hesap
     */
    public function setAciklama($aciklama = null)
    {
        // validation for constraint: string
        if (!is_null($aciklama) && !is_string($aciklama)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aciklama, true), gettype($aciklama)), __LINE__);
        }
        $this->Aciklama = $aciklama;
        return $this;
    }
    /**
     * Get AcanIsYeri value
     * @return \StructType\IsYeriPointer|null
     */
    public function getAcanIsYeri()
    {
        return $this->AcanIsYeri;
    }
    /**
     * Set AcanIsYeri value
     * @param \StructType\IsYeriPointer $acanIsYeri
     * @return \StructType\Hesap
     */
    public function setAcanIsYeri(\StructType\IsYeriPointer $acanIsYeri = null)
    {
        $this->AcanIsYeri = $acanIsYeri;
        return $this;
    }
    /**
     * Get AcanBolum value
     * @return \StructType\BolumPointer|null
     */
    public function getAcanBolum()
    {
        return $this->AcanBolum;
    }
    /**
     * Set AcanBolum value
     * @param \StructType\BolumPointer $acanBolum
     * @return \StructType\Hesap
     */
    public function setAcanBolum(\StructType\BolumPointer $acanBolum = null)
    {
        $this->AcanBolum = $acanBolum;
        return $this;
    }
    /**
     * Get HesapGrubu value
     * @return \StructType\NesneGrubu|null
     */
    public function getHesapGrubu()
    {
        return $this->HesapGrubu;
    }
    /**
     * Set HesapGrubu value
     * @param \StructType\NesneGrubu $hesapGrubu
     * @return \StructType\Hesap
     */
    public function setHesapGrubu(\StructType\NesneGrubu $hesapGrubu = null)
    {
        $this->HesapGrubu = $hesapGrubu;
        return $this;
    }
    /**
     * Get Grubu value
     * @return \StructType\HesapGrubu|null
     */
    public function getGrubu()
    {
        return $this->Grubu;
    }
    /**
     * Set Grubu value
     * @param \StructType\HesapGrubu $grubu
     * @return \StructType\Hesap
     */
    public function setGrubu(\StructType\HesapGrubu $grubu = null)
    {
        $this->Grubu = $grubu;
        return $this;
    }
    /**
     * Get Kodu value
     * @return string|null
     */
    public function getKodu()
    {
        return $this->Kodu;
    }
    /**
     * Set Kodu value
     * @param string $kodu
     * @return \StructType\Hesap
     */
    public function setKodu($kodu = null)
    {
        // validation for constraint: string
        if (!is_null($kodu) && !is_string($kodu)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kodu, true), gettype($kodu)), __LINE__);
        }
        $this->Kodu = $kodu;
        return $this;
    }
    /**
     * Get Adi value
     * @return string|null
     */
    public function getAdi()
    {
        return $this->Adi;
    }
    /**
     * Set Adi value
     * @param string $adi
     * @return \StructType\Hesap
     */
    public function setAdi($adi = null)
    {
        // validation for constraint: string
        if (!is_null($adi) && !is_string($adi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($adi, true), gettype($adi)), __LINE__);
        }
        $this->Adi = $adi;
        return $this;
    }
}
