<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Belge StructType
 * @subpackage Structs
 */
abstract class Belge extends SerendipEntity
{
    /**
     * The OlusturulmaTarihi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $OlusturulmaTarihi;
    /**
     * The GuncellenmeTarihi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $GuncellenmeTarihi;
    /**
     * The BelgeNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BelgeNo;
    /**
     * The Aciklama
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Aciklama;
    /**
     * The BelgeYeri
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BelgeYeri;
    /**
     * Constructor method for Belge
     * @uses Belge::setOlusturulmaTarihi()
     * @uses Belge::setGuncellenmeTarihi()
     * @uses Belge::setBelgeNo()
     * @uses Belge::setAciklama()
     * @uses Belge::setBelgeYeri()
     * @param string $olusturulmaTarihi
     * @param string $guncellenmeTarihi
     * @param string $belgeNo
     * @param string $aciklama
     * @param string $belgeYeri
     */
    public function __construct($olusturulmaTarihi = null, $guncellenmeTarihi = null, $belgeNo = null, $aciklama = null, $belgeYeri = null)
    {
        $this
            ->setOlusturulmaTarihi($olusturulmaTarihi)
            ->setGuncellenmeTarihi($guncellenmeTarihi)
            ->setBelgeNo($belgeNo)
            ->setAciklama($aciklama)
            ->setBelgeYeri($belgeYeri);
    }
    /**
     * Get OlusturulmaTarihi value
     * @return string
     */
    public function getOlusturulmaTarihi()
    {
        return $this->OlusturulmaTarihi;
    }
    /**
     * Set OlusturulmaTarihi value
     * @param string $olusturulmaTarihi
     * @return \StructType\Belge
     */
    public function setOlusturulmaTarihi($olusturulmaTarihi = null)
    {
        // validation for constraint: string
        if (!is_null($olusturulmaTarihi) && !is_string($olusturulmaTarihi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($olusturulmaTarihi, true), gettype($olusturulmaTarihi)), __LINE__);
        }
        $this->OlusturulmaTarihi = $olusturulmaTarihi;
        return $this;
    }
    /**
     * Get GuncellenmeTarihi value
     * @return string
     */
    public function getGuncellenmeTarihi()
    {
        return $this->GuncellenmeTarihi;
    }
    /**
     * Set GuncellenmeTarihi value
     * @param string $guncellenmeTarihi
     * @return \StructType\Belge
     */
    public function setGuncellenmeTarihi($guncellenmeTarihi = null)
    {
        // validation for constraint: string
        if (!is_null($guncellenmeTarihi) && !is_string($guncellenmeTarihi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($guncellenmeTarihi, true), gettype($guncellenmeTarihi)), __LINE__);
        }
        $this->GuncellenmeTarihi = $guncellenmeTarihi;
        return $this;
    }
    /**
     * Get BelgeNo value
     * @return string|null
     */
    public function getBelgeNo()
    {
        return $this->BelgeNo;
    }
    /**
     * Set BelgeNo value
     * @param string $belgeNo
     * @return \StructType\Belge
     */
    public function setBelgeNo($belgeNo = null)
    {
        // validation for constraint: string
        if (!is_null($belgeNo) && !is_string($belgeNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($belgeNo, true), gettype($belgeNo)), __LINE__);
        }
        $this->BelgeNo = $belgeNo;
        return $this;
    }
    /**
     * Get Aciklama value
     * @return string|null
     */
    public function getAciklama()
    {
        return $this->Aciklama;
    }
    /**
     * Set Aciklama value
     * @param string $aciklama
     * @return \StructType\Belge
     */
    public function setAciklama($aciklama = null)
    {
        // validation for constraint: string
        if (!is_null($aciklama) && !is_string($aciklama)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aciklama, true), gettype($aciklama)), __LINE__);
        }
        $this->Aciklama = $aciklama;
        return $this;
    }
    /**
     * Get BelgeYeri value
     * @return string|null
     */
    public function getBelgeYeri()
    {
        return $this->BelgeYeri;
    }
    /**
     * Set BelgeYeri value
     * @param string $belgeYeri
     * @return \StructType\Belge
     */
    public function setBelgeYeri($belgeYeri = null)
    {
        // validation for constraint: string
        if (!is_null($belgeYeri) && !is_string($belgeYeri)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($belgeYeri, true), gettype($belgeYeri)), __LINE__);
        }
        $this->BelgeYeri = $belgeYeri;
        return $this;
    }
}
