<?php

namespace EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for EntityReadState EnumType
 * @subpackage Enumerations
 */
class EntityReadState extends AbstractStructEnumBase
{
    /**
     * Constant for value 'NotReaded'
     * @return string 'NotReaded'
     */
    const VALUE_NOT_READED = 'NotReaded';
    /**
     * Constant for value 'DescriptionOnly'
     * @return string 'DescriptionOnly'
     */
    const VALUE_DESCRIPTION_ONLY = 'DescriptionOnly';
    /**
     * Constant for value 'EntityOnly'
     * @return string 'EntityOnly'
     */
    const VALUE_ENTITY_ONLY = 'EntityOnly';
    /**
     * Constant for value 'EntityWithDescription'
     * @return string 'EntityWithDescription'
     */
    const VALUE_ENTITY_WITH_DESCRIPTION = 'EntityWithDescription';
    /**
     * Constant for value 'DontRead'
     * @return string 'DontRead'
     */
    const VALUE_DONT_READ = 'DontRead';
    /**
     * Return allowed values
     * @uses self::VALUE_NOT_READED
     * @uses self::VALUE_DESCRIPTION_ONLY
     * @uses self::VALUE_ENTITY_ONLY
     * @uses self::VALUE_ENTITY_WITH_DESCRIPTION
     * @uses self::VALUE_DONT_READ
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NOT_READED,
            self::VALUE_DESCRIPTION_ONLY,
            self::VALUE_ENTITY_ONLY,
            self::VALUE_ENTITY_WITH_DESCRIPTION,
            self::VALUE_DONT_READ,
        );
    }
}
