<?php

namespace Aelia\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GetEnabledDataSet
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Aelia\StructType\GetEnabledDataSet $parameters
     * @return \Aelia\StructType\GetEnabledDataSetResponse|bool
     */
    public function GetEnabledDataSet(\Aelia\StructType\GetEnabledDataSet $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetEnabledDataSet($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetSchemaDataSet
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Aelia\StructType\GetSchemaDataSet $parameters
     * @return \Aelia\StructType\GetSchemaDataSetResponse|bool
     */
    public function GetSchemaDataSet(\Aelia\StructType\GetSchemaDataSet $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetSchemaDataSet($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetDataSet
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Aelia\StructType\GetDataSet $parameters
     * @return \Aelia\StructType\GetDataSetResponse|bool
     */
    public function GetDataSet(\Aelia\StructType\GetDataSet $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetDataSet($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetDataSetChanges
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Aelia\StructType\GetDataSetChanges $parameters
     * @return \Aelia\StructType\GetDataSetChangesResponse|bool
     */
    public function GetDataSetChanges(\Aelia\StructType\GetDataSetChanges $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetDataSetChanges($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Aelia\StructType\GetDataSetChangesResponse|\Aelia\StructType\GetDataSetResponse|\Aelia\StructType\GetEnabledDataSetResponse|\Aelia\StructType\GetSchemaDataSetResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
