<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GetPudoList
     * Meta information extracted from the WSDL
     * - documentation: Get all pudos nearest to a postal address | Get all pudos nearest to a postal address | Get all pudos nearest to a postal address
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetPudoList $parameters
     * @return \StructType\GetPudoListResponse|bool
     */
    public function GetPudoList(\StructType\GetPudoList $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetPudoList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetPudoListByLongLat
     * Meta information extracted from the WSDL
     * - documentation: Get all pudos nearest to a postal address | Get all pudos nearest to a postal address | Get all pudos nearest to a postal address
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetPudoListByLongLat $parameters
     * @return \StructType\GetPudoListByLongLatResponse|bool
     */
    public function GetPudoListByLongLat(\StructType\GetPudoListByLongLat $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetPudoListByLongLat($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetPudoDetails
     * Meta information extracted from the WSDL
     * - documentation: Get properties of pudo by its ID | Get properties of pudo by its ID | Get properties of pudo by its ID
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetPudoDetails $parameters
     * @return \StructType\GetPudoDetailsResponse|bool
     */
    public function GetPudoDetails(\StructType\GetPudoDetails $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetPudoDetails($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GetPudoDetailsResponse|\StructType\GetPudoListByLongLatResponse|\StructType\GetPudoListResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
