<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetPudoDetails StructType
 * @subpackage Structs
 */
class GetPudoDetails extends AbstractStructBase
{
    /**
     * The pudo_id
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $pudo_id;
    /**
     * The carrier
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $carrier;
    /**
     * The key
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $key;
    /**
     * Constructor method for GetPudoDetails
     * @uses GetPudoDetails::setPudo_id()
     * @uses GetPudoDetails::setCarrier()
     * @uses GetPudoDetails::setKey()
     * @param string $pudo_id
     * @param string $carrier
     * @param string $key
     */
    public function __construct($pudo_id = null, $carrier = null, $key = null)
    {
        $this
            ->setPudo_id($pudo_id)
            ->setCarrier($carrier)
            ->setKey($key);
    }
    /**
     * Get pudo_id value
     * @return string|null
     */
    public function getPudo_id()
    {
        return $this->pudo_id;
    }
    /**
     * Set pudo_id value
     * @param string $pudo_id
     * @return \StructType\GetPudoDetails
     */
    public function setPudo_id($pudo_id = null)
    {
        // validation for constraint: string
        if (!is_null($pudo_id) && !is_string($pudo_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pudo_id, true), gettype($pudo_id)), __LINE__);
        }
        $this->pudo_id = $pudo_id;
        return $this;
    }
    /**
     * Get carrier value
     * @return string|null
     */
    public function getCarrier()
    {
        return $this->carrier;
    }
    /**
     * Set carrier value
     * @param string $carrier
     * @return \StructType\GetPudoDetails
     */
    public function setCarrier($carrier = null)
    {
        // validation for constraint: string
        if (!is_null($carrier) && !is_string($carrier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($carrier, true), gettype($carrier)), __LINE__);
        }
        $this->carrier = $carrier;
        return $this;
    }
    /**
     * Get key value
     * @return string|null
     */
    public function getKey()
    {
        return $this->key;
    }
    /**
     * Set key value
     * @param string $key
     * @return \StructType\GetPudoDetails
     */
    public function setKey($key = null)
    {
        // validation for constraint: string
        if (!is_null($key) && !is_string($key)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($key, true), gettype($key)), __LINE__);
        }
        $this->key = $key;
        return $this;
    }
}
