<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetPudoList StructType
 * @subpackage Structs
 */
class GetPudoList extends AbstractStructBase
{
    /**
     * The carrier
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $carrier;
    /**
     * The key
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $key;
    /**
     * The address
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $address;
    /**
     * The zipCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $zipCode;
    /**
     * The city
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $city;
    /**
     * The countrycode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $countrycode;
    /**
     * The requestID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $requestID;
    /**
     * The date_from
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $date_from;
    /**
     * The max_pudo_number
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $max_pudo_number;
    /**
     * The max_distance_search
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $max_distance_search;
    /**
     * The weight
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $weight;
    /**
     * The category
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $category;
    /**
     * The holiday_tolerant
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $holiday_tolerant;
    /**
     * Constructor method for GetPudoList
     * @uses GetPudoList::setCarrier()
     * @uses GetPudoList::setKey()
     * @uses GetPudoList::setAddress()
     * @uses GetPudoList::setZipCode()
     * @uses GetPudoList::setCity()
     * @uses GetPudoList::setCountrycode()
     * @uses GetPudoList::setRequestID()
     * @uses GetPudoList::setDate_from()
     * @uses GetPudoList::setMax_pudo_number()
     * @uses GetPudoList::setMax_distance_search()
     * @uses GetPudoList::setWeight()
     * @uses GetPudoList::setCategory()
     * @uses GetPudoList::setHoliday_tolerant()
     * @param string $carrier
     * @param string $key
     * @param string $address
     * @param string $zipCode
     * @param string $city
     * @param string $countrycode
     * @param string $requestID
     * @param string $date_from
     * @param string $max_pudo_number
     * @param string $max_distance_search
     * @param string $weight
     * @param string $category
     * @param string $holiday_tolerant
     */
    public function __construct($carrier = null, $key = null, $address = null, $zipCode = null, $city = null, $countrycode = null, $requestID = null, $date_from = null, $max_pudo_number = null, $max_distance_search = null, $weight = null, $category = null, $holiday_tolerant = null)
    {
        $this
            ->setCarrier($carrier)
            ->setKey($key)
            ->setAddress($address)
            ->setZipCode($zipCode)
            ->setCity($city)
            ->setCountrycode($countrycode)
            ->setRequestID($requestID)
            ->setDate_from($date_from)
            ->setMax_pudo_number($max_pudo_number)
            ->setMax_distance_search($max_distance_search)
            ->setWeight($weight)
            ->setCategory($category)
            ->setHoliday_tolerant($holiday_tolerant);
    }
    /**
     * Get carrier value
     * @return string|null
     */
    public function getCarrier()
    {
        return $this->carrier;
    }
    /**
     * Set carrier value
     * @param string $carrier
     * @return \StructType\GetPudoList
     */
    public function setCarrier($carrier = null)
    {
        // validation for constraint: string
        if (!is_null($carrier) && !is_string($carrier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($carrier, true), gettype($carrier)), __LINE__);
        }
        $this->carrier = $carrier;
        return $this;
    }
    /**
     * Get key value
     * @return string|null
     */
    public function getKey()
    {
        return $this->key;
    }
    /**
     * Set key value
     * @param string $key
     * @return \StructType\GetPudoList
     */
    public function setKey($key = null)
    {
        // validation for constraint: string
        if (!is_null($key) && !is_string($key)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($key, true), gettype($key)), __LINE__);
        }
        $this->key = $key;
        return $this;
    }
    /**
     * Get address value
     * @return string|null
     */
    public function getAddress()
    {
        return $this->address;
    }
    /**
     * Set address value
     * @param string $address
     * @return \StructType\GetPudoList
     */
    public function setAddress($address = null)
    {
        // validation for constraint: string
        if (!is_null($address) && !is_string($address)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($address, true), gettype($address)), __LINE__);
        }
        $this->address = $address;
        return $this;
    }
    /**
     * Get zipCode value
     * @return string|null
     */
    public function getZipCode()
    {
        return $this->zipCode;
    }
    /**
     * Set zipCode value
     * @param string $zipCode
     * @return \StructType\GetPudoList
     */
    public function setZipCode($zipCode = null)
    {
        // validation for constraint: string
        if (!is_null($zipCode) && !is_string($zipCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($zipCode, true), gettype($zipCode)), __LINE__);
        }
        $this->zipCode = $zipCode;
        return $this;
    }
    /**
     * Get city value
     * @return string|null
     */
    public function getCity()
    {
        return $this->city;
    }
    /**
     * Set city value
     * @param string $city
     * @return \StructType\GetPudoList
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($city, true), gettype($city)), __LINE__);
        }
        $this->city = $city;
        return $this;
    }
    /**
     * Get countrycode value
     * @return string|null
     */
    public function getCountrycode()
    {
        return $this->countrycode;
    }
    /**
     * Set countrycode value
     * @param string $countrycode
     * @return \StructType\GetPudoList
     */
    public function setCountrycode($countrycode = null)
    {
        // validation for constraint: string
        if (!is_null($countrycode) && !is_string($countrycode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($countrycode, true), gettype($countrycode)), __LINE__);
        }
        $this->countrycode = $countrycode;
        return $this;
    }
    /**
     * Get requestID value
     * @return string|null
     */
    public function getRequestID()
    {
        return $this->requestID;
    }
    /**
     * Set requestID value
     * @param string $requestID
     * @return \StructType\GetPudoList
     */
    public function setRequestID($requestID = null)
    {
        // validation for constraint: string
        if (!is_null($requestID) && !is_string($requestID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestID, true), gettype($requestID)), __LINE__);
        }
        $this->requestID = $requestID;
        return $this;
    }
    /**
     * Get date_from value
     * @return string|null
     */
    public function getDate_from()
    {
        return $this->date_from;
    }
    /**
     * Set date_from value
     * @param string $date_from
     * @return \StructType\GetPudoList
     */
    public function setDate_from($date_from = null)
    {
        // validation for constraint: string
        if (!is_null($date_from) && !is_string($date_from)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date_from, true), gettype($date_from)), __LINE__);
        }
        $this->date_from = $date_from;
        return $this;
    }
    /**
     * Get max_pudo_number value
     * @return string|null
     */
    public function getMax_pudo_number()
    {
        return $this->max_pudo_number;
    }
    /**
     * Set max_pudo_number value
     * @param string $max_pudo_number
     * @return \StructType\GetPudoList
     */
    public function setMax_pudo_number($max_pudo_number = null)
    {
        // validation for constraint: string
        if (!is_null($max_pudo_number) && !is_string($max_pudo_number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($max_pudo_number, true), gettype($max_pudo_number)), __LINE__);
        }
        $this->max_pudo_number = $max_pudo_number;
        return $this;
    }
    /**
     * Get max_distance_search value
     * @return string|null
     */
    public function getMax_distance_search()
    {
        return $this->max_distance_search;
    }
    /**
     * Set max_distance_search value
     * @param string $max_distance_search
     * @return \StructType\GetPudoList
     */
    public function setMax_distance_search($max_distance_search = null)
    {
        // validation for constraint: string
        if (!is_null($max_distance_search) && !is_string($max_distance_search)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($max_distance_search, true), gettype($max_distance_search)), __LINE__);
        }
        $this->max_distance_search = $max_distance_search;
        return $this;
    }
    /**
     * Get weight value
     * @return string|null
     */
    public function getWeight()
    {
        return $this->weight;
    }
    /**
     * Set weight value
     * @param string $weight
     * @return \StructType\GetPudoList
     */
    public function setWeight($weight = null)
    {
        // validation for constraint: string
        if (!is_null($weight) && !is_string($weight)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($weight, true), gettype($weight)), __LINE__);
        }
        $this->weight = $weight;
        return $this;
    }
    /**
     * Get category value
     * @return string|null
     */
    public function getCategory()
    {
        return $this->category;
    }
    /**
     * Set category value
     * @param string $category
     * @return \StructType\GetPudoList
     */
    public function setCategory($category = null)
    {
        // validation for constraint: string
        if (!is_null($category) && !is_string($category)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($category, true), gettype($category)), __LINE__);
        }
        $this->category = $category;
        return $this;
    }
    /**
     * Get holiday_tolerant value
     * @return string|null
     */
    public function getHoliday_tolerant()
    {
        return $this->holiday_tolerant;
    }
    /**
     * Set holiday_tolerant value
     * @param string $holiday_tolerant
     * @return \StructType\GetPudoList
     */
    public function setHoliday_tolerant($holiday_tolerant = null)
    {
        // validation for constraint: string
        if (!is_null($holiday_tolerant) && !is_string($holiday_tolerant)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($holiday_tolerant, true), gettype($holiday_tolerant)), __LINE__);
        }
        $this->holiday_tolerant = $holiday_tolerant;
        return $this;
    }
}
