<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WebSiparisKampanya StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:WebSiparisKampanya
 * @subpackage Structs
 */
class WebSiparisKampanya extends AbstractStructBase
{
    /**
     * The KampanyaID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $KampanyaID;
    /**
     * The KampanyaTanim
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $KampanyaTanim;
    /**
     * The KampanyaTipi
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $KampanyaTipi;
    /**
     * The SiparisID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $SiparisID;
    /**
     * The UrunID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $UrunID;
    /**
     * Constructor method for WebSiparisKampanya
     * @uses WebSiparisKampanya::setKampanyaID()
     * @uses WebSiparisKampanya::setKampanyaTanim()
     * @uses WebSiparisKampanya::setKampanyaTipi()
     * @uses WebSiparisKampanya::setSiparisID()
     * @uses WebSiparisKampanya::setUrunID()
     * @param int $kampanyaID
     * @param string $kampanyaTanim
     * @param int $kampanyaTipi
     * @param int $siparisID
     * @param int $urunID
     */
    public function __construct($kampanyaID = null, $kampanyaTanim = null, $kampanyaTipi = null, $siparisID = null, $urunID = null)
    {
        $this
            ->setKampanyaID($kampanyaID)
            ->setKampanyaTanim($kampanyaTanim)
            ->setKampanyaTipi($kampanyaTipi)
            ->setSiparisID($siparisID)
            ->setUrunID($urunID);
    }
    /**
     * Get KampanyaID value
     * @return int|null
     */
    public function getKampanyaID()
    {
        return $this->KampanyaID;
    }
    /**
     * Set KampanyaID value
     * @param int $kampanyaID
     * @return \StructType\WebSiparisKampanya
     */
    public function setKampanyaID($kampanyaID = null)
    {
        // validation for constraint: int
        if (!is_null($kampanyaID) && !(is_int($kampanyaID) || ctype_digit($kampanyaID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($kampanyaID, true), gettype($kampanyaID)), __LINE__);
        }
        $this->KampanyaID = $kampanyaID;
        return $this;
    }
    /**
     * Get KampanyaTanim value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKampanyaTanim()
    {
        return isset($this->KampanyaTanim) ? $this->KampanyaTanim : null;
    }
    /**
     * Set KampanyaTanim value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $kampanyaTanim
     * @return \StructType\WebSiparisKampanya
     */
    public function setKampanyaTanim($kampanyaTanim = null)
    {
        // validation for constraint: string
        if (!is_null($kampanyaTanim) && !is_string($kampanyaTanim)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kampanyaTanim, true), gettype($kampanyaTanim)), __LINE__);
        }
        if (is_null($kampanyaTanim) || (is_array($kampanyaTanim) && empty($kampanyaTanim))) {
            unset($this->KampanyaTanim);
        } else {
            $this->KampanyaTanim = $kampanyaTanim;
        }
        return $this;
    }
    /**
     * Get KampanyaTipi value
     * @return int|null
     */
    public function getKampanyaTipi()
    {
        return $this->KampanyaTipi;
    }
    /**
     * Set KampanyaTipi value
     * @param int $kampanyaTipi
     * @return \StructType\WebSiparisKampanya
     */
    public function setKampanyaTipi($kampanyaTipi = null)
    {
        // validation for constraint: int
        if (!is_null($kampanyaTipi) && !(is_int($kampanyaTipi) || ctype_digit($kampanyaTipi))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($kampanyaTipi, true), gettype($kampanyaTipi)), __LINE__);
        }
        $this->KampanyaTipi = $kampanyaTipi;
        return $this;
    }
    /**
     * Get SiparisID value
     * @return int|null
     */
    public function getSiparisID()
    {
        return $this->SiparisID;
    }
    /**
     * Set SiparisID value
     * @param int $siparisID
     * @return \StructType\WebSiparisKampanya
     */
    public function setSiparisID($siparisID = null)
    {
        // validation for constraint: int
        if (!is_null($siparisID) && !(is_int($siparisID) || ctype_digit($siparisID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($siparisID, true), gettype($siparisID)), __LINE__);
        }
        $this->SiparisID = $siparisID;
        return $this;
    }
    /**
     * Get UrunID value
     * @return int|null
     */
    public function getUrunID()
    {
        return $this->UrunID;
    }
    /**
     * Set UrunID value
     * @param int $urunID
     * @return \StructType\WebSiparisKampanya
     */
    public function setUrunID($urunID = null)
    {
        // validation for constraint: int
        if (!is_null($urunID) && !(is_int($urunID) || ctype_digit($urunID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($urunID, true), gettype($urunID)), __LINE__);
        }
        $this->UrunID = $urunID;
        return $this;
    }
}
