<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetStatementArguments StructType
 * Meta information extracted from the WSDL
 * - type: tns:GetStatementArguments
 * @subpackage Structs
 */
class GetStatementArguments extends GenericArguments
{
    /**
     * The dateFrom
     * @var string
     */
    public $dateFrom;
    /**
     * The dateTo
     * @var string
     */
    public $dateTo;
    /**
     * The serviceId
     * @var int
     */
    public $serviceId;
    /**
     * The onlyTransactionId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $onlyTransactionId;
    /**
     * The parameters
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\GenericParam[]
     */
    public $parameters;
    /**
     * Constructor method for GetStatementArguments
     * @uses GetStatementArguments::setDateFrom()
     * @uses GetStatementArguments::setDateTo()
     * @uses GetStatementArguments::setServiceId()
     * @uses GetStatementArguments::setOnlyTransactionId()
     * @uses GetStatementArguments::setParameters()
     * @param string $dateFrom
     * @param string $dateTo
     * @param int $serviceId
     * @param bool $onlyTransactionId
     * @param \StructType\GenericParam[] $parameters
     */
    public function __construct($dateFrom = null, $dateTo = null, $serviceId = null, $onlyTransactionId = null, array $parameters = array())
    {
        $this
            ->setDateFrom($dateFrom)
            ->setDateTo($dateTo)
            ->setServiceId($serviceId)
            ->setOnlyTransactionId($onlyTransactionId)
            ->setParameters($parameters);
    }
    /**
     * Get dateFrom value
     * @return string|null
     */
    public function getDateFrom()
    {
        return $this->dateFrom;
    }
    /**
     * Set dateFrom value
     * @param string $dateFrom
     * @return \StructType\GetStatementArguments
     */
    public function setDateFrom($dateFrom = null)
    {
        // validation for constraint: string
        if (!is_null($dateFrom) && !is_string($dateFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateFrom, true), gettype($dateFrom)), __LINE__);
        }
        $this->dateFrom = $dateFrom;
        return $this;
    }
    /**
     * Get dateTo value
     * @return string|null
     */
    public function getDateTo()
    {
        return $this->dateTo;
    }
    /**
     * Set dateTo value
     * @param string $dateTo
     * @return \StructType\GetStatementArguments
     */
    public function setDateTo($dateTo = null)
    {
        // validation for constraint: string
        if (!is_null($dateTo) && !is_string($dateTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateTo, true), gettype($dateTo)), __LINE__);
        }
        $this->dateTo = $dateTo;
        return $this;
    }
    /**
     * Get serviceId value
     * @return int|null
     */
    public function getServiceId()
    {
        return $this->serviceId;
    }
    /**
     * Set serviceId value
     * @param int $serviceId
     * @return \StructType\GetStatementArguments
     */
    public function setServiceId($serviceId = null)
    {
        // validation for constraint: int
        if (!is_null($serviceId) && !(is_int($serviceId) || ctype_digit($serviceId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($serviceId, true), gettype($serviceId)), __LINE__);
        }
        $this->serviceId = $serviceId;
        return $this;
    }
    /**
     * Get onlyTransactionId value
     * @return bool|null
     */
    public function getOnlyTransactionId()
    {
        return $this->onlyTransactionId;
    }
    /**
     * Set onlyTransactionId value
     * @param bool $onlyTransactionId
     * @return \StructType\GetStatementArguments
     */
    public function setOnlyTransactionId($onlyTransactionId = null)
    {
        // validation for constraint: boolean
        if (!is_null($onlyTransactionId) && !is_bool($onlyTransactionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($onlyTransactionId, true), gettype($onlyTransactionId)), __LINE__);
        }
        $this->onlyTransactionId = $onlyTransactionId;
        return $this;
    }
    /**
     * Get parameters value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\GenericParam[]|null
     */
    public function getParameters()
    {
        return isset($this->parameters) ? $this->parameters : null;
    }
    /**
     * This method is responsible for validating the values passed to the setParameters method
     * This method is willingly generated in order to preserve the one-line inline validation within the setParameters method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateParametersForArrayConstraintsFromSetParameters(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $getStatementArgumentsParametersItem) {
            // validation for constraint: itemType
            if (!$getStatementArgumentsParametersItem instanceof \StructType\GenericParam) {
                $invalidValues[] = is_object($getStatementArgumentsParametersItem) ? get_class($getStatementArgumentsParametersItem) : sprintf('%s(%s)', gettype($getStatementArgumentsParametersItem), var_export($getStatementArgumentsParametersItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The parameters property can only contain items of type \StructType\GenericParam, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set parameters value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\GenericParam[] $parameters
     * @return \StructType\GetStatementArguments
     */
    public function setParameters(array $parameters = array())
    {
        // validation for constraint: array
        if ('' !== ($parametersArrayErrorMessage = self::validateParametersForArrayConstraintsFromSetParameters($parameters))) {
            throw new \InvalidArgumentException($parametersArrayErrorMessage, __LINE__);
        }
        if (is_null($parameters) || (is_array($parameters) && empty($parameters))) {
            unset($this->parameters);
        } else {
            $this->parameters = $parameters;
        }
        return $this;
    }
    /**
     * Add item to parameters value
     * @throws \InvalidArgumentException
     * @param \StructType\GenericParam $item
     * @return \StructType\GetStatementArguments
     */
    public function addToParameters(\StructType\GenericParam $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\GenericParam) {
            throw new \InvalidArgumentException(sprintf('The parameters property can only contain items of type \StructType\GenericParam, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->parameters[] = $item;
        return $this;
    }
}
