<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GenericParam StructType
 * @subpackage Structs
 */
class GenericParam extends AbstractStructBase
{
    /**
     * The paramKey
     * @var string
     */
    public $paramKey;
    /**
     * The paramValue
     * @var string
     */
    public $paramValue;
    /**
     * Constructor method for GenericParam
     * @uses GenericParam::setParamKey()
     * @uses GenericParam::setParamValue()
     * @param string $paramKey
     * @param string $paramValue
     */
    public function __construct($paramKey = null, $paramValue = null)
    {
        $this
            ->setParamKey($paramKey)
            ->setParamValue($paramValue);
    }
    /**
     * Get paramKey value
     * @return string|null
     */
    public function getParamKey()
    {
        return $this->paramKey;
    }
    /**
     * Set paramKey value
     * @param string $paramKey
     * @return \StructType\GenericParam
     */
    public function setParamKey($paramKey = null)
    {
        // validation for constraint: string
        if (!is_null($paramKey) && !is_string($paramKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paramKey, true), gettype($paramKey)), __LINE__);
        }
        $this->paramKey = $paramKey;
        return $this;
    }
    /**
     * Get paramValue value
     * @return string|null
     */
    public function getParamValue()
    {
        return $this->paramValue;
    }
    /**
     * Set paramValue value
     * @param string $paramValue
     * @return \StructType\GenericParam
     */
    public function setParamValue($paramValue = null)
    {
        // validation for constraint: string
        if (!is_null($paramValue) && !is_string($paramValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paramValue, true), gettype($paramValue)), __LINE__);
        }
        $this->paramValue = $paramValue;
        return $this;
    }
}
