<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GetStatement
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetStatementArguments $arguments
     * @return \StructType\GetStatementResult|bool
     */
    public function GetStatement(\StructType\GetStatementArguments $arguments)
    {
        try {
            $this->setResult($this->getSoapClient()->GetStatement($arguments));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetInformation
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetInformationArguments $arguments
     * @return \StructType\GetInformationResult|bool
     */
    public function GetInformation(\StructType\GetInformationArguments $arguments)
    {
        try {
            $this->setResult($this->getSoapClient()->GetInformation($arguments));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GetInformationResult|\StructType\GetStatementResult
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
