<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PerformTransactionArguments StructType
 * Meta information extracted from the WSDL
 * - type: tns:PerformTransactionArguments
 * @subpackage Structs
 */
class PerformTransactionArguments extends GenericArguments
{
    /**
     * The amount
     * @var int
     */
    public $amount;
    /**
     * The parameters
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\GenericParam[]
     */
    public $parameters;
    /**
     * The serviceId
     * @var int
     */
    public $serviceId;
    /**
     * The transactionId
     * @var int
     */
    public $transactionId;
    /**
     * The transactionTime
     * @var string
     */
    public $transactionTime;
    /**
     * Constructor method for PerformTransactionArguments
     * @uses PerformTransactionArguments::setAmount()
     * @uses PerformTransactionArguments::setParameters()
     * @uses PerformTransactionArguments::setServiceId()
     * @uses PerformTransactionArguments::setTransactionId()
     * @uses PerformTransactionArguments::setTransactionTime()
     * @param int $amount
     * @param \StructType\GenericParam[] $parameters
     * @param int $serviceId
     * @param int $transactionId
     * @param string $transactionTime
     */
    public function __construct($amount = null, array $parameters = array(), $serviceId = null, $transactionId = null, $transactionTime = null)
    {
        $this
            ->setAmount($amount)
            ->setParameters($parameters)
            ->setServiceId($serviceId)
            ->setTransactionId($transactionId)
            ->setTransactionTime($transactionTime);
    }
    /**
     * Get amount value
     * @return int|null
     */
    public function getAmount()
    {
        return $this->amount;
    }
    /**
     * Set amount value
     * @param int $amount
     * @return \StructType\PerformTransactionArguments
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: int
        if (!is_null($amount) && !(is_int($amount) || ctype_digit($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->amount = $amount;
        return $this;
    }
    /**
     * Get parameters value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\GenericParam[]|null
     */
    public function getParameters()
    {
        return isset($this->parameters) ? $this->parameters : null;
    }
    /**
     * This method is responsible for validating the values passed to the setParameters method
     * This method is willingly generated in order to preserve the one-line inline validation within the setParameters method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateParametersForArrayConstraintsFromSetParameters(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $performTransactionArgumentsParametersItem) {
            // validation for constraint: itemType
            if (!$performTransactionArgumentsParametersItem instanceof \StructType\GenericParam) {
                $invalidValues[] = is_object($performTransactionArgumentsParametersItem) ? get_class($performTransactionArgumentsParametersItem) : sprintf('%s(%s)', gettype($performTransactionArgumentsParametersItem), var_export($performTransactionArgumentsParametersItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The parameters property can only contain items of type \StructType\GenericParam, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set parameters value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\GenericParam[] $parameters
     * @return \StructType\PerformTransactionArguments
     */
    public function setParameters(array $parameters = array())
    {
        // validation for constraint: array
        if ('' !== ($parametersArrayErrorMessage = self::validateParametersForArrayConstraintsFromSetParameters($parameters))) {
            throw new \InvalidArgumentException($parametersArrayErrorMessage, __LINE__);
        }
        if (is_null($parameters) || (is_array($parameters) && empty($parameters))) {
            unset($this->parameters);
        } else {
            $this->parameters = $parameters;
        }
        return $this;
    }
    /**
     * Add item to parameters value
     * @throws \InvalidArgumentException
     * @param \StructType\GenericParam $item
     * @return \StructType\PerformTransactionArguments
     */
    public function addToParameters(\StructType\GenericParam $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\GenericParam) {
            throw new \InvalidArgumentException(sprintf('The parameters property can only contain items of type \StructType\GenericParam, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->parameters[] = $item;
        return $this;
    }
    /**
     * Get serviceId value
     * @return int|null
     */
    public function getServiceId()
    {
        return $this->serviceId;
    }
    /**
     * Set serviceId value
     * @param int $serviceId
     * @return \StructType\PerformTransactionArguments
     */
    public function setServiceId($serviceId = null)
    {
        // validation for constraint: int
        if (!is_null($serviceId) && !(is_int($serviceId) || ctype_digit($serviceId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($serviceId, true), gettype($serviceId)), __LINE__);
        }
        $this->serviceId = $serviceId;
        return $this;
    }
    /**
     * Get transactionId value
     * @return int|null
     */
    public function getTransactionId()
    {
        return $this->transactionId;
    }
    /**
     * Set transactionId value
     * @param int $transactionId
     * @return \StructType\PerformTransactionArguments
     */
    public function setTransactionId($transactionId = null)
    {
        // validation for constraint: int
        if (!is_null($transactionId) && !(is_int($transactionId) || ctype_digit($transactionId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($transactionId, true), gettype($transactionId)), __LINE__);
        }
        $this->transactionId = $transactionId;
        return $this;
    }
    /**
     * Get transactionTime value
     * @return string|null
     */
    public function getTransactionTime()
    {
        return $this->transactionTime;
    }
    /**
     * Set transactionTime value
     * @param string $transactionTime
     * @return \StructType\PerformTransactionArguments
     */
    public function setTransactionTime($transactionTime = null)
    {
        // validation for constraint: string
        if (!is_null($transactionTime) && !is_string($transactionTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionTime, true), gettype($transactionTime)), __LINE__);
        }
        $this->transactionTime = $transactionTime;
        return $this;
    }
}
