<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CheckTransactionResult StructType
 * Meta information extracted from the WSDL
 * - type: tns:CheckTransactionResult
 * @subpackage Structs
 */
class CheckTransactionResult extends GenericResult
{
    /**
     * The providerTrnId
     * @var int
     */
    public $providerTrnId;
    /**
     * The transactionState
     * @var int
     */
    public $transactionState;
    /**
     * The transactionStateErrorStatus
     * @var int
     */
    public $transactionStateErrorStatus;
    /**
     * The transactionStateErrorMsg
     * @var string
     */
    public $transactionStateErrorMsg;
    /**
     * Constructor method for CheckTransactionResult
     * @uses CheckTransactionResult::setProviderTrnId()
     * @uses CheckTransactionResult::setTransactionState()
     * @uses CheckTransactionResult::setTransactionStateErrorStatus()
     * @uses CheckTransactionResult::setTransactionStateErrorMsg()
     * @param int $providerTrnId
     * @param int $transactionState
     * @param int $transactionStateErrorStatus
     * @param string $transactionStateErrorMsg
     */
    public function __construct($providerTrnId = null, $transactionState = null, $transactionStateErrorStatus = null, $transactionStateErrorMsg = null)
    {
        $this
            ->setProviderTrnId($providerTrnId)
            ->setTransactionState($transactionState)
            ->setTransactionStateErrorStatus($transactionStateErrorStatus)
            ->setTransactionStateErrorMsg($transactionStateErrorMsg);
    }
    /**
     * Get providerTrnId value
     * @return int|null
     */
    public function getProviderTrnId()
    {
        return $this->providerTrnId;
    }
    /**
     * Set providerTrnId value
     * @param int $providerTrnId
     * @return \StructType\CheckTransactionResult
     */
    public function setProviderTrnId($providerTrnId = null)
    {
        // validation for constraint: int
        if (!is_null($providerTrnId) && !(is_int($providerTrnId) || ctype_digit($providerTrnId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($providerTrnId, true), gettype($providerTrnId)), __LINE__);
        }
        $this->providerTrnId = $providerTrnId;
        return $this;
    }
    /**
     * Get transactionState value
     * @return int|null
     */
    public function getTransactionState()
    {
        return $this->transactionState;
    }
    /**
     * Set transactionState value
     * @param int $transactionState
     * @return \StructType\CheckTransactionResult
     */
    public function setTransactionState($transactionState = null)
    {
        // validation for constraint: int
        if (!is_null($transactionState) && !(is_int($transactionState) || ctype_digit($transactionState))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($transactionState, true), gettype($transactionState)), __LINE__);
        }
        $this->transactionState = $transactionState;
        return $this;
    }
    /**
     * Get transactionStateErrorStatus value
     * @return int|null
     */
    public function getTransactionStateErrorStatus()
    {
        return $this->transactionStateErrorStatus;
    }
    /**
     * Set transactionStateErrorStatus value
     * @param int $transactionStateErrorStatus
     * @return \StructType\CheckTransactionResult
     */
    public function setTransactionStateErrorStatus($transactionStateErrorStatus = null)
    {
        // validation for constraint: int
        if (!is_null($transactionStateErrorStatus) && !(is_int($transactionStateErrorStatus) || ctype_digit($transactionStateErrorStatus))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($transactionStateErrorStatus, true), gettype($transactionStateErrorStatus)), __LINE__);
        }
        $this->transactionStateErrorStatus = $transactionStateErrorStatus;
        return $this;
    }
    /**
     * Get transactionStateErrorMsg value
     * @return string|null
     */
    public function getTransactionStateErrorMsg()
    {
        return $this->transactionStateErrorMsg;
    }
    /**
     * Set transactionStateErrorMsg value
     * @param string $transactionStateErrorMsg
     * @return \StructType\CheckTransactionResult
     */
    public function setTransactionStateErrorMsg($transactionStateErrorMsg = null)
    {
        // validation for constraint: string
        if (!is_null($transactionStateErrorMsg) && !is_string($transactionStateErrorMsg)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionStateErrorMsg, true), gettype($transactionStateErrorMsg)), __LINE__);
        }
        $this->transactionStateErrorMsg = $transactionStateErrorMsg;
        return $this;
    }
}
