<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetStatementResult StructType
 * Meta information extracted from the WSDL
 * - type: tns:GetStatementResult
 * @subpackage Structs
 */
class GetStatementResult extends GenericResult
{
    /**
     * The statements
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\TransactionStatement[]
     */
    public $statements;
    /**
     * Constructor method for GetStatementResult
     * @uses GetStatementResult::setStatements()
     * @param \StructType\TransactionStatement[] $statements
     */
    public function __construct(array $statements = array())
    {
        $this
            ->setStatements($statements);
    }
    /**
     * Get statements value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\TransactionStatement[]|null
     */
    public function getStatements()
    {
        return isset($this->statements) ? $this->statements : null;
    }
    /**
     * This method is responsible for validating the values passed to the setStatements method
     * This method is willingly generated in order to preserve the one-line inline validation within the setStatements method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateStatementsForArrayConstraintsFromSetStatements(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $getStatementResultStatementsItem) {
            // validation for constraint: itemType
            if (!$getStatementResultStatementsItem instanceof \StructType\TransactionStatement) {
                $invalidValues[] = is_object($getStatementResultStatementsItem) ? get_class($getStatementResultStatementsItem) : sprintf('%s(%s)', gettype($getStatementResultStatementsItem), var_export($getStatementResultStatementsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The statements property can only contain items of type \StructType\TransactionStatement, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set statements value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\TransactionStatement[] $statements
     * @return \StructType\GetStatementResult
     */
    public function setStatements(array $statements = array())
    {
        // validation for constraint: array
        if ('' !== ($statementsArrayErrorMessage = self::validateStatementsForArrayConstraintsFromSetStatements($statements))) {
            throw new \InvalidArgumentException($statementsArrayErrorMessage, __LINE__);
        }
        if (is_null($statements) || (is_array($statements) && empty($statements))) {
            unset($this->statements);
        } else {
            $this->statements = $statements;
        }
        return $this;
    }
    /**
     * Add item to statements value
     * @throws \InvalidArgumentException
     * @param \StructType\TransactionStatement $item
     * @return \StructType\GetStatementResult
     */
    public function addToStatements(\StructType\TransactionStatement $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TransactionStatement) {
            throw new \InvalidArgumentException(sprintf('The statements property can only contain items of type \StructType\TransactionStatement, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->statements[] = $item;
        return $this;
    }
}
