<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for KombinUrun StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:KombinUrun
 * @subpackage Structs
 */
class KombinUrun extends AbstractStructBase
{
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Id;
    /**
     * The KombinUrunAktif
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $KombinUrunAktif;
    /**
     * The KombinUrunKartiId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $KombinUrunKartiId;
    /**
     * The KombinUrunKartiTedarikciKodu
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $KombinUrunKartiTedarikciKodu;
    /**
     * The KombinUrunSatinAlinabilir
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $KombinUrunSatinAlinabilir;
    /**
     * The KombinUrunTopluSatinAlinabilir
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $KombinUrunTopluSatinAlinabilir;
    /**
     * The UrunKartiId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $UrunKartiId;
    /**
     * The UrunKartiTedarikciKodu
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UrunKartiTedarikciKodu;
    /**
     * Constructor method for KombinUrun
     * @uses KombinUrun::setId()
     * @uses KombinUrun::setKombinUrunAktif()
     * @uses KombinUrun::setKombinUrunKartiId()
     * @uses KombinUrun::setKombinUrunKartiTedarikciKodu()
     * @uses KombinUrun::setKombinUrunSatinAlinabilir()
     * @uses KombinUrun::setKombinUrunTopluSatinAlinabilir()
     * @uses KombinUrun::setUrunKartiId()
     * @uses KombinUrun::setUrunKartiTedarikciKodu()
     * @param int $id
     * @param bool $kombinUrunAktif
     * @param int $kombinUrunKartiId
     * @param string $kombinUrunKartiTedarikciKodu
     * @param bool $kombinUrunSatinAlinabilir
     * @param bool $kombinUrunTopluSatinAlinabilir
     * @param int $urunKartiId
     * @param string $urunKartiTedarikciKodu
     */
    public function __construct($id = null, $kombinUrunAktif = null, $kombinUrunKartiId = null, $kombinUrunKartiTedarikciKodu = null, $kombinUrunSatinAlinabilir = null, $kombinUrunTopluSatinAlinabilir = null, $urunKartiId = null, $urunKartiTedarikciKodu = null)
    {
        $this
            ->setId($id)
            ->setKombinUrunAktif($kombinUrunAktif)
            ->setKombinUrunKartiId($kombinUrunKartiId)
            ->setKombinUrunKartiTedarikciKodu($kombinUrunKartiTedarikciKodu)
            ->setKombinUrunSatinAlinabilir($kombinUrunSatinAlinabilir)
            ->setKombinUrunTopluSatinAlinabilir($kombinUrunTopluSatinAlinabilir)
            ->setUrunKartiId($urunKartiId)
            ->setUrunKartiTedarikciKodu($urunKartiTedarikciKodu);
    }
    /**
     * Get Id value
     * @return int|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param int $id
     * @return \StructType\KombinUrun
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get KombinUrunAktif value
     * @return bool|null
     */
    public function getKombinUrunAktif()
    {
        return $this->KombinUrunAktif;
    }
    /**
     * Set KombinUrunAktif value
     * @param bool $kombinUrunAktif
     * @return \StructType\KombinUrun
     */
    public function setKombinUrunAktif($kombinUrunAktif = null)
    {
        // validation for constraint: boolean
        if (!is_null($kombinUrunAktif) && !is_bool($kombinUrunAktif)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($kombinUrunAktif, true), gettype($kombinUrunAktif)), __LINE__);
        }
        $this->KombinUrunAktif = $kombinUrunAktif;
        return $this;
    }
    /**
     * Get KombinUrunKartiId value
     * @return int|null
     */
    public function getKombinUrunKartiId()
    {
        return $this->KombinUrunKartiId;
    }
    /**
     * Set KombinUrunKartiId value
     * @param int $kombinUrunKartiId
     * @return \StructType\KombinUrun
     */
    public function setKombinUrunKartiId($kombinUrunKartiId = null)
    {
        // validation for constraint: int
        if (!is_null($kombinUrunKartiId) && !(is_int($kombinUrunKartiId) || ctype_digit($kombinUrunKartiId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($kombinUrunKartiId, true), gettype($kombinUrunKartiId)), __LINE__);
        }
        $this->KombinUrunKartiId = $kombinUrunKartiId;
        return $this;
    }
    /**
     * Get KombinUrunKartiTedarikciKodu value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKombinUrunKartiTedarikciKodu()
    {
        return isset($this->KombinUrunKartiTedarikciKodu) ? $this->KombinUrunKartiTedarikciKodu : null;
    }
    /**
     * Set KombinUrunKartiTedarikciKodu value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $kombinUrunKartiTedarikciKodu
     * @return \StructType\KombinUrun
     */
    public function setKombinUrunKartiTedarikciKodu($kombinUrunKartiTedarikciKodu = null)
    {
        // validation for constraint: string
        if (!is_null($kombinUrunKartiTedarikciKodu) && !is_string($kombinUrunKartiTedarikciKodu)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kombinUrunKartiTedarikciKodu, true), gettype($kombinUrunKartiTedarikciKodu)), __LINE__);
        }
        if (is_null($kombinUrunKartiTedarikciKodu) || (is_array($kombinUrunKartiTedarikciKodu) && empty($kombinUrunKartiTedarikciKodu))) {
            unset($this->KombinUrunKartiTedarikciKodu);
        } else {
            $this->KombinUrunKartiTedarikciKodu = $kombinUrunKartiTedarikciKodu;
        }
        return $this;
    }
    /**
     * Get KombinUrunSatinAlinabilir value
     * @return bool|null
     */
    public function getKombinUrunSatinAlinabilir()
    {
        return $this->KombinUrunSatinAlinabilir;
    }
    /**
     * Set KombinUrunSatinAlinabilir value
     * @param bool $kombinUrunSatinAlinabilir
     * @return \StructType\KombinUrun
     */
    public function setKombinUrunSatinAlinabilir($kombinUrunSatinAlinabilir = null)
    {
        // validation for constraint: boolean
        if (!is_null($kombinUrunSatinAlinabilir) && !is_bool($kombinUrunSatinAlinabilir)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($kombinUrunSatinAlinabilir, true), gettype($kombinUrunSatinAlinabilir)), __LINE__);
        }
        $this->KombinUrunSatinAlinabilir = $kombinUrunSatinAlinabilir;
        return $this;
    }
    /**
     * Get KombinUrunTopluSatinAlinabilir value
     * @return bool|null
     */
    public function getKombinUrunTopluSatinAlinabilir()
    {
        return $this->KombinUrunTopluSatinAlinabilir;
    }
    /**
     * Set KombinUrunTopluSatinAlinabilir value
     * @param bool $kombinUrunTopluSatinAlinabilir
     * @return \StructType\KombinUrun
     */
    public function setKombinUrunTopluSatinAlinabilir($kombinUrunTopluSatinAlinabilir = null)
    {
        // validation for constraint: boolean
        if (!is_null($kombinUrunTopluSatinAlinabilir) && !is_bool($kombinUrunTopluSatinAlinabilir)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($kombinUrunTopluSatinAlinabilir, true), gettype($kombinUrunTopluSatinAlinabilir)), __LINE__);
        }
        $this->KombinUrunTopluSatinAlinabilir = $kombinUrunTopluSatinAlinabilir;
        return $this;
    }
    /**
     * Get UrunKartiId value
     * @return int|null
     */
    public function getUrunKartiId()
    {
        return $this->UrunKartiId;
    }
    /**
     * Set UrunKartiId value
     * @param int $urunKartiId
     * @return \StructType\KombinUrun
     */
    public function setUrunKartiId($urunKartiId = null)
    {
        // validation for constraint: int
        if (!is_null($urunKartiId) && !(is_int($urunKartiId) || ctype_digit($urunKartiId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($urunKartiId, true), gettype($urunKartiId)), __LINE__);
        }
        $this->UrunKartiId = $urunKartiId;
        return $this;
    }
    /**
     * Get UrunKartiTedarikciKodu value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUrunKartiTedarikciKodu()
    {
        return isset($this->UrunKartiTedarikciKodu) ? $this->UrunKartiTedarikciKodu : null;
    }
    /**
     * Set UrunKartiTedarikciKodu value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $urunKartiTedarikciKodu
     * @return \StructType\KombinUrun
     */
    public function setUrunKartiTedarikciKodu($urunKartiTedarikciKodu = null)
    {
        // validation for constraint: string
        if (!is_null($urunKartiTedarikciKodu) && !is_string($urunKartiTedarikciKodu)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($urunKartiTedarikciKodu, true), gettype($urunKartiTedarikciKodu)), __LINE__);
        }
        if (is_null($urunKartiTedarikciKodu) || (is_array($urunKartiTedarikciKodu) && empty($urunKartiTedarikciKodu))) {
            unset($this->UrunKartiTedarikciKodu);
        } else {
            $this->UrunKartiTedarikciKodu = $urunKartiTedarikciKodu;
        }
        return $this;
    }
}
