<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Invia ServiceType
 * @subpackage Services
 */
class Invia extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named InviaMovimentazioneV1
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\InviaMovimentazioneV1 $inviaMovimentazione
     * @return \StructType\InviaMovimentazioneResponseV1|bool
     */
    public function InviaMovimentazioneV1(\StructType\InviaMovimentazioneV1 $inviaMovimentazione)
    {
        try {
            $this->setResult($this->getSoapClient()->InviaMovimentazioneV1($inviaMovimentazione));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named InviaMovimentazioneV2
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\InviaMovimentazione $inviaMovimentazione
     * @return \StructType\InviaMovimentazioneResponse|bool
     */
    public function InviaMovimentazioneV2(\StructType\InviaMovimentazione $inviaMovimentazione)
    {
        try {
            $this->setResult($this->getSoapClient()->InviaMovimentazioneV2($inviaMovimentazione));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\InviaMovimentazioneResponse|\StructType\InviaMovimentazioneResponseV1
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
