<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfArrivoBeanV1 ArrayType
 * @subpackage Arrays
 */
class ArrayOfArrivoBeanV1 extends AbstractStructArrayBase
{
    /**
     * The arrivo
     * Meta information extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ArrivoBeanV1[]
     */
    public $arrivo;
    /**
     * Constructor method for ArrayOfArrivoBeanV1
     * @uses ArrayOfArrivoBeanV1::setArrivo()
     * @param \StructType\ArrivoBeanV1[] $arrivo
     */
    public function __construct(array $arrivo = array())
    {
        $this
            ->setArrivo($arrivo);
    }
    /**
     * Get arrivo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ArrivoBeanV1[]|null
     */
    public function getArrivo()
    {
        return isset($this->arrivo) ? $this->arrivo : null;
    }
    /**
     * This method is responsible for validating the values passed to the setArrivo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setArrivo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateArrivoForArrayConstraintsFromSetArrivo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfArrivoBeanV1ArrivoItem) {
            // validation for constraint: itemType
            if (!$arrayOfArrivoBeanV1ArrivoItem instanceof \StructType\ArrivoBeanV1) {
                $invalidValues[] = is_object($arrayOfArrivoBeanV1ArrivoItem) ? get_class($arrayOfArrivoBeanV1ArrivoItem) : sprintf('%s(%s)', gettype($arrayOfArrivoBeanV1ArrivoItem), var_export($arrayOfArrivoBeanV1ArrivoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The arrivo property can only contain items of type \StructType\ArrivoBeanV1, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set arrivo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ArrivoBeanV1[] $arrivo
     * @return \ArrayType\ArrayOfArrivoBeanV1
     */
    public function setArrivo(array $arrivo = array())
    {
        // validation for constraint: array
        if ('' !== ($arrivoArrayErrorMessage = self::validateArrivoForArrayConstraintsFromSetArrivo($arrivo))) {
            throw new \InvalidArgumentException($arrivoArrayErrorMessage, __LINE__);
        }
        if (is_null($arrivo) || (is_array($arrivo) && empty($arrivo))) {
            unset($this->arrivo);
        } else {
            $this->arrivo = $arrivo;
        }
        return $this;
    }
    /**
     * Add item to arrivo value
     * @throws \InvalidArgumentException
     * @param \StructType\ArrivoBeanV1 $item
     * @return \ArrayType\ArrayOfArrivoBeanV1
     */
    public function addToArrivo(\StructType\ArrivoBeanV1 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ArrivoBeanV1) {
            throw new \InvalidArgumentException(sprintf('The arrivo property can only contain items of type \StructType\ArrivoBeanV1, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->arrivo[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\ArrivoBeanV1|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\ArrivoBeanV1|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\ArrivoBeanV1|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\ArrivoBeanV1|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\ArrivoBeanV1|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string arrivo
     */
    public function getAttributeName()
    {
        return 'arrivo';
    }
}
