<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for xmlImportDatiV1 StructType
 * @subpackage Structs
 */
class XmlImportDatiV1 extends AbstractStructBase
{
    /**
     * The codice
     * Meta information extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $codice;
    /**
     * The prodotto
     * Meta information extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $prodotto;
    /**
     * The movimento
     * Meta information extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\MovimentoBeanV1[]
     */
    public $movimento;
    /**
     * Constructor method for xmlImportDatiV1
     * @uses XmlImportDatiV1::setCodice()
     * @uses XmlImportDatiV1::setProdotto()
     * @uses XmlImportDatiV1::setMovimento()
     * @param string $codice
     * @param string $prodotto
     * @param \StructType\MovimentoBeanV1[] $movimento
     */
    public function __construct($codice = null, $prodotto = null, array $movimento = array())
    {
        $this
            ->setCodice($codice)
            ->setProdotto($prodotto)
            ->setMovimento($movimento);
    }
    /**
     * Get codice value
     * @return string|null
     */
    public function getCodice()
    {
        return $this->codice;
    }
    /**
     * Set codice value
     * @param string $codice
     * @return \StructType\XmlImportDatiV1
     */
    public function setCodice($codice = null)
    {
        // validation for constraint: string
        if (!is_null($codice) && !is_string($codice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codice, true), gettype($codice)), __LINE__);
        }
        $this->codice = $codice;
        return $this;
    }
    /**
     * Get prodotto value
     * @return string|null
     */
    public function getProdotto()
    {
        return $this->prodotto;
    }
    /**
     * Set prodotto value
     * @param string $prodotto
     * @return \StructType\XmlImportDatiV1
     */
    public function setProdotto($prodotto = null)
    {
        // validation for constraint: string
        if (!is_null($prodotto) && !is_string($prodotto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prodotto, true), gettype($prodotto)), __LINE__);
        }
        $this->prodotto = $prodotto;
        return $this;
    }
    /**
     * Get movimento value
     * @return \StructType\MovimentoBeanV1[]|null
     */
    public function getMovimento()
    {
        return $this->movimento;
    }
    /**
     * This method is responsible for validating the values passed to the setMovimento method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMovimento method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMovimentoForArrayConstraintsFromSetMovimento(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $xmlImportDatiV1MovimentoItem) {
            // validation for constraint: itemType
            if (!$xmlImportDatiV1MovimentoItem instanceof \StructType\MovimentoBeanV1) {
                $invalidValues[] = is_object($xmlImportDatiV1MovimentoItem) ? get_class($xmlImportDatiV1MovimentoItem) : sprintf('%s(%s)', gettype($xmlImportDatiV1MovimentoItem), var_export($xmlImportDatiV1MovimentoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The movimento property can only contain items of type \StructType\MovimentoBeanV1, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set movimento value
     * @throws \InvalidArgumentException
     * @param \StructType\MovimentoBeanV1[] $movimento
     * @return \StructType\XmlImportDatiV1
     */
    public function setMovimento(array $movimento = array())
    {
        // validation for constraint: array
        if ('' !== ($movimentoArrayErrorMessage = self::validateMovimentoForArrayConstraintsFromSetMovimento($movimento))) {
            throw new \InvalidArgumentException($movimentoArrayErrorMessage, __LINE__);
        }
        $this->movimento = $movimento;
        return $this;
    }
    /**
     * Add item to movimento value
     * @throws \InvalidArgumentException
     * @param \StructType\MovimentoBeanV1 $item
     * @return \StructType\XmlImportDatiV1
     */
    public function addToMovimento(\StructType\MovimentoBeanV1 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\MovimentoBeanV1) {
            throw new \InvalidArgumentException(sprintf('The movimento property can only contain items of type \StructType\MovimentoBeanV1, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->movimento[] = $item;
        return $this;
    }
}
