<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for rettifiche StructType
 * @subpackage Structs
 */
class Rettifiche extends AbstractStructBase
{
    /**
     * The cancellazione
     * Meta information extracted from the WSDL
     * - choice: cancellazione | conferma | eliminazione
     * - choiceMaxOccurs: unbounded
     * - choiceMinOccurs: 0
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var \StructType\CancellazioneBean
     */
    public $cancellazione;
    /**
     * The conferma
     * Meta information extracted from the WSDL
     * - choice: cancellazione | conferma | eliminazione
     * - choiceMaxOccurs: unbounded
     * - choiceMinOccurs: 0
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var \StructType\ConfermaBean
     */
    public $conferma;
    /**
     * The eliminazione
     * Meta information extracted from the WSDL
     * - choice: cancellazione | conferma | eliminazione
     * - choiceMaxOccurs: unbounded
     * - choiceMinOccurs: 0
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var \StructType\EliminazioneBean
     */
    public $eliminazione;
    /**
     * Constructor method for rettifiche
     * @uses Rettifiche::setCancellazione()
     * @uses Rettifiche::setConferma()
     * @uses Rettifiche::setEliminazione()
     * @param \StructType\CancellazioneBean $cancellazione
     * @param \StructType\ConfermaBean $conferma
     * @param \StructType\EliminazioneBean $eliminazione
     */
    public function __construct(\StructType\CancellazioneBean $cancellazione = null, \StructType\ConfermaBean $conferma = null, \StructType\EliminazioneBean $eliminazione = null)
    {
        $this
            ->setCancellazione($cancellazione)
            ->setConferma($conferma)
            ->setEliminazione($eliminazione);
    }
    /**
     * Get cancellazione value
     * @return \StructType\CancellazioneBean
     */
    public function getCancellazione()
    {
        return isset($this->cancellazione) ? $this->cancellazione : null;
    }
    /**
     * This method is responsible for validating the value passed to the setCancellazione method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCancellazione method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateCancellazioneForChoiceConstraintsFromSetCancellazione($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'conferma',
            'eliminazione',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property cancellazione can\'t be set as the property %s is already set. Only one property must be set among these properties: cancellazione, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set cancellazione value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\CancellazioneBean $cancellazione
     * @return \StructType\Rettifiche
     */
    public function setCancellazione(\StructType\CancellazioneBean $cancellazione = null)
    {
        // validation for constraint: choice(cancellazione, conferma, eliminazione)
        if ('' !== ($cancellazioneChoiceErrorMessage = self::validateCancellazioneForChoiceConstraintsFromSetCancellazione($cancellazione))) {
            throw new \InvalidArgumentException($cancellazioneChoiceErrorMessage, __LINE__);
        }
        if (is_null($cancellazione) || (is_array($cancellazione) && empty($cancellazione))) {
            unset($this->cancellazione);
        } else {
            $this->cancellazione = $cancellazione;
        }
        return $this;
    }
    /**
     * Get conferma value
     * @return \StructType\ConfermaBean
     */
    public function getConferma()
    {
        return isset($this->conferma) ? $this->conferma : null;
    }
    /**
     * This method is responsible for validating the value passed to the setConferma method
     * This method is willingly generated in order to preserve the one-line inline validation within the setConferma method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateConfermaForChoiceConstraintsFromSetConferma($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'cancellazione',
            'eliminazione',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property conferma can\'t be set as the property %s is already set. Only one property must be set among these properties: conferma, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set conferma value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ConfermaBean $conferma
     * @return \StructType\Rettifiche
     */
    public function setConferma(\StructType\ConfermaBean $conferma = null)
    {
        // validation for constraint: choice(cancellazione, conferma, eliminazione)
        if ('' !== ($confermaChoiceErrorMessage = self::validateConfermaForChoiceConstraintsFromSetConferma($conferma))) {
            throw new \InvalidArgumentException($confermaChoiceErrorMessage, __LINE__);
        }
        if (is_null($conferma) || (is_array($conferma) && empty($conferma))) {
            unset($this->conferma);
        } else {
            $this->conferma = $conferma;
        }
        return $this;
    }
    /**
     * Get eliminazione value
     * @return \StructType\EliminazioneBean
     */
    public function getEliminazione()
    {
        return isset($this->eliminazione) ? $this->eliminazione : null;
    }
    /**
     * This method is responsible for validating the value passed to the setEliminazione method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEliminazione method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateEliminazioneForChoiceConstraintsFromSetEliminazione($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'cancellazione',
            'conferma',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property eliminazione can\'t be set as the property %s is already set. Only one property must be set among these properties: eliminazione, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set eliminazione value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\EliminazioneBean $eliminazione
     * @return \StructType\Rettifiche
     */
    public function setEliminazione(\StructType\EliminazioneBean $eliminazione = null)
    {
        // validation for constraint: choice(cancellazione, conferma, eliminazione)
        if ('' !== ($eliminazioneChoiceErrorMessage = self::validateEliminazioneForChoiceConstraintsFromSetEliminazione($eliminazione))) {
            throw new \InvalidArgumentException($eliminazioneChoiceErrorMessage, __LINE__);
        }
        if (is_null($eliminazione) || (is_array($eliminazione) && empty($eliminazione))) {
            unset($this->eliminazione);
        } else {
            $this->eliminazione = $eliminazione;
        }
        return $this;
    }
}
