<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetMensile StructType
 * @subpackage Structs
 */
class GetMensile extends AbstractStructBase
{
    /**
     * The mese
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $mese;
    /**
     * The anno
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $anno;
    /**
     * The idStruttura
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $idStruttura;
    /**
     * Constructor method for GetMensile
     * @uses GetMensile::setMese()
     * @uses GetMensile::setAnno()
     * @uses GetMensile::setIdStruttura()
     * @param int $mese
     * @param int $anno
     * @param int $idStruttura
     */
    public function __construct($mese = null, $anno = null, $idStruttura = null)
    {
        $this
            ->setMese($mese)
            ->setAnno($anno)
            ->setIdStruttura($idStruttura);
    }
    /**
     * Get mese value
     * @return int
     */
    public function getMese()
    {
        return $this->mese;
    }
    /**
     * Set mese value
     * @param int $mese
     * @return \StructType\GetMensile
     */
    public function setMese($mese = null)
    {
        // validation for constraint: int
        if (!is_null($mese) && !(is_int($mese) || ctype_digit($mese))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($mese, true), gettype($mese)), __LINE__);
        }
        $this->mese = $mese;
        return $this;
    }
    /**
     * Get anno value
     * @return int
     */
    public function getAnno()
    {
        return $this->anno;
    }
    /**
     * Set anno value
     * @param int $anno
     * @return \StructType\GetMensile
     */
    public function setAnno($anno = null)
    {
        // validation for constraint: int
        if (!is_null($anno) && !(is_int($anno) || ctype_digit($anno))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($anno, true), gettype($anno)), __LINE__);
        }
        $this->anno = $anno;
        return $this;
    }
    /**
     * Get idStruttura value
     * @return int
     */
    public function getIdStruttura()
    {
        return $this->idStruttura;
    }
    /**
     * Set idStruttura value
     * @param int $idStruttura
     * @return \StructType\GetMensile
     */
    public function setIdStruttura($idStruttura = null)
    {
        // validation for constraint: int
        if (!is_null($idStruttura) && !(is_int($idStruttura) || ctype_digit($idStruttura))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idStruttura, true), gettype($idStruttura)), __LINE__);
        }
        $this->idStruttura = $idStruttura;
        return $this;
    }
}
