<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfRisultatoV11 ArrayType
 * @subpackage Arrays
 */
class ArrayOfRisultatoV11 extends AbstractStructArrayBase
{
    /**
     * The partenza
     * Meta information extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\RisultatoV1[]
     */
    public $partenza;
    /**
     * Constructor method for ArrayOfRisultatoV11
     * @uses ArrayOfRisultatoV11::setPartenza()
     * @param \StructType\RisultatoV1[] $partenza
     */
    public function __construct(array $partenza = array())
    {
        $this
            ->setPartenza($partenza);
    }
    /**
     * Get partenza value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\RisultatoV1[]|null
     */
    public function getPartenza()
    {
        return isset($this->partenza) ? $this->partenza : null;
    }
    /**
     * This method is responsible for validating the values passed to the setPartenza method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPartenza method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePartenzaForArrayConstraintsFromSetPartenza(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfRisultatoV11PartenzaItem) {
            // validation for constraint: itemType
            if (!$arrayOfRisultatoV11PartenzaItem instanceof \StructType\RisultatoV1) {
                $invalidValues[] = is_object($arrayOfRisultatoV11PartenzaItem) ? get_class($arrayOfRisultatoV11PartenzaItem) : sprintf('%s(%s)', gettype($arrayOfRisultatoV11PartenzaItem), var_export($arrayOfRisultatoV11PartenzaItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The partenza property can only contain items of type \StructType\RisultatoV1, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set partenza value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\RisultatoV1[] $partenza
     * @return \ArrayType\ArrayOfRisultatoV11
     */
    public function setPartenza(array $partenza = array())
    {
        // validation for constraint: array
        if ('' !== ($partenzaArrayErrorMessage = self::validatePartenzaForArrayConstraintsFromSetPartenza($partenza))) {
            throw new \InvalidArgumentException($partenzaArrayErrorMessage, __LINE__);
        }
        if (is_null($partenza) || (is_array($partenza) && empty($partenza))) {
            unset($this->partenza);
        } else {
            $this->partenza = $partenza;
        }
        return $this;
    }
    /**
     * Add item to partenza value
     * @throws \InvalidArgumentException
     * @param \StructType\RisultatoV1 $item
     * @return \ArrayType\ArrayOfRisultatoV11
     */
    public function addToPartenza(\StructType\RisultatoV1 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RisultatoV1) {
            throw new \InvalidArgumentException(sprintf('The partenza property can only contain items of type \StructType\RisultatoV1, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->partenza[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\RisultatoV1|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\RisultatoV1|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\RisultatoV1|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\RisultatoV1|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\RisultatoV1|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string partenza
     */
    public function getAttributeName()
    {
        return 'partenza';
    }
}
