<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for xmlImportDati StructType
 * @subpackage Structs
 */
class XmlImportDati extends AbstractStructBase
{
    /**
     * The codice
     * Meta information extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $codice;
    /**
     * The prodotto
     * Meta information extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $prodotto;
    /**
     * The movimento
     * Meta information extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\MovimentoBean[]
     */
    public $movimento;
    /**
     * Constructor method for xmlImportDati
     * @uses XmlImportDati::setCodice()
     * @uses XmlImportDati::setProdotto()
     * @uses XmlImportDati::setMovimento()
     * @param string $codice
     * @param string $prodotto
     * @param \StructType\MovimentoBean[] $movimento
     */
    public function __construct($codice = null, $prodotto = null, array $movimento = array())
    {
        $this
            ->setCodice($codice)
            ->setProdotto($prodotto)
            ->setMovimento($movimento);
    }
    /**
     * Get codice value
     * @return string|null
     */
    public function getCodice()
    {
        return $this->codice;
    }
    /**
     * Set codice value
     * @param string $codice
     * @return \StructType\XmlImportDati
     */
    public function setCodice($codice = null)
    {
        // validation for constraint: string
        if (!is_null($codice) && !is_string($codice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codice, true), gettype($codice)), __LINE__);
        }
        $this->codice = $codice;
        return $this;
    }
    /**
     * Get prodotto value
     * @return string|null
     */
    public function getProdotto()
    {
        return $this->prodotto;
    }
    /**
     * Set prodotto value
     * @param string $prodotto
     * @return \StructType\XmlImportDati
     */
    public function setProdotto($prodotto = null)
    {
        // validation for constraint: string
        if (!is_null($prodotto) && !is_string($prodotto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prodotto, true), gettype($prodotto)), __LINE__);
        }
        $this->prodotto = $prodotto;
        return $this;
    }
    /**
     * Get movimento value
     * @return \StructType\MovimentoBean[]|null
     */
    public function getMovimento()
    {
        return $this->movimento;
    }
    /**
     * This method is responsible for validating the values passed to the setMovimento method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMovimento method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMovimentoForArrayConstraintsFromSetMovimento(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $xmlImportDatiMovimentoItem) {
            // validation for constraint: itemType
            if (!$xmlImportDatiMovimentoItem instanceof \StructType\MovimentoBean) {
                $invalidValues[] = is_object($xmlImportDatiMovimentoItem) ? get_class($xmlImportDatiMovimentoItem) : sprintf('%s(%s)', gettype($xmlImportDatiMovimentoItem), var_export($xmlImportDatiMovimentoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The movimento property can only contain items of type \StructType\MovimentoBean, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set movimento value
     * @throws \InvalidArgumentException
     * @param \StructType\MovimentoBean[] $movimento
     * @return \StructType\XmlImportDati
     */
    public function setMovimento(array $movimento = array())
    {
        // validation for constraint: array
        if ('' !== ($movimentoArrayErrorMessage = self::validateMovimentoForArrayConstraintsFromSetMovimento($movimento))) {
            throw new \InvalidArgumentException($movimentoArrayErrorMessage, __LINE__);
        }
        $this->movimento = $movimento;
        return $this;
    }
    /**
     * Add item to movimento value
     * @throws \InvalidArgumentException
     * @param \StructType\MovimentoBean $item
     * @return \StructType\XmlImportDati
     */
    public function addToMovimento(\StructType\MovimentoBean $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\MovimentoBean) {
            throw new \InvalidArgumentException(sprintf('The movimento property can only contain items of type \StructType\MovimentoBean, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->movimento[] = $item;
        return $this;
    }
}
